/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes a particular function to invoke.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SeqMapTask extends com.google.api.client.json.GenericJson {

  /**
   * Information about each of the inputs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SideInputInfo> inputs;

  /**
   * The user-provided name of the SeqDo operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Information about each of the outputs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SeqMapTaskOutputInfo> outputInfos;

  /**
   * System-defined name of the stage containing the SeqDo operation. Unique across the workflow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stageName;

  /**
   * System-defined name of the SeqDo operation. Unique across the workflow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String systemName;

  /**
   * The user function to invoke.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> userFn;

  /**
   * Information about each of the inputs.
   * @return value or {@code null} for none
   */
  public java.util.List<SideInputInfo> getInputs() {
    return inputs;
  }

  /**
   * Information about each of the inputs.
   * @param inputs inputs or {@code null} for none
   */
  public SeqMapTask setInputs(java.util.List<SideInputInfo> inputs) {
    this.inputs = inputs;
    return this;
  }

  /**
   * The user-provided name of the SeqDo operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The user-provided name of the SeqDo operation.
   * @param name name or {@code null} for none
   */
  public SeqMapTask setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Information about each of the outputs.
   * @return value or {@code null} for none
   */
  public java.util.List<SeqMapTaskOutputInfo> getOutputInfos() {
    return outputInfos;
  }

  /**
   * Information about each of the outputs.
   * @param outputInfos outputInfos or {@code null} for none
   */
  public SeqMapTask setOutputInfos(java.util.List<SeqMapTaskOutputInfo> outputInfos) {
    this.outputInfos = outputInfos;
    return this;
  }

  /**
   * System-defined name of the stage containing the SeqDo operation. Unique across the workflow.
   * @return value or {@code null} for none
   */
  public java.lang.String getStageName() {
    return stageName;
  }

  /**
   * System-defined name of the stage containing the SeqDo operation. Unique across the workflow.
   * @param stageName stageName or {@code null} for none
   */
  public SeqMapTask setStageName(java.lang.String stageName) {
    this.stageName = stageName;
    return this;
  }

  /**
   * System-defined name of the SeqDo operation. Unique across the workflow.
   * @return value or {@code null} for none
   */
  public java.lang.String getSystemName() {
    return systemName;
  }

  /**
   * System-defined name of the SeqDo operation. Unique across the workflow.
   * @param systemName systemName or {@code null} for none
   */
  public SeqMapTask setSystemName(java.lang.String systemName) {
    this.systemName = systemName;
    return this;
  }

  /**
   * The user function to invoke.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getUserFn() {
    return userFn;
  }

  /**
   * The user function to invoke.
   * @param userFn userFn or {@code null} for none
   */
  public SeqMapTask setUserFn(java.util.Map<String, java.lang.Object> userFn) {
    this.userFn = userFn;
    return this;
  }

  @Override
  public SeqMapTask set(String fieldName, Object value) {
    return (SeqMapTask) super.set(fieldName, value);
  }

  @Override
  public SeqMapTask clone() {
    return (SeqMapTask) super.clone();
  }

}
