/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Defines a SDK harness container for executing Dataflow pipelines.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SdkHarnessContainerImage extends com.google.api.client.json.GenericJson {

  /**
   * A docker container image that resides in Google Container Registry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String containerImage;

  /**
   * Environment ID for the Beam runner API proto Environment that corresponds to the current SDK
   * Harness.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String environmentId;

  /**
   * If true, recommends the Dataflow service to use only one core per SDK container instance with
   * this image. If false (or unset) recommends using more than one core per SDK container instance
   * with this image for efficiency. Note that Dataflow service may choose to override this property
   * if needed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useSingleCorePerContainer;

  /**
   * A docker container image that resides in Google Container Registry.
   * @return value or {@code null} for none
   */
  public java.lang.String getContainerImage() {
    return containerImage;
  }

  /**
   * A docker container image that resides in Google Container Registry.
   * @param containerImage containerImage or {@code null} for none
   */
  public SdkHarnessContainerImage setContainerImage(java.lang.String containerImage) {
    this.containerImage = containerImage;
    return this;
  }

  /**
   * Environment ID for the Beam runner API proto Environment that corresponds to the current SDK
   * Harness.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnvironmentId() {
    return environmentId;
  }

  /**
   * Environment ID for the Beam runner API proto Environment that corresponds to the current SDK
   * Harness.
   * @param environmentId environmentId or {@code null} for none
   */
  public SdkHarnessContainerImage setEnvironmentId(java.lang.String environmentId) {
    this.environmentId = environmentId;
    return this;
  }

  /**
   * If true, recommends the Dataflow service to use only one core per SDK container instance with
   * this image. If false (or unset) recommends using more than one core per SDK container instance
   * with this image for efficiency. Note that Dataflow service may choose to override this property
   * if needed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseSingleCorePerContainer() {
    return useSingleCorePerContainer;
  }

  /**
   * If true, recommends the Dataflow service to use only one core per SDK container instance with
   * this image. If false (or unset) recommends using more than one core per SDK container instance
   * with this image for efficiency. Note that Dataflow service may choose to override this property
   * if needed.
   * @param useSingleCorePerContainer useSingleCorePerContainer or {@code null} for none
   */
  public SdkHarnessContainerImage setUseSingleCorePerContainer(java.lang.Boolean useSingleCorePerContainer) {
    this.useSingleCorePerContainer = useSingleCorePerContainer;
    return this;
  }

  @Override
  public SdkHarnessContainerImage set(String fieldName, Object value) {
    return (SdkHarnessContainerImage) super.set(fieldName, value);
  }

  @Override
  public SdkHarnessContainerImage clone() {
    return (SdkHarnessContainerImage) super.clone();
  }

}
