/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Add a tag to the current TemplateVersion. If tag exist in another TemplateVersion in the
 * Template, remove the tag before add it to the current TemplateVersion. If remove_only set, remove
 * the tag from the current TemplateVersion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModifyTemplateVersionTagRequest extends com.google.api.client.json.GenericJson {

  /**
   * The flag that indicates if the request is only for remove tag from TemplateVersion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean removeOnly;

  /**
   * The tag for update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tag;

  /**
   * The flag that indicates if the request is only for remove tag from TemplateVersion.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRemoveOnly() {
    return removeOnly;
  }

  /**
   * The flag that indicates if the request is only for remove tag from TemplateVersion.
   * @param removeOnly removeOnly or {@code null} for none
   */
  public ModifyTemplateVersionTagRequest setRemoveOnly(java.lang.Boolean removeOnly) {
    this.removeOnly = removeOnly;
    return this;
  }

  /**
   * The tag for update.
   * @return value or {@code null} for none
   */
  public java.lang.String getTag() {
    return tag;
  }

  /**
   * The tag for update.
   * @param tag tag or {@code null} for none
   */
  public ModifyTemplateVersionTagRequest setTag(java.lang.String tag) {
    this.tag = tag;
    return this;
  }

  @Override
  public ModifyTemplateVersionTagRequest set(String fieldName, Object value) {
    return (ModifyTemplateVersionTagRequest) super.set(fieldName, value);
  }

  @Override
  public ModifyTemplateVersionTagRequest clone() {
    return (ModifyTemplateVersionTagRequest) super.clone();
  }

}
