/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * When a task splits using WorkItemStatus.dynamic_source_split, this message describes the two
 * parts of the split relative to the description of the current task's input.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DynamicSourceSplit extends com.google.api.client.json.GenericJson {

  /**
   * Primary part (continued to be processed by worker). Specified relative to the previously-
   * current source. Becomes current.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DerivedSource primary;

  /**
   * Residual part (returned to the pool of work). Specified relative to the previously-current
   * source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DerivedSource residual;

  /**
   * Primary part (continued to be processed by worker). Specified relative to the previously-
   * current source. Becomes current.
   * @return value or {@code null} for none
   */
  public DerivedSource getPrimary() {
    return primary;
  }

  /**
   * Primary part (continued to be processed by worker). Specified relative to the previously-
   * current source. Becomes current.
   * @param primary primary or {@code null} for none
   */
  public DynamicSourceSplit setPrimary(DerivedSource primary) {
    this.primary = primary;
    return this;
  }

  /**
   * Residual part (returned to the pool of work). Specified relative to the previously-current
   * source.
   * @return value or {@code null} for none
   */
  public DerivedSource getResidual() {
    return residual;
  }

  /**
   * Residual part (returned to the pool of work). Specified relative to the previously-current
   * source.
   * @param residual residual or {@code null} for none
   */
  public DynamicSourceSplit setResidual(DerivedSource residual) {
    this.residual = residual;
    return this;
  }

  @Override
  public DynamicSourceSplit set(String fieldName, Object value) {
    return (DynamicSourceSplit) super.set(fieldName, value);
  }

  @Override
  public DynamicSourceSplit clone() {
    return (DynamicSourceSplit) super.clone();
  }

}
