/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Job information for templates.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Artifact extends com.google.api.client.json.GenericJson {

  /**
   * Container image path set for flex Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ContainerSpec containerSpec;

  /**
   * job_graph_gcs_path set for legacy Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jobGraphGcsPath;

  /**
   * Metadata set for legacy Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TemplateMetadata metadata;

  /**
   * Container image path set for flex Template.
   * @return value or {@code null} for none
   */
  public ContainerSpec getContainerSpec() {
    return containerSpec;
  }

  /**
   * Container image path set for flex Template.
   * @param containerSpec containerSpec or {@code null} for none
   */
  public Artifact setContainerSpec(ContainerSpec containerSpec) {
    this.containerSpec = containerSpec;
    return this;
  }

  /**
   * job_graph_gcs_path set for legacy Template.
   * @return value or {@code null} for none
   */
  public java.lang.String getJobGraphGcsPath() {
    return jobGraphGcsPath;
  }

  /**
   * job_graph_gcs_path set for legacy Template.
   * @param jobGraphGcsPath jobGraphGcsPath or {@code null} for none
   */
  public Artifact setJobGraphGcsPath(java.lang.String jobGraphGcsPath) {
    this.jobGraphGcsPath = jobGraphGcsPath;
    return this;
  }

  /**
   * Metadata set for legacy Template.
   * @return value or {@code null} for none
   */
  public TemplateMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata set for legacy Template.
   * @param metadata metadata or {@code null} for none
   */
  public Artifact setMetadata(TemplateMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  @Override
  public Artifact set(String fieldName, Object value) {
    return (Artifact) super.set(fieldName, value);
  }

  @Override
  public Artifact clone() {
    return (Artifact) super.clone();
  }

}
