# Dataflow API Client Library for Java

Manages Google Cloud Dataflow projects on Google Cloud Platform.

This page contains information about getting started with the Dataflow API
using the Google API Client Library for Java. In addition, you may be interested
in the following documentation:

* Browse the [Javadoc reference for the Dataflow API][javadoc]
* Read the [Developer's Guide for the Google API Client Library for Java][google-api-client].
* Interact with this API in your browser using the [APIs Explorer for the Dataflow API][api-explorer]

## Installation

### Maven

Add the following lines to your `pom.xml` file:

```xml
<project>
  <dependencies>
    <dependency>
      <groupId>com.google.apis</groupId>
      <artifactId>google-api-services-dataflow</artifactId>
      <version>v1b3-rev20210818-1.32.1</version>
    </dependency>
  </dependencies>
</project>
```

### Gradle

```gradle
repositories {
  mavenCentral()
}
dependencies {
  compile 'com.google.apis:google-api-services-dataflow:v1b3-rev20210818-1.32.1'
}
```

[javadoc]: https://googleapis.dev/java/google-api-services-dataflow/latest/index.html
[google-api-client]: https://github.com/googleapis/google-api-java-client/
[api-explorer]: https://developers.google.com/apis-explorer/#p/dataflow/v1/
