/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A report of an event in a worker's lifecycle. The proto contains one event, because the worker is
 * expected to asynchronously send each message immediately after the event. Due to this asynchrony,
 * messages may arrive out of order (or missing), and it is up to the consumer to interpret. The
 * timestamp of the event is in the enclosing WorkerMessage proto.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkerLifecycleEvent extends com.google.api.client.json.GenericJson {

  /**
   * The start time of this container. All events will report this so that events can be grouped
   * together across container/VM restarts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String containerStartTime;

  /**
   * The event being reported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String event;

  /**
   * Other stats that can accompany an event. E.g. { "downloaded_bytes" : "123456" }
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> metadata;

  /**
   * The start time of this container. All events will report this so that events can be grouped
   * together across container/VM restarts.
   * @return value or {@code null} for none
   */
  public String getContainerStartTime() {
    return containerStartTime;
  }

  /**
   * The start time of this container. All events will report this so that events can be grouped
   * together across container/VM restarts.
   * @param containerStartTime containerStartTime or {@code null} for none
   */
  public WorkerLifecycleEvent setContainerStartTime(String containerStartTime) {
    this.containerStartTime = containerStartTime;
    return this;
  }

  /**
   * The event being reported.
   * @return value or {@code null} for none
   */
  public java.lang.String getEvent() {
    return event;
  }

  /**
   * The event being reported.
   * @param event event or {@code null} for none
   */
  public WorkerLifecycleEvent setEvent(java.lang.String event) {
    this.event = event;
    return this;
  }

  /**
   * Other stats that can accompany an event. E.g. { "downloaded_bytes" : "123456" }
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getMetadata() {
    return metadata;
  }

  /**
   * Other stats that can accompany an event. E.g. { "downloaded_bytes" : "123456" }
   * @param metadata metadata or {@code null} for none
   */
  public WorkerLifecycleEvent setMetadata(java.util.Map<String, java.lang.String> metadata) {
    this.metadata = metadata;
    return this;
  }

  @Override
  public WorkerLifecycleEvent set(String fieldName, Object value) {
    return (WorkerLifecycleEvent) super.set(fieldName, value);
  }

  @Override
  public WorkerLifecycleEvent clone() {
    return (WorkerLifecycleEvent) super.clone();
  }

}
