/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A task which initializes part of a streaming Dataflow job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingSetupTask extends com.google.api.client.json.GenericJson {

  /**
   * The user has requested drain.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean drain;

  /**
   * The TCP port on which the worker should listen for messages from other streaming computation
   * workers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer receiveWorkPort;

  /**
   * Configures streaming appliance snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StreamingApplianceSnapshotConfig snapshotConfig;

  /**
   * The global topology of the streaming Dataflow job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TopologyConfig streamingComputationTopology;

  /**
   * The TCP port used by the worker to communicate with the Dataflow worker harness.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer workerHarnessPort;

  /**
   * The user has requested drain.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDrain() {
    return drain;
  }

  /**
   * The user has requested drain.
   * @param drain drain or {@code null} for none
   */
  public StreamingSetupTask setDrain(java.lang.Boolean drain) {
    this.drain = drain;
    return this;
  }

  /**
   * The TCP port on which the worker should listen for messages from other streaming computation
   * workers.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getReceiveWorkPort() {
    return receiveWorkPort;
  }

  /**
   * The TCP port on which the worker should listen for messages from other streaming computation
   * workers.
   * @param receiveWorkPort receiveWorkPort or {@code null} for none
   */
  public StreamingSetupTask setReceiveWorkPort(java.lang.Integer receiveWorkPort) {
    this.receiveWorkPort = receiveWorkPort;
    return this;
  }

  /**
   * Configures streaming appliance snapshot.
   * @return value or {@code null} for none
   */
  public StreamingApplianceSnapshotConfig getSnapshotConfig() {
    return snapshotConfig;
  }

  /**
   * Configures streaming appliance snapshot.
   * @param snapshotConfig snapshotConfig or {@code null} for none
   */
  public StreamingSetupTask setSnapshotConfig(StreamingApplianceSnapshotConfig snapshotConfig) {
    this.snapshotConfig = snapshotConfig;
    return this;
  }

  /**
   * The global topology of the streaming Dataflow job.
   * @return value or {@code null} for none
   */
  public TopologyConfig getStreamingComputationTopology() {
    return streamingComputationTopology;
  }

  /**
   * The global topology of the streaming Dataflow job.
   * @param streamingComputationTopology streamingComputationTopology or {@code null} for none
   */
  public StreamingSetupTask setStreamingComputationTopology(TopologyConfig streamingComputationTopology) {
    this.streamingComputationTopology = streamingComputationTopology;
    return this;
  }

  /**
   * The TCP port used by the worker to communicate with the Dataflow worker harness.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWorkerHarnessPort() {
    return workerHarnessPort;
  }

  /**
   * The TCP port used by the worker to communicate with the Dataflow worker harness.
   * @param workerHarnessPort workerHarnessPort or {@code null} for none
   */
  public StreamingSetupTask setWorkerHarnessPort(java.lang.Integer workerHarnessPort) {
    this.workerHarnessPort = workerHarnessPort;
    return this;
  }

  @Override
  public StreamingSetupTask set(String fieldName, Object value) {
    return (StreamingSetupTask) super.set(fieldName, value);
  }

  @Override
  public StreamingSetupTask clone() {
    return (StreamingSetupTask) super.clone();
  }

}
