/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes full or partial data disk assignment information of the computation ranges.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingComputationRanges extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String computationId;

  /**
   * Data disk assignments for ranges from this computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<KeyRangeDataDiskAssignment> rangeAssignments;

  static {
    // hack to force ProGuard to consider KeyRangeDataDiskAssignment used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(KeyRangeDataDiskAssignment.class);
  }

  /**
   * The ID of the computation.
   * @return value or {@code null} for none
   */
  public java.lang.String getComputationId() {
    return computationId;
  }

  /**
   * The ID of the computation.
   * @param computationId computationId or {@code null} for none
   */
  public StreamingComputationRanges setComputationId(java.lang.String computationId) {
    this.computationId = computationId;
    return this;
  }

  /**
   * Data disk assignments for ranges from this computation.
   * @return value or {@code null} for none
   */
  public java.util.List<KeyRangeDataDiskAssignment> getRangeAssignments() {
    return rangeAssignments;
  }

  /**
   * Data disk assignments for ranges from this computation.
   * @param rangeAssignments rangeAssignments or {@code null} for none
   */
  public StreamingComputationRanges setRangeAssignments(java.util.List<KeyRangeDataDiskAssignment> rangeAssignments) {
    this.rangeAssignments = rangeAssignments;
    return this;
  }

  @Override
  public StreamingComputationRanges set(String fieldName, Object value) {
    return (StreamingComputationRanges) super.set(fieldName, value);
  }

  @Override
  public StreamingComputationRanges clone() {
    return (StreamingComputationRanges) super.clone();
  }

}
