/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Response to a request to list job messages.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListJobMessagesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Autoscaling events in ascending timestamp order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AutoscalingEvent> autoscalingEvents;

  static {
    // hack to force ProGuard to consider AutoscalingEvent used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AutoscalingEvent.class);
  }

  /**
   * Messages in ascending timestamp order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<JobMessage> jobMessages;

  static {
    // hack to force ProGuard to consider JobMessage used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(JobMessage.class);
  }

  /**
   * The token to obtain the next page of results if there are more.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Autoscaling events in ascending timestamp order.
   * @return value or {@code null} for none
   */
  public java.util.List<AutoscalingEvent> getAutoscalingEvents() {
    return autoscalingEvents;
  }

  /**
   * Autoscaling events in ascending timestamp order.
   * @param autoscalingEvents autoscalingEvents or {@code null} for none
   */
  public ListJobMessagesResponse setAutoscalingEvents(java.util.List<AutoscalingEvent> autoscalingEvents) {
    this.autoscalingEvents = autoscalingEvents;
    return this;
  }

  /**
   * Messages in ascending timestamp order.
   * @return value or {@code null} for none
   */
  public java.util.List<JobMessage> getJobMessages() {
    return jobMessages;
  }

  /**
   * Messages in ascending timestamp order.
   * @param jobMessages jobMessages or {@code null} for none
   */
  public ListJobMessagesResponse setJobMessages(java.util.List<JobMessage> jobMessages) {
    this.jobMessages = jobMessages;
    return this;
  }

  /**
   * The token to obtain the next page of results if there are more.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The token to obtain the next page of results if there are more.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListJobMessagesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListJobMessagesResponse set(String fieldName, Object value) {
    return (ListJobMessagesResponse) super.set(fieldName, value);
  }

  @Override
  public ListJobMessagesResponse clone() {
    return (ListJobMessagesResponse) super.clone();
  }

}
