/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Request to lease WorkItems.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LeaseWorkItemRequest extends com.google.api.client.json.GenericJson {

  /**
   * The current timestamp at the worker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String currentWorkerTime;

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the WorkItem's job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * The initial lease period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String requestedLeaseDuration;

  /**
   * Untranslated bag-of-bytes WorkRequest from UnifiedWorker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> unifiedWorkerRequest;

  /**
   * Filter for WorkItem type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> workItemTypes;

  /**
   * Worker capabilities. WorkItems might be limited to workers with specific capabilities.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> workerCapabilities;

  /**
   * Identifies the worker leasing work -- typically the ID of the virtual machine running the
   * worker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workerId;

  /**
   * The current timestamp at the worker.
   * @return value or {@code null} for none
   */
  public String getCurrentWorkerTime() {
    return currentWorkerTime;
  }

  /**
   * The current timestamp at the worker.
   * @param currentWorkerTime currentWorkerTime or {@code null} for none
   */
  public LeaseWorkItemRequest setCurrentWorkerTime(String currentWorkerTime) {
    this.currentWorkerTime = currentWorkerTime;
    return this;
  }

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the WorkItem's job.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints)
   * that contains the WorkItem's job.
   * @param location location or {@code null} for none
   */
  public LeaseWorkItemRequest setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * The initial lease period.
   * @return value or {@code null} for none
   */
  public String getRequestedLeaseDuration() {
    return requestedLeaseDuration;
  }

  /**
   * The initial lease period.
   * @param requestedLeaseDuration requestedLeaseDuration or {@code null} for none
   */
  public LeaseWorkItemRequest setRequestedLeaseDuration(String requestedLeaseDuration) {
    this.requestedLeaseDuration = requestedLeaseDuration;
    return this;
  }

  /**
   * Untranslated bag-of-bytes WorkRequest from UnifiedWorker.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getUnifiedWorkerRequest() {
    return unifiedWorkerRequest;
  }

  /**
   * Untranslated bag-of-bytes WorkRequest from UnifiedWorker.
   * @param unifiedWorkerRequest unifiedWorkerRequest or {@code null} for none
   */
  public LeaseWorkItemRequest setUnifiedWorkerRequest(java.util.Map<String, java.lang.Object> unifiedWorkerRequest) {
    this.unifiedWorkerRequest = unifiedWorkerRequest;
    return this;
  }

  /**
   * Filter for WorkItem type.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getWorkItemTypes() {
    return workItemTypes;
  }

  /**
   * Filter for WorkItem type.
   * @param workItemTypes workItemTypes or {@code null} for none
   */
  public LeaseWorkItemRequest setWorkItemTypes(java.util.List<java.lang.String> workItemTypes) {
    this.workItemTypes = workItemTypes;
    return this;
  }

  /**
   * Worker capabilities. WorkItems might be limited to workers with specific capabilities.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getWorkerCapabilities() {
    return workerCapabilities;
  }

  /**
   * Worker capabilities. WorkItems might be limited to workers with specific capabilities.
   * @param workerCapabilities workerCapabilities or {@code null} for none
   */
  public LeaseWorkItemRequest setWorkerCapabilities(java.util.List<java.lang.String> workerCapabilities) {
    this.workerCapabilities = workerCapabilities;
    return this;
  }

  /**
   * Identifies the worker leasing work -- typically the ID of the virtual machine running the
   * worker.
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkerId() {
    return workerId;
  }

  /**
   * Identifies the worker leasing work -- typically the ID of the virtual machine running the
   * worker.
   * @param workerId workerId or {@code null} for none
   */
  public LeaseWorkItemRequest setWorkerId(java.lang.String workerId) {
    this.workerId = workerId;
    return this;
  }

  @Override
  public LeaseWorkItemRequest set(String fieldName, Object value) {
    return (LeaseWorkItemRequest) super.set(fieldName, value);
  }

  @Override
  public LeaseWorkItemRequest clone() {
    return (LeaseWorkItemRequest) super.clone();
  }

}
