/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Data disk assignment for a given VM instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataDiskAssignment extends com.google.api.client.json.GenericJson {

  /**
   * Mounted data disks. The order is important a data disk's 0-based index in this list defines
   * which persistent directory the disk is mounted to, for example the list of {
   * "myproject-1014-104817-4c2-harness-0-disk-0" }, { "myproject-1014-104817-4c2-harness-0-disk-1"
   * }.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> dataDisks;

  /**
   * VM instance name the data disks mounted to, for example "myproject-1014-104817-4c2-harness-0".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmInstance;

  /**
   * Mounted data disks. The order is important a data disk's 0-based index in this list defines
   * which persistent directory the disk is mounted to, for example the list of {
   * "myproject-1014-104817-4c2-harness-0-disk-0" }, { "myproject-1014-104817-4c2-harness-0-disk-1"
   * }.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDataDisks() {
    return dataDisks;
  }

  /**
   * Mounted data disks. The order is important a data disk's 0-based index in this list defines
   * which persistent directory the disk is mounted to, for example the list of {
   * "myproject-1014-104817-4c2-harness-0-disk-0" }, { "myproject-1014-104817-4c2-harness-0-disk-1"
   * }.
   * @param dataDisks dataDisks or {@code null} for none
   */
  public DataDiskAssignment setDataDisks(java.util.List<java.lang.String> dataDisks) {
    this.dataDisks = dataDisks;
    return this;
  }

  /**
   * VM instance name the data disks mounted to, for example "myproject-1014-104817-4c2-harness-0".
   * @return value or {@code null} for none
   */
  public java.lang.String getVmInstance() {
    return vmInstance;
  }

  /**
   * VM instance name the data disks mounted to, for example "myproject-1014-104817-4c2-harness-0".
   * @param vmInstance vmInstance or {@code null} for none
   */
  public DataDiskAssignment setVmInstance(java.lang.String vmInstance) {
    this.vmInstance = vmInstance;
    return this;
  }

  @Override
  public DataDiskAssignment set(String fieldName, Object value) {
    return (DataDiskAssignment) super.set(fieldName, value);
  }

  @Override
  public DataDiskAssignment clone() {
    return (DataDiskAssignment) super.clone();
  }

}
