/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * An instruction that writes records. Takes one input, produces no outputs.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WriteInstruction extends com.google.api.client.json.GenericJson {

  /**
   * The input.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstructionInput input;

  /**
   * The sink to write to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Sink sink;

  /**
   * The input.
   * @return value or {@code null} for none
   */
  public InstructionInput getInput() {
    return input;
  }

  /**
   * The input.
   * @param input input or {@code null} for none
   */
  public WriteInstruction setInput(InstructionInput input) {
    this.input = input;
    return this;
  }

  /**
   * The sink to write to.
   * @return value or {@code null} for none
   */
  public Sink getSink() {
    return sink;
  }

  /**
   * The sink to write to.
   * @param sink sink or {@code null} for none
   */
  public WriteInstruction setSink(Sink sink) {
    this.sink = sink;
    return this;
  }

  @Override
  public WriteInstruction set(String fieldName, Object value) {
    return (WriteInstruction) super.set(fieldName, value);
  }

  @Override
  public WriteInstruction clone() {
    return (WriteInstruction) super.clone();
  }

}
