/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes one particular pool of Cloud Dataflow workers to be instantiated by the Cloud Dataflow
 * service in order to perform the computations required by a job. Note that a workflow job may use
 * multiple pools, in order to match the various computational requirements of the various stages of
 * the job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkerPool extends com.google.api.client.json.GenericJson {

  /**
   * Settings for autoscaling of this WorkerPool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoscalingSettings autoscalingSettings;

  /**
   * Data disks that are used by a VM in this workflow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Disk> dataDisks;

  static {
    // hack to force ProGuard to consider Disk used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Disk.class);
  }

  /**
   * The default package set to install. This allows the service to select a default set of packages
   * which are useful to worker harnesses written in a particular language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultPackageSet;

  /**
   * Size of root disk for VMs, in GB. If zero or unspecified, the service will attempt to choose a
   * reasonable default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer diskSizeGb;

  /**
   * Fully qualified source image for disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskSourceImage;

  /**
   * Type of root disk for VMs. If empty or unspecified, the service will attempt to choose a
   * reasonable default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskType;

  /**
   * Configuration for VM IPs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipConfiguration;

  /**
   * The kind of the worker pool; currently only `harness` and `shuffle` are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Machine type (e.g. "n1-standard-1"). If empty or unspecified, the service will attempt to
   * choose a reasonable default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * Metadata to set on the Google Compute Engine VMs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> metadata;

  /**
   * Network to which VMs will be assigned. If empty or unspecified, the service will use the
   * network "default".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * The number of threads per worker harness. If empty or unspecified, the service will choose a
   * number of threads (according to the number of cores on the selected machine type for batch, or
   * 1 by convention for streaming).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numThreadsPerWorker;

  /**
   * Number of Google Compute Engine workers in this pool needed to execute the job. If zero or
   * unspecified, the service will attempt to choose a reasonable default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numWorkers;

  /**
   * The action to take on host maintenance, as defined by the Google Compute Engine API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String onHostMaintenance;

  /**
   * Packages to be installed on workers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataflowPackage> packages;

  static {
    // hack to force ProGuard to consider DataflowPackage used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DataflowPackage.class);
  }

  /**
   * Extra arguments for this worker pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> poolArgs;

  /**
   * Set of SDK harness containers needed to execute this pipeline. This will only be set in the Fn
   * API path. For non-cross-language pipelines this should have only one entry. Cross-language
   * pipelines will have two or more entries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SdkHarnessContainerImage> sdkHarnessContainerImages;

  static {
    // hack to force ProGuard to consider SdkHarnessContainerImage used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SdkHarnessContainerImage.class);
  }

  /**
   * Subnetwork to which VMs will be assigned, if desired. Expected to be of the form
   * "regions/REGION/subnetworks/SUBNETWORK".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnetwork;

  /**
   * Settings passed through to Google Compute Engine workers when using the standard Dataflow task
   * runner. Users should ignore this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TaskRunnerSettings taskrunnerSettings;

  /**
   * Sets the policy for determining when to turndown worker pool. Allowed values are:
   * `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and `TEARDOWN_NEVER`. `TEARDOWN_ALWAYS` means workers
   * are always torn down regardless of whether the job succeeds. `TEARDOWN_ON_SUCCESS` means
   * workers are torn down if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn
   * down. If the workers are not torn down by the service, they will continue to run and use Google
   * Compute Engine VM resources in the user's project until they are explicitly terminated by the
   * user. Because of this, Google recommends using the `TEARDOWN_ALWAYS` policy except for small,
   * manually supervised test jobs. If unknown or unspecified, the service will attempt to choose a
   * reasonable default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String teardownPolicy;

  /**
   * Required. Docker container image that executes the Cloud Dataflow worker harness, residing in
   * Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images
   * instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workerHarnessContainerImage;

  /**
   * Zone to run the worker pools in. If empty or unspecified, the service will attempt to choose a
   * reasonable default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Settings for autoscaling of this WorkerPool.
   * @return value or {@code null} for none
   */
  public AutoscalingSettings getAutoscalingSettings() {
    return autoscalingSettings;
  }

  /**
   * Settings for autoscaling of this WorkerPool.
   * @param autoscalingSettings autoscalingSettings or {@code null} for none
   */
  public WorkerPool setAutoscalingSettings(AutoscalingSettings autoscalingSettings) {
    this.autoscalingSettings = autoscalingSettings;
    return this;
  }

  /**
   * Data disks that are used by a VM in this workflow.
   * @return value or {@code null} for none
   */
  public java.util.List<Disk> getDataDisks() {
    return dataDisks;
  }

  /**
   * Data disks that are used by a VM in this workflow.
   * @param dataDisks dataDisks or {@code null} for none
   */
  public WorkerPool setDataDisks(java.util.List<Disk> dataDisks) {
    this.dataDisks = dataDisks;
    return this;
  }

  /**
   * The default package set to install. This allows the service to select a default set of packages
   * which are useful to worker harnesses written in a particular language.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultPackageSet() {
    return defaultPackageSet;
  }

  /**
   * The default package set to install. This allows the service to select a default set of packages
   * which are useful to worker harnesses written in a particular language.
   * @param defaultPackageSet defaultPackageSet or {@code null} for none
   */
  public WorkerPool setDefaultPackageSet(java.lang.String defaultPackageSet) {
    this.defaultPackageSet = defaultPackageSet;
    return this;
  }

  /**
   * Size of root disk for VMs, in GB. If zero or unspecified, the service will attempt to choose a
   * reasonable default.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDiskSizeGb() {
    return diskSizeGb;
  }

  /**
   * Size of root disk for VMs, in GB. If zero or unspecified, the service will attempt to choose a
   * reasonable default.
   * @param diskSizeGb diskSizeGb or {@code null} for none
   */
  public WorkerPool setDiskSizeGb(java.lang.Integer diskSizeGb) {
    this.diskSizeGb = diskSizeGb;
    return this;
  }

  /**
   * Fully qualified source image for disks.
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskSourceImage() {
    return diskSourceImage;
  }

  /**
   * Fully qualified source image for disks.
   * @param diskSourceImage diskSourceImage or {@code null} for none
   */
  public WorkerPool setDiskSourceImage(java.lang.String diskSourceImage) {
    this.diskSourceImage = diskSourceImage;
    return this;
  }

  /**
   * Type of root disk for VMs. If empty or unspecified, the service will attempt to choose a
   * reasonable default.
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskType() {
    return diskType;
  }

  /**
   * Type of root disk for VMs. If empty or unspecified, the service will attempt to choose a
   * reasonable default.
   * @param diskType diskType or {@code null} for none
   */
  public WorkerPool setDiskType(java.lang.String diskType) {
    this.diskType = diskType;
    return this;
  }

  /**
   * Configuration for VM IPs.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpConfiguration() {
    return ipConfiguration;
  }

  /**
   * Configuration for VM IPs.
   * @param ipConfiguration ipConfiguration or {@code null} for none
   */
  public WorkerPool setIpConfiguration(java.lang.String ipConfiguration) {
    this.ipConfiguration = ipConfiguration;
    return this;
  }

  /**
   * The kind of the worker pool; currently only `harness` and `shuffle` are supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of the worker pool; currently only `harness` and `shuffle` are supported.
   * @param kind kind or {@code null} for none
   */
  public WorkerPool setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Machine type (e.g. "n1-standard-1"). If empty or unspecified, the service will attempt to
   * choose a reasonable default.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * Machine type (e.g. "n1-standard-1"). If empty or unspecified, the service will attempt to
   * choose a reasonable default.
   * @param machineType machineType or {@code null} for none
   */
  public WorkerPool setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * Metadata to set on the Google Compute Engine VMs.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getMetadata() {
    return metadata;
  }

  /**
   * Metadata to set on the Google Compute Engine VMs.
   * @param metadata metadata or {@code null} for none
   */
  public WorkerPool setMetadata(java.util.Map<String, java.lang.String> metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Network to which VMs will be assigned. If empty or unspecified, the service will use the
   * network "default".
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * Network to which VMs will be assigned. If empty or unspecified, the service will use the
   * network "default".
   * @param network network or {@code null} for none
   */
  public WorkerPool setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * The number of threads per worker harness. If empty or unspecified, the service will choose a
   * number of threads (according to the number of cores on the selected machine type for batch, or
   * 1 by convention for streaming).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumThreadsPerWorker() {
    return numThreadsPerWorker;
  }

  /**
   * The number of threads per worker harness. If empty or unspecified, the service will choose a
   * number of threads (according to the number of cores on the selected machine type for batch, or
   * 1 by convention for streaming).
   * @param numThreadsPerWorker numThreadsPerWorker or {@code null} for none
   */
  public WorkerPool setNumThreadsPerWorker(java.lang.Integer numThreadsPerWorker) {
    this.numThreadsPerWorker = numThreadsPerWorker;
    return this;
  }

  /**
   * Number of Google Compute Engine workers in this pool needed to execute the job. If zero or
   * unspecified, the service will attempt to choose a reasonable default.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumWorkers() {
    return numWorkers;
  }

  /**
   * Number of Google Compute Engine workers in this pool needed to execute the job. If zero or
   * unspecified, the service will attempt to choose a reasonable default.
   * @param numWorkers numWorkers or {@code null} for none
   */
  public WorkerPool setNumWorkers(java.lang.Integer numWorkers) {
    this.numWorkers = numWorkers;
    return this;
  }

  /**
   * The action to take on host maintenance, as defined by the Google Compute Engine API.
   * @return value or {@code null} for none
   */
  public java.lang.String getOnHostMaintenance() {
    return onHostMaintenance;
  }

  /**
   * The action to take on host maintenance, as defined by the Google Compute Engine API.
   * @param onHostMaintenance onHostMaintenance or {@code null} for none
   */
  public WorkerPool setOnHostMaintenance(java.lang.String onHostMaintenance) {
    this.onHostMaintenance = onHostMaintenance;
    return this;
  }

  /**
   * Packages to be installed on workers.
   * @return value or {@code null} for none
   */
  public java.util.List<DataflowPackage> getPackages() {
    return packages;
  }

  /**
   * Packages to be installed on workers.
   * @param packages packages or {@code null} for none
   */
  public WorkerPool setPackages(java.util.List<DataflowPackage> packages) {
    this.packages = packages;
    return this;
  }

  /**
   * Extra arguments for this worker pool.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getPoolArgs() {
    return poolArgs;
  }

  /**
   * Extra arguments for this worker pool.
   * @param poolArgs poolArgs or {@code null} for none
   */
  public WorkerPool setPoolArgs(java.util.Map<String, java.lang.Object> poolArgs) {
    this.poolArgs = poolArgs;
    return this;
  }

  /**
   * Set of SDK harness containers needed to execute this pipeline. This will only be set in the Fn
   * API path. For non-cross-language pipelines this should have only one entry. Cross-language
   * pipelines will have two or more entries.
   * @return value or {@code null} for none
   */
  public java.util.List<SdkHarnessContainerImage> getSdkHarnessContainerImages() {
    return sdkHarnessContainerImages;
  }

  /**
   * Set of SDK harness containers needed to execute this pipeline. This will only be set in the Fn
   * API path. For non-cross-language pipelines this should have only one entry. Cross-language
   * pipelines will have two or more entries.
   * @param sdkHarnessContainerImages sdkHarnessContainerImages or {@code null} for none
   */
  public WorkerPool setSdkHarnessContainerImages(java.util.List<SdkHarnessContainerImage> sdkHarnessContainerImages) {
    this.sdkHarnessContainerImages = sdkHarnessContainerImages;
    return this;
  }

  /**
   * Subnetwork to which VMs will be assigned, if desired. Expected to be of the form
   * "regions/REGION/subnetworks/SUBNETWORK".
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnetwork() {
    return subnetwork;
  }

  /**
   * Subnetwork to which VMs will be assigned, if desired. Expected to be of the form
   * "regions/REGION/subnetworks/SUBNETWORK".
   * @param subnetwork subnetwork or {@code null} for none
   */
  public WorkerPool setSubnetwork(java.lang.String subnetwork) {
    this.subnetwork = subnetwork;
    return this;
  }

  /**
   * Settings passed through to Google Compute Engine workers when using the standard Dataflow task
   * runner. Users should ignore this field.
   * @return value or {@code null} for none
   */
  public TaskRunnerSettings getTaskrunnerSettings() {
    return taskrunnerSettings;
  }

  /**
   * Settings passed through to Google Compute Engine workers when using the standard Dataflow task
   * runner. Users should ignore this field.
   * @param taskrunnerSettings taskrunnerSettings or {@code null} for none
   */
  public WorkerPool setTaskrunnerSettings(TaskRunnerSettings taskrunnerSettings) {
    this.taskrunnerSettings = taskrunnerSettings;
    return this;
  }

  /**
   * Sets the policy for determining when to turndown worker pool. Allowed values are:
   * `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and `TEARDOWN_NEVER`. `TEARDOWN_ALWAYS` means workers
   * are always torn down regardless of whether the job succeeds. `TEARDOWN_ON_SUCCESS` means
   * workers are torn down if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn
   * down. If the workers are not torn down by the service, they will continue to run and use Google
   * Compute Engine VM resources in the user's project until they are explicitly terminated by the
   * user. Because of this, Google recommends using the `TEARDOWN_ALWAYS` policy except for small,
   * manually supervised test jobs. If unknown or unspecified, the service will attempt to choose a
   * reasonable default.
   * @return value or {@code null} for none
   */
  public java.lang.String getTeardownPolicy() {
    return teardownPolicy;
  }

  /**
   * Sets the policy for determining when to turndown worker pool. Allowed values are:
   * `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and `TEARDOWN_NEVER`. `TEARDOWN_ALWAYS` means workers
   * are always torn down regardless of whether the job succeeds. `TEARDOWN_ON_SUCCESS` means
   * workers are torn down if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn
   * down. If the workers are not torn down by the service, they will continue to run and use Google
   * Compute Engine VM resources in the user's project until they are explicitly terminated by the
   * user. Because of this, Google recommends using the `TEARDOWN_ALWAYS` policy except for small,
   * manually supervised test jobs. If unknown or unspecified, the service will attempt to choose a
   * reasonable default.
   * @param teardownPolicy teardownPolicy or {@code null} for none
   */
  public WorkerPool setTeardownPolicy(java.lang.String teardownPolicy) {
    this.teardownPolicy = teardownPolicy;
    return this;
  }

  /**
   * Required. Docker container image that executes the Cloud Dataflow worker harness, residing in
   * Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images
   * instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkerHarnessContainerImage() {
    return workerHarnessContainerImage;
  }

  /**
   * Required. Docker container image that executes the Cloud Dataflow worker harness, residing in
   * Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images
   * instead.
   * @param workerHarnessContainerImage workerHarnessContainerImage or {@code null} for none
   */
  public WorkerPool setWorkerHarnessContainerImage(java.lang.String workerHarnessContainerImage) {
    this.workerHarnessContainerImage = workerHarnessContainerImage;
    return this;
  }

  /**
   * Zone to run the worker pools in. If empty or unspecified, the service will attempt to choose a
   * reasonable default.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * Zone to run the worker pools in. If empty or unspecified, the service will attempt to choose a
   * reasonable default.
   * @param zone zone or {@code null} for none
   */
  public WorkerPool setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public WorkerPool set(String fieldName, Object value) {
    return (WorkerPool) super.set(fieldName, value);
  }

  @Override
  public WorkerPool clone() {
    return (WorkerPool) super.clone();
  }

}
