/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Metadata for a specific parameter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ParameterMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Required. The help text to display for the parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String helpText;

  /**
   * Optional. Whether the parameter is optional. Defaults to false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isOptional;

  /**
   * Required. The label to display for the parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Required. The name of the parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. The type of the parameter. Used for selecting input picker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String paramType;

  /**
   * Optional. Regexes that the parameter must match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> regexes;

  /**
   * Required. The help text to display for the parameter.
   * @return value or {@code null} for none
   */
  public java.lang.String getHelpText() {
    return helpText;
  }

  /**
   * Required. The help text to display for the parameter.
   * @param helpText helpText or {@code null} for none
   */
  public ParameterMetadata setHelpText(java.lang.String helpText) {
    this.helpText = helpText;
    return this;
  }

  /**
   * Optional. Whether the parameter is optional. Defaults to false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsOptional() {
    return isOptional;
  }

  /**
   * Optional. Whether the parameter is optional. Defaults to false.
   * @param isOptional isOptional or {@code null} for none
   */
  public ParameterMetadata setIsOptional(java.lang.Boolean isOptional) {
    this.isOptional = isOptional;
    return this;
  }

  /**
   * Required. The label to display for the parameter.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * Required. The label to display for the parameter.
   * @param label label or {@code null} for none
   */
  public ParameterMetadata setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * Required. The name of the parameter.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The name of the parameter.
   * @param name name or {@code null} for none
   */
  public ParameterMetadata setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. The type of the parameter. Used for selecting input picker.
   * @return value or {@code null} for none
   */
  public java.lang.String getParamType() {
    return paramType;
  }

  /**
   * Optional. The type of the parameter. Used for selecting input picker.
   * @param paramType paramType or {@code null} for none
   */
  public ParameterMetadata setParamType(java.lang.String paramType) {
    this.paramType = paramType;
    return this;
  }

  /**
   * Optional. Regexes that the parameter must match.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRegexes() {
    return regexes;
  }

  /**
   * Optional. Regexes that the parameter must match.
   * @param regexes regexes or {@code null} for none
   */
  public ParameterMetadata setRegexes(java.util.List<java.lang.String> regexes) {
    this.regexes = regexes;
    return this;
  }

  @Override
  public ParameterMetadata set(String fieldName, Object value) {
    return (ParameterMetadata) super.set(fieldName, value);
  }

  @Override
  public ParameterMetadata clone() {
    return (ParameterMetadata) super.clone();
  }

}
