/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A request to create a Cloud Dataflow job from a template.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateJobFromTemplateRequest extends com.google.api.client.json.GenericJson {

  /**
   * The runtime environment for the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RuntimeEnvironment environment;

  /**
   * Required. A Cloud Storage path to the template from which to create the job. Must be a valid
   * Cloud Storage URL, beginning with `gs://`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gcsPath;

  /**
   * Required. The job name to use for the created job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jobName;

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
   * which to direct the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * The runtime parameters to pass to the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> parameters;

  /**
   * The runtime environment for the job.
   * @return value or {@code null} for none
   */
  public RuntimeEnvironment getEnvironment() {
    return environment;
  }

  /**
   * The runtime environment for the job.
   * @param environment environment or {@code null} for none
   */
  public CreateJobFromTemplateRequest setEnvironment(RuntimeEnvironment environment) {
    this.environment = environment;
    return this;
  }

  /**
   * Required. A Cloud Storage path to the template from which to create the job. Must be a valid
   * Cloud Storage URL, beginning with `gs://`.
   * @return value or {@code null} for none
   */
  public java.lang.String getGcsPath() {
    return gcsPath;
  }

  /**
   * Required. A Cloud Storage path to the template from which to create the job. Must be a valid
   * Cloud Storage URL, beginning with `gs://`.
   * @param gcsPath gcsPath or {@code null} for none
   */
  public CreateJobFromTemplateRequest setGcsPath(java.lang.String gcsPath) {
    this.gcsPath = gcsPath;
    return this;
  }

  /**
   * Required. The job name to use for the created job.
   * @return value or {@code null} for none
   */
  public java.lang.String getJobName() {
    return jobName;
  }

  /**
   * Required. The job name to use for the created job.
   * @param jobName jobName or {@code null} for none
   */
  public CreateJobFromTemplateRequest setJobName(java.lang.String jobName) {
    this.jobName = jobName;
    return this;
  }

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
   * which to direct the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
   * which to direct the request.
   * @param location location or {@code null} for none
   */
  public CreateJobFromTemplateRequest setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * The runtime parameters to pass to the job.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getParameters() {
    return parameters;
  }

  /**
   * The runtime parameters to pass to the job.
   * @param parameters parameters or {@code null} for none
   */
  public CreateJobFromTemplateRequest setParameters(java.util.Map<String, java.lang.String> parameters) {
    this.parameters = parameters;
    return this;
  }

  @Override
  public CreateJobFromTemplateRequest set(String fieldName, Object value) {
    return (CreateJobFromTemplateRequest) super.set(fieldName, value);
  }

  @Override
  public CreateJobFromTemplateRequest clone() {
    return (CreateJobFromTemplateRequest) super.clone();
  }

}
