/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Response to the validation request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ValidateResponse extends com.google.api.client.json.GenericJson {

  /**
   * Will be empty if validation succeeds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorMessage;

  /**
   * Information about the validated query. Not defined if validation fails.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QueryInfo queryInfo;

  /**
   * Will be empty if validation succeeds.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorMessage() {
    return errorMessage;
  }

  /**
   * Will be empty if validation succeeds.
   * @param errorMessage errorMessage or {@code null} for none
   */
  public ValidateResponse setErrorMessage(java.lang.String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Information about the validated query. Not defined if validation fails.
   * @return value or {@code null} for none
   */
  public QueryInfo getQueryInfo() {
    return queryInfo;
  }

  /**
   * Information about the validated query. Not defined if validation fails.
   * @param queryInfo queryInfo or {@code null} for none
   */
  public ValidateResponse setQueryInfo(QueryInfo queryInfo) {
    this.queryInfo = queryInfo;
    return this;
  }

  @Override
  public ValidateResponse set(String fieldName, Object value) {
    return (ValidateResponse) super.set(fieldName, value);
  }

  @Override
  public ValidateResponse clone() {
    return (ValidateResponse) super.clone();
  }

}
