/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * // / Template Catalog is used to organize user TemplateVersions. / TemplateVersions that have the
 * same project_id and display_name are / belong to the same Template. / Templates with the same
 * project_id belong to the same Project. / TemplateVersion may have labels and multiple labels are
 * allowed. / Duplicated labels in the same `TemplateVersion` are not allowed. / TemplateVersion may
 * have tags and multiple tags are allowed. Duplicated / tags in the same `Template` are not
 * allowed!
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TemplateVersion extends com.google.api.client.json.GenericJson {

  /**
   * Job graph and metadata if it is a legacy Template. Container image path and metadata if it is
   * flex Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Artifact artifact;

  /**
   * Creation time of this TemplateVersion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Template description from the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A customized name for Template. Multiple TemplateVersions per Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Labels for the Template Version. Labels can be duplicate within Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * A unique project_id. Multiple Templates per Project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Alias for version_id, helps locate a TemplateVersion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * Either LEGACY or FLEX. This should match with the type of artifact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * An auto generated version_id for TemplateVersion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String versionId;

  /**
   * Job graph and metadata if it is a legacy Template. Container image path and metadata if it is
   * flex Template.
   * @return value or {@code null} for none
   */
  public Artifact getArtifact() {
    return artifact;
  }

  /**
   * Job graph and metadata if it is a legacy Template. Container image path and metadata if it is
   * flex Template.
   * @param artifact artifact or {@code null} for none
   */
  public TemplateVersion setArtifact(Artifact artifact) {
    this.artifact = artifact;
    return this;
  }

  /**
   * Creation time of this TemplateVersion.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Creation time of this TemplateVersion.
   * @param createTime createTime or {@code null} for none
   */
  public TemplateVersion setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Template description from the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Template description from the user.
   * @param description description or {@code null} for none
   */
  public TemplateVersion setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A customized name for Template. Multiple TemplateVersions per Template.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A customized name for Template. Multiple TemplateVersions per Template.
   * @param displayName displayName or {@code null} for none
   */
  public TemplateVersion setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Labels for the Template Version. Labels can be duplicate within Template.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels for the Template Version. Labels can be duplicate within Template.
   * @param labels labels or {@code null} for none
   */
  public TemplateVersion setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * A unique project_id. Multiple Templates per Project.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * A unique project_id. Multiple Templates per Project.
   * @param projectId projectId or {@code null} for none
   */
  public TemplateVersion setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Alias for version_id, helps locate a TemplateVersion.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * Alias for version_id, helps locate a TemplateVersion.
   * @param tags tags or {@code null} for none
   */
  public TemplateVersion setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * Either LEGACY or FLEX. This should match with the type of artifact.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Either LEGACY or FLEX. This should match with the type of artifact.
   * @param type type or {@code null} for none
   */
  public TemplateVersion setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * An auto generated version_id for TemplateVersion.
   * @return value or {@code null} for none
   */
  public java.lang.String getVersionId() {
    return versionId;
  }

  /**
   * An auto generated version_id for TemplateVersion.
   * @param versionId versionId or {@code null} for none
   */
  public TemplateVersion setVersionId(java.lang.String versionId) {
    this.versionId = versionId;
    return this;
  }

  @Override
  public TemplateVersion set(String fieldName, Object value) {
    return (TemplateVersion) super.set(fieldName, value);
  }

  @Override
  public TemplateVersion clone() {
    return (TemplateVersion) super.clone();
  }

}
