/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Taskrunner configuration settings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TaskRunnerSettings extends com.google.api.client.json.GenericJson {

  /**
   * Whether to also send taskrunner log info to stderr.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean alsologtostderr;

  /**
   * The location on the worker for task-specific subdirectories.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String baseTaskDir;

  /**
   * The base URL for the taskrunner to use when accessing Google Cloud APIs.
   *
   * When workers access Google Cloud APIs, they logically do so via relative URLs.  If this field
   * is specified, it supplies the base URL to use for resolving these relative URLs.  The normative
   * algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators".
   *
   * If not specified, the default value is "http://www.googleapis.com/"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String baseUrl;

  /**
   * The file to store preprocessing commands in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commandlinesFileName;

  /**
   * Whether to continue taskrunner if an exception is hit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean continueOnException;

  /**
   * The API version of endpoint, e.g. "v1b3"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataflowApiVersion;

  /**
   * The command to launch the worker harness.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String harnessCommand;

  /**
   * The suggested backend language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageHint;

  /**
   * The directory on the VM to store logs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String logDir;

  /**
   * Whether to send taskrunner log info to Google Compute Engine VM serial console.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean logToSerialconsole;

  /**
   * Indicates where to put logs.  If this is not specified, the logs will not be uploaded.
   *
   * The supported resource type is:
   *
   * Google Cloud Storage:   storage.googleapis.com/{bucket}/{object}
   * bucket.storage.googleapis.com/{object}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String logUploadLocation;

  /**
   * The OAuth2 scopes to be requested by the taskrunner in order to access the Cloud Dataflow API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> oauthScopes;

  /**
   * The settings to pass to the parallel worker harness.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WorkerSettings parallelWorkerSettings;

  /**
   * The streaming worker main class name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String streamingWorkerMainClass;

  /**
   * The UNIX group ID on the worker VM to use for tasks launched by taskrunner; e.g. "wheel".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taskGroup;

  /**
   * The UNIX user ID on the worker VM to use for tasks launched by taskrunner; e.g. "root".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taskUser;

  /**
   * The prefix of the resources the taskrunner should use for temporary storage.
   *
   * The supported resource type is:
   *
   * Google Cloud Storage:   storage.googleapis.com/{bucket}/{object}
   * bucket.storage.googleapis.com/{object}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tempStoragePrefix;

  /**
   * The ID string of the VM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmId;

  /**
   * The file to store the workflow in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workflowFileName;

  /**
   * Whether to also send taskrunner log info to stderr.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAlsologtostderr() {
    return alsologtostderr;
  }

  /**
   * Whether to also send taskrunner log info to stderr.
   * @param alsologtostderr alsologtostderr or {@code null} for none
   */
  public TaskRunnerSettings setAlsologtostderr(java.lang.Boolean alsologtostderr) {
    this.alsologtostderr = alsologtostderr;
    return this;
  }

  /**
   * The location on the worker for task-specific subdirectories.
   * @return value or {@code null} for none
   */
  public java.lang.String getBaseTaskDir() {
    return baseTaskDir;
  }

  /**
   * The location on the worker for task-specific subdirectories.
   * @param baseTaskDir baseTaskDir or {@code null} for none
   */
  public TaskRunnerSettings setBaseTaskDir(java.lang.String baseTaskDir) {
    this.baseTaskDir = baseTaskDir;
    return this;
  }

  /**
   * The base URL for the taskrunner to use when accessing Google Cloud APIs.
   *
   * When workers access Google Cloud APIs, they logically do so via relative URLs.  If this field
   * is specified, it supplies the base URL to use for resolving these relative URLs.  The normative
   * algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators".
   *
   * If not specified, the default value is "http://www.googleapis.com/"
   * @return value or {@code null} for none
   */
  public java.lang.String getBaseUrl() {
    return baseUrl;
  }

  /**
   * The base URL for the taskrunner to use when accessing Google Cloud APIs.
   *
   * When workers access Google Cloud APIs, they logically do so via relative URLs.  If this field
   * is specified, it supplies the base URL to use for resolving these relative URLs.  The normative
   * algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators".
   *
   * If not specified, the default value is "http://www.googleapis.com/"
   * @param baseUrl baseUrl or {@code null} for none
   */
  public TaskRunnerSettings setBaseUrl(java.lang.String baseUrl) {
    this.baseUrl = baseUrl;
    return this;
  }

  /**
   * The file to store preprocessing commands in.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommandlinesFileName() {
    return commandlinesFileName;
  }

  /**
   * The file to store preprocessing commands in.
   * @param commandlinesFileName commandlinesFileName or {@code null} for none
   */
  public TaskRunnerSettings setCommandlinesFileName(java.lang.String commandlinesFileName) {
    this.commandlinesFileName = commandlinesFileName;
    return this;
  }

  /**
   * Whether to continue taskrunner if an exception is hit.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getContinueOnException() {
    return continueOnException;
  }

  /**
   * Whether to continue taskrunner if an exception is hit.
   * @param continueOnException continueOnException or {@code null} for none
   */
  public TaskRunnerSettings setContinueOnException(java.lang.Boolean continueOnException) {
    this.continueOnException = continueOnException;
    return this;
  }

  /**
   * The API version of endpoint, e.g. "v1b3"
   * @return value or {@code null} for none
   */
  public java.lang.String getDataflowApiVersion() {
    return dataflowApiVersion;
  }

  /**
   * The API version of endpoint, e.g. "v1b3"
   * @param dataflowApiVersion dataflowApiVersion or {@code null} for none
   */
  public TaskRunnerSettings setDataflowApiVersion(java.lang.String dataflowApiVersion) {
    this.dataflowApiVersion = dataflowApiVersion;
    return this;
  }

  /**
   * The command to launch the worker harness.
   * @return value or {@code null} for none
   */
  public java.lang.String getHarnessCommand() {
    return harnessCommand;
  }

  /**
   * The command to launch the worker harness.
   * @param harnessCommand harnessCommand or {@code null} for none
   */
  public TaskRunnerSettings setHarnessCommand(java.lang.String harnessCommand) {
    this.harnessCommand = harnessCommand;
    return this;
  }

  /**
   * The suggested backend language.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageHint() {
    return languageHint;
  }

  /**
   * The suggested backend language.
   * @param languageHint languageHint or {@code null} for none
   */
  public TaskRunnerSettings setLanguageHint(java.lang.String languageHint) {
    this.languageHint = languageHint;
    return this;
  }

  /**
   * The directory on the VM to store logs.
   * @return value or {@code null} for none
   */
  public java.lang.String getLogDir() {
    return logDir;
  }

  /**
   * The directory on the VM to store logs.
   * @param logDir logDir or {@code null} for none
   */
  public TaskRunnerSettings setLogDir(java.lang.String logDir) {
    this.logDir = logDir;
    return this;
  }

  /**
   * Whether to send taskrunner log info to Google Compute Engine VM serial console.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLogToSerialconsole() {
    return logToSerialconsole;
  }

  /**
   * Whether to send taskrunner log info to Google Compute Engine VM serial console.
   * @param logToSerialconsole logToSerialconsole or {@code null} for none
   */
  public TaskRunnerSettings setLogToSerialconsole(java.lang.Boolean logToSerialconsole) {
    this.logToSerialconsole = logToSerialconsole;
    return this;
  }

  /**
   * Indicates where to put logs.  If this is not specified, the logs will not be uploaded.
   *
   * The supported resource type is:
   *
   * Google Cloud Storage:   storage.googleapis.com/{bucket}/{object}
   * bucket.storage.googleapis.com/{object}
   * @return value or {@code null} for none
   */
  public java.lang.String getLogUploadLocation() {
    return logUploadLocation;
  }

  /**
   * Indicates where to put logs.  If this is not specified, the logs will not be uploaded.
   *
   * The supported resource type is:
   *
   * Google Cloud Storage:   storage.googleapis.com/{bucket}/{object}
   * bucket.storage.googleapis.com/{object}
   * @param logUploadLocation logUploadLocation or {@code null} for none
   */
  public TaskRunnerSettings setLogUploadLocation(java.lang.String logUploadLocation) {
    this.logUploadLocation = logUploadLocation;
    return this;
  }

  /**
   * The OAuth2 scopes to be requested by the taskrunner in order to access the Cloud Dataflow API.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getOauthScopes() {
    return oauthScopes;
  }

  /**
   * The OAuth2 scopes to be requested by the taskrunner in order to access the Cloud Dataflow API.
   * @param oauthScopes oauthScopes or {@code null} for none
   */
  public TaskRunnerSettings setOauthScopes(java.util.List<java.lang.String> oauthScopes) {
    this.oauthScopes = oauthScopes;
    return this;
  }

  /**
   * The settings to pass to the parallel worker harness.
   * @return value or {@code null} for none
   */
  public WorkerSettings getParallelWorkerSettings() {
    return parallelWorkerSettings;
  }

  /**
   * The settings to pass to the parallel worker harness.
   * @param parallelWorkerSettings parallelWorkerSettings or {@code null} for none
   */
  public TaskRunnerSettings setParallelWorkerSettings(WorkerSettings parallelWorkerSettings) {
    this.parallelWorkerSettings = parallelWorkerSettings;
    return this;
  }

  /**
   * The streaming worker main class name.
   * @return value or {@code null} for none
   */
  public java.lang.String getStreamingWorkerMainClass() {
    return streamingWorkerMainClass;
  }

  /**
   * The streaming worker main class name.
   * @param streamingWorkerMainClass streamingWorkerMainClass or {@code null} for none
   */
  public TaskRunnerSettings setStreamingWorkerMainClass(java.lang.String streamingWorkerMainClass) {
    this.streamingWorkerMainClass = streamingWorkerMainClass;
    return this;
  }

  /**
   * The UNIX group ID on the worker VM to use for tasks launched by taskrunner; e.g. "wheel".
   * @return value or {@code null} for none
   */
  public java.lang.String getTaskGroup() {
    return taskGroup;
  }

  /**
   * The UNIX group ID on the worker VM to use for tasks launched by taskrunner; e.g. "wheel".
   * @param taskGroup taskGroup or {@code null} for none
   */
  public TaskRunnerSettings setTaskGroup(java.lang.String taskGroup) {
    this.taskGroup = taskGroup;
    return this;
  }

  /**
   * The UNIX user ID on the worker VM to use for tasks launched by taskrunner; e.g. "root".
   * @return value or {@code null} for none
   */
  public java.lang.String getTaskUser() {
    return taskUser;
  }

  /**
   * The UNIX user ID on the worker VM to use for tasks launched by taskrunner; e.g. "root".
   * @param taskUser taskUser or {@code null} for none
   */
  public TaskRunnerSettings setTaskUser(java.lang.String taskUser) {
    this.taskUser = taskUser;
    return this;
  }

  /**
   * The prefix of the resources the taskrunner should use for temporary storage.
   *
   * The supported resource type is:
   *
   * Google Cloud Storage:   storage.googleapis.com/{bucket}/{object}
   * bucket.storage.googleapis.com/{object}
   * @return value or {@code null} for none
   */
  public java.lang.String getTempStoragePrefix() {
    return tempStoragePrefix;
  }

  /**
   * The prefix of the resources the taskrunner should use for temporary storage.
   *
   * The supported resource type is:
   *
   * Google Cloud Storage:   storage.googleapis.com/{bucket}/{object}
   * bucket.storage.googleapis.com/{object}
   * @param tempStoragePrefix tempStoragePrefix or {@code null} for none
   */
  public TaskRunnerSettings setTempStoragePrefix(java.lang.String tempStoragePrefix) {
    this.tempStoragePrefix = tempStoragePrefix;
    return this;
  }

  /**
   * The ID string of the VM.
   * @return value or {@code null} for none
   */
  public java.lang.String getVmId() {
    return vmId;
  }

  /**
   * The ID string of the VM.
   * @param vmId vmId or {@code null} for none
   */
  public TaskRunnerSettings setVmId(java.lang.String vmId) {
    this.vmId = vmId;
    return this;
  }

  /**
   * The file to store the workflow in.
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkflowFileName() {
    return workflowFileName;
  }

  /**
   * The file to store the workflow in.
   * @param workflowFileName workflowFileName or {@code null} for none
   */
  public TaskRunnerSettings setWorkflowFileName(java.lang.String workflowFileName) {
    this.workflowFileName = workflowFileName;
    return this;
  }

  @Override
  public TaskRunnerSettings set(String fieldName, Object value) {
    return (TaskRunnerSettings) super.set(fieldName, value);
  }

  @Override
  public TaskRunnerSettings clone() {
    return (TaskRunnerSettings) super.clone();
  }

}
