/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A task that carries configuration information for streaming computations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingConfigTask extends com.google.api.client.json.GenericJson {

  /**
   * Chunk size for commit streams from the harness to windmill.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long commitStreamChunkSizeBytes;

  /**
   * Chunk size for get data streams from the harness to windmill.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long getDataStreamChunkSizeBytes;

  /**
   * Maximum size for work item commit supported windmill storage layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxWorkItemCommitBytes;

  /**
   * Set of computation configuration information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StreamingComputationConfig> streamingComputationConfigs;

  static {
    // hack to force ProGuard to consider StreamingComputationConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StreamingComputationConfig.class);
  }

  /**
   * Map from user step names to state families.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> userStepToStateFamilyNameMap;

  /**
   * If present, the worker must use this endpoint to communicate with Windmill Service dispatchers,
   * otherwise the worker must continue to use whatever endpoint it had been using.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String windmillServiceEndpoint;

  /**
   * If present, the worker must use this port to communicate with Windmill Service dispatchers.
   * Only applicable when windmill_service_endpoint is specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long windmillServicePort;

  /**
   * Chunk size for commit streams from the harness to windmill.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCommitStreamChunkSizeBytes() {
    return commitStreamChunkSizeBytes;
  }

  /**
   * Chunk size for commit streams from the harness to windmill.
   * @param commitStreamChunkSizeBytes commitStreamChunkSizeBytes or {@code null} for none
   */
  public StreamingConfigTask setCommitStreamChunkSizeBytes(java.lang.Long commitStreamChunkSizeBytes) {
    this.commitStreamChunkSizeBytes = commitStreamChunkSizeBytes;
    return this;
  }

  /**
   * Chunk size for get data streams from the harness to windmill.
   * @return value or {@code null} for none
   */
  public java.lang.Long getGetDataStreamChunkSizeBytes() {
    return getDataStreamChunkSizeBytes;
  }

  /**
   * Chunk size for get data streams from the harness to windmill.
   * @param getDataStreamChunkSizeBytes getDataStreamChunkSizeBytes or {@code null} for none
   */
  public StreamingConfigTask setGetDataStreamChunkSizeBytes(java.lang.Long getDataStreamChunkSizeBytes) {
    this.getDataStreamChunkSizeBytes = getDataStreamChunkSizeBytes;
    return this;
  }

  /**
   * Maximum size for work item commit supported windmill storage layer.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxWorkItemCommitBytes() {
    return maxWorkItemCommitBytes;
  }

  /**
   * Maximum size for work item commit supported windmill storage layer.
   * @param maxWorkItemCommitBytes maxWorkItemCommitBytes or {@code null} for none
   */
  public StreamingConfigTask setMaxWorkItemCommitBytes(java.lang.Long maxWorkItemCommitBytes) {
    this.maxWorkItemCommitBytes = maxWorkItemCommitBytes;
    return this;
  }

  /**
   * Set of computation configuration information.
   * @return value or {@code null} for none
   */
  public java.util.List<StreamingComputationConfig> getStreamingComputationConfigs() {
    return streamingComputationConfigs;
  }

  /**
   * Set of computation configuration information.
   * @param streamingComputationConfigs streamingComputationConfigs or {@code null} for none
   */
  public StreamingConfigTask setStreamingComputationConfigs(java.util.List<StreamingComputationConfig> streamingComputationConfigs) {
    this.streamingComputationConfigs = streamingComputationConfigs;
    return this;
  }

  /**
   * Map from user step names to state families.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getUserStepToStateFamilyNameMap() {
    return userStepToStateFamilyNameMap;
  }

  /**
   * Map from user step names to state families.
   * @param userStepToStateFamilyNameMap userStepToStateFamilyNameMap or {@code null} for none
   */
  public StreamingConfigTask setUserStepToStateFamilyNameMap(java.util.Map<String, java.lang.String> userStepToStateFamilyNameMap) {
    this.userStepToStateFamilyNameMap = userStepToStateFamilyNameMap;
    return this;
  }

  /**
   * If present, the worker must use this endpoint to communicate with Windmill Service dispatchers,
   * otherwise the worker must continue to use whatever endpoint it had been using.
   * @return value or {@code null} for none
   */
  public java.lang.String getWindmillServiceEndpoint() {
    return windmillServiceEndpoint;
  }

  /**
   * If present, the worker must use this endpoint to communicate with Windmill Service dispatchers,
   * otherwise the worker must continue to use whatever endpoint it had been using.
   * @param windmillServiceEndpoint windmillServiceEndpoint or {@code null} for none
   */
  public StreamingConfigTask setWindmillServiceEndpoint(java.lang.String windmillServiceEndpoint) {
    this.windmillServiceEndpoint = windmillServiceEndpoint;
    return this;
  }

  /**
   * If present, the worker must use this port to communicate with Windmill Service dispatchers.
   * Only applicable when windmill_service_endpoint is specified.
   * @return value or {@code null} for none
   */
  public java.lang.Long getWindmillServicePort() {
    return windmillServicePort;
  }

  /**
   * If present, the worker must use this port to communicate with Windmill Service dispatchers.
   * Only applicable when windmill_service_endpoint is specified.
   * @param windmillServicePort windmillServicePort or {@code null} for none
   */
  public StreamingConfigTask setWindmillServicePort(java.lang.Long windmillServicePort) {
    this.windmillServicePort = windmillServicePort;
    return this;
  }

  @Override
  public StreamingConfigTask set(String fieldName, Object value) {
    return (StreamingConfigTask) super.set(fieldName, value);
  }

  @Override
  public StreamingConfigTask clone() {
    return (StreamingConfigTask) super.clone();
  }

}
