/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes mounted data disk.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MountedDataDisk extends com.google.api.client.json.GenericJson {

  /**
   * The name of the data disk. This name is local to the Google Cloud Platform project and uniquely
   * identifies the disk within that project, for example
   * "myproject-1014-104817-4c2-harness-0-disk-1".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataDisk;

  /**
   * The name of the data disk. This name is local to the Google Cloud Platform project and uniquely
   * identifies the disk within that project, for example
   * "myproject-1014-104817-4c2-harness-0-disk-1".
   * @return value or {@code null} for none
   */
  public java.lang.String getDataDisk() {
    return dataDisk;
  }

  /**
   * The name of the data disk. This name is local to the Google Cloud Platform project and uniquely
   * identifies the disk within that project, for example
   * "myproject-1014-104817-4c2-harness-0-disk-1".
   * @param dataDisk dataDisk or {@code null} for none
   */
  public MountedDataDisk setDataDisk(java.lang.String dataDisk) {
    this.dataDisk = dataDisk;
    return this;
  }

  @Override
  public MountedDataDisk set(String fieldName, Object value) {
    return (MountedDataDisk) super.set(fieldName, value);
  }

  @Override
  public MountedDataDisk clone() {
    return (MountedDataDisk) super.clone();
  }

}
