/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Metadata for a PubSub connector used by the job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PubSubIODetails extends com.google.api.client.json.GenericJson {

  /**
   * Subscription used in the connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subscription;

  /**
   * Topic accessed in the connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topic;

  /**
   * Subscription used in the connection.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubscription() {
    return subscription;
  }

  /**
   * Subscription used in the connection.
   * @param subscription subscription or {@code null} for none
   */
  public PubSubIODetails setSubscription(java.lang.String subscription) {
    this.subscription = subscription;
    return this;
  }

  /**
   * Topic accessed in the connection.
   * @return value or {@code null} for none
   */
  public java.lang.String getTopic() {
    return topic;
  }

  /**
   * Topic accessed in the connection.
   * @param topic topic or {@code null} for none
   */
  public PubSubIODetails setTopic(java.lang.String topic) {
    this.topic = topic;
    return this;
  }

  @Override
  public PubSubIODetails set(String fieldName, Object value) {
    return (PubSubIODetails) super.set(fieldName, value);
  }

  @Override
  public PubSubIODetails clone() {
    return (PubSubIODetails) super.clone();
  }

}
