/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A descriptive representation of submitted pipeline as well as the executed form.  This data is
 * provided by the Dataflow service for ease of visualizing the pipeline and interpreting Dataflow
 * provided metrics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PipelineDescription extends com.google.api.client.json.GenericJson {

  /**
   * Pipeline level display data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DisplayData> displayData;

  static {
    // hack to force ProGuard to consider DisplayData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DisplayData.class);
  }

  /**
   * Description of each stage of execution of the pipeline.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ExecutionStageSummary> executionPipelineStage;

  static {
    // hack to force ProGuard to consider ExecutionStageSummary used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ExecutionStageSummary.class);
  }

  /**
   * Description of each transform in the pipeline and collections between them.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TransformSummary> originalPipelineTransform;

  /**
   * Pipeline level display data.
   * @return value or {@code null} for none
   */
  public java.util.List<DisplayData> getDisplayData() {
    return displayData;
  }

  /**
   * Pipeline level display data.
   * @param displayData displayData or {@code null} for none
   */
  public PipelineDescription setDisplayData(java.util.List<DisplayData> displayData) {
    this.displayData = displayData;
    return this;
  }

  /**
   * Description of each stage of execution of the pipeline.
   * @return value or {@code null} for none
   */
  public java.util.List<ExecutionStageSummary> getExecutionPipelineStage() {
    return executionPipelineStage;
  }

  /**
   * Description of each stage of execution of the pipeline.
   * @param executionPipelineStage executionPipelineStage or {@code null} for none
   */
  public PipelineDescription setExecutionPipelineStage(java.util.List<ExecutionStageSummary> executionPipelineStage) {
    this.executionPipelineStage = executionPipelineStage;
    return this;
  }

  /**
   * Description of each transform in the pipeline and collections between them.
   * @return value or {@code null} for none
   */
  public java.util.List<TransformSummary> getOriginalPipelineTransform() {
    return originalPipelineTransform;
  }

  /**
   * Description of each transform in the pipeline and collections between them.
   * @param originalPipelineTransform originalPipelineTransform or {@code null} for none
   */
  public PipelineDescription setOriginalPipelineTransform(java.util.List<TransformSummary> originalPipelineTransform) {
    this.originalPipelineTransform = originalPipelineTransform;
    return this;
  }

  @Override
  public PipelineDescription set(String fieldName, Object value) {
    return (PipelineDescription) super.set(fieldName, value);
  }

  @Override
  public PipelineDescription clone() {
    return (PipelineDescription) super.clone();
  }

}
