/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes a particular operation comprising a MapTask.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ParallelInstruction extends com.google.api.client.json.GenericJson {

  /**
   * Additional information for Flatten instructions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FlattenInstruction flatten;

  /**
   * User-provided name of this operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * System-defined name for the operation in the original workflow graph.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalName;

  /**
   * Describes the outputs of the instruction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InstructionOutput> outputs;

  static {
    // hack to force ProGuard to consider InstructionOutput used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InstructionOutput.class);
  }

  /**
   * Additional information for ParDo instructions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParDoInstruction parDo;

  /**
   * Additional information for PartialGroupByKey instructions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PartialGroupByKeyInstruction partialGroupByKey;

  /**
   * Additional information for Read instructions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReadInstruction read;

  /**
   * System-defined name of this operation. Unique across the workflow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String systemName;

  /**
   * Additional information for Write instructions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WriteInstruction write;

  /**
   * Additional information for Flatten instructions.
   * @return value or {@code null} for none
   */
  public FlattenInstruction getFlatten() {
    return flatten;
  }

  /**
   * Additional information for Flatten instructions.
   * @param flatten flatten or {@code null} for none
   */
  public ParallelInstruction setFlatten(FlattenInstruction flatten) {
    this.flatten = flatten;
    return this;
  }

  /**
   * User-provided name of this operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * User-provided name of this operation.
   * @param name name or {@code null} for none
   */
  public ParallelInstruction setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * System-defined name for the operation in the original workflow graph.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalName() {
    return originalName;
  }

  /**
   * System-defined name for the operation in the original workflow graph.
   * @param originalName originalName or {@code null} for none
   */
  public ParallelInstruction setOriginalName(java.lang.String originalName) {
    this.originalName = originalName;
    return this;
  }

  /**
   * Describes the outputs of the instruction.
   * @return value or {@code null} for none
   */
  public java.util.List<InstructionOutput> getOutputs() {
    return outputs;
  }

  /**
   * Describes the outputs of the instruction.
   * @param outputs outputs or {@code null} for none
   */
  public ParallelInstruction setOutputs(java.util.List<InstructionOutput> outputs) {
    this.outputs = outputs;
    return this;
  }

  /**
   * Additional information for ParDo instructions.
   * @return value or {@code null} for none
   */
  public ParDoInstruction getParDo() {
    return parDo;
  }

  /**
   * Additional information for ParDo instructions.
   * @param parDo parDo or {@code null} for none
   */
  public ParallelInstruction setParDo(ParDoInstruction parDo) {
    this.parDo = parDo;
    return this;
  }

  /**
   * Additional information for PartialGroupByKey instructions.
   * @return value or {@code null} for none
   */
  public PartialGroupByKeyInstruction getPartialGroupByKey() {
    return partialGroupByKey;
  }

  /**
   * Additional information for PartialGroupByKey instructions.
   * @param partialGroupByKey partialGroupByKey or {@code null} for none
   */
  public ParallelInstruction setPartialGroupByKey(PartialGroupByKeyInstruction partialGroupByKey) {
    this.partialGroupByKey = partialGroupByKey;
    return this;
  }

  /**
   * Additional information for Read instructions.
   * @return value or {@code null} for none
   */
  public ReadInstruction getRead() {
    return read;
  }

  /**
   * Additional information for Read instructions.
   * @param read read or {@code null} for none
   */
  public ParallelInstruction setRead(ReadInstruction read) {
    this.read = read;
    return this;
  }

  /**
   * System-defined name of this operation. Unique across the workflow.
   * @return value or {@code null} for none
   */
  public java.lang.String getSystemName() {
    return systemName;
  }

  /**
   * System-defined name of this operation. Unique across the workflow.
   * @param systemName systemName or {@code null} for none
   */
  public ParallelInstruction setSystemName(java.lang.String systemName) {
    this.systemName = systemName;
    return this;
  }

  /**
   * Additional information for Write instructions.
   * @return value or {@code null} for none
   */
  public WriteInstruction getWrite() {
    return write;
  }

  /**
   * Additional information for Write instructions.
   * @param write write or {@code null} for none
   */
  public ParallelInstruction setWrite(WriteInstruction write) {
    this.write = write;
    return this;
  }

  @Override
  public ParallelInstruction set(String fieldName, Object value) {
    return (ParallelInstruction) super.set(fieldName, value);
  }

  @Override
  public ParallelInstruction clone() {
    return (ParallelInstruction) super.clone();
  }

}
