/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Launch FlexTemplate Parameter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LaunchFlexTemplateParameter extends com.google.api.client.json.GenericJson {

  /**
   * Spec about the container image to launch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ContainerSpec containerSpec;

  /**
   * Gcs path to a file with json serialized ContainerSpec as content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String containerSpecGcsPath;

  /**
   * Required. The job name to use for the created job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jobName;

  /**
   * The parameters for FlexTemplate. Ex. {"num_workers":"5"}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> parameters;

  /**
   * Spec about the container image to launch.
   * @return value or {@code null} for none
   */
  public ContainerSpec getContainerSpec() {
    return containerSpec;
  }

  /**
   * Spec about the container image to launch.
   * @param containerSpec containerSpec or {@code null} for none
   */
  public LaunchFlexTemplateParameter setContainerSpec(ContainerSpec containerSpec) {
    this.containerSpec = containerSpec;
    return this;
  }

  /**
   * Gcs path to a file with json serialized ContainerSpec as content.
   * @return value or {@code null} for none
   */
  public java.lang.String getContainerSpecGcsPath() {
    return containerSpecGcsPath;
  }

  /**
   * Gcs path to a file with json serialized ContainerSpec as content.
   * @param containerSpecGcsPath containerSpecGcsPath or {@code null} for none
   */
  public LaunchFlexTemplateParameter setContainerSpecGcsPath(java.lang.String containerSpecGcsPath) {
    this.containerSpecGcsPath = containerSpecGcsPath;
    return this;
  }

  /**
   * Required. The job name to use for the created job.
   * @return value or {@code null} for none
   */
  public java.lang.String getJobName() {
    return jobName;
  }

  /**
   * Required. The job name to use for the created job.
   * @param jobName jobName or {@code null} for none
   */
  public LaunchFlexTemplateParameter setJobName(java.lang.String jobName) {
    this.jobName = jobName;
    return this;
  }

  /**
   * The parameters for FlexTemplate. Ex. {"num_workers":"5"}
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getParameters() {
    return parameters;
  }

  /**
   * The parameters for FlexTemplate. Ex. {"num_workers":"5"}
   * @param parameters parameters or {@code null} for none
   */
  public LaunchFlexTemplateParameter setParameters(java.util.Map<String, java.lang.String> parameters) {
    this.parameters = parameters;
    return this;
  }

  @Override
  public LaunchFlexTemplateParameter set(String fieldName, Object value) {
    return (LaunchFlexTemplateParameter) super.set(fieldName, value);
  }

  @Override
  public LaunchFlexTemplateParameter clone() {
    return (LaunchFlexTemplateParameter) super.clone();
  }

}
