/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Histogram of value counts for a distribution.
 *
 * Buckets have an inclusive lower bound and exclusive upper bound and use "1,2,5 bucketing": The
 * first bucket range is from [0,1) and all subsequent bucket boundaries are powers of ten
 * multiplied by 1, 2, or 5. Thus, bucket boundaries are 0, 1, 2, 5, 10, 20, 50, 100, 200, 500,
 * 1000, ... Negative values are not supported.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Histogram extends com.google.api.client.json.GenericJson {

  /**
   * Counts of values in each bucket. For efficiency, prefix and trailing buckets with count = 0 are
   * elided. Buckets can store the full range of values of an unsigned long, with ULLONG_MAX falling
   * into the 59th bucket with range [1e19, 2e19).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> bucketCounts;

  /**
   * Starting index of first stored bucket. The non-inclusive upper-bound of the ith bucket is given
   * by:   pow(10,(i-first_bucket_offset)/3) * (1,2,5)[(i-first_bucket_offset)%3]
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer firstBucketOffset;

  /**
   * Counts of values in each bucket. For efficiency, prefix and trailing buckets with count = 0 are
   * elided. Buckets can store the full range of values of an unsigned long, with ULLONG_MAX falling
   * into the 59th bucket with range [1e19, 2e19).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getBucketCounts() {
    return bucketCounts;
  }

  /**
   * Counts of values in each bucket. For efficiency, prefix and trailing buckets with count = 0 are
   * elided. Buckets can store the full range of values of an unsigned long, with ULLONG_MAX falling
   * into the 59th bucket with range [1e19, 2e19).
   * @param bucketCounts bucketCounts or {@code null} for none
   */
  public Histogram setBucketCounts(java.util.List<java.lang.Long> bucketCounts) {
    this.bucketCounts = bucketCounts;
    return this;
  }

  /**
   * Starting index of first stored bucket. The non-inclusive upper-bound of the ith bucket is given
   * by:   pow(10,(i-first_bucket_offset)/3) * (1,2,5)[(i-first_bucket_offset)%3]
   * @return value or {@code null} for none
   */
  public java.lang.Integer getFirstBucketOffset() {
    return firstBucketOffset;
  }

  /**
   * Starting index of first stored bucket. The non-inclusive upper-bound of the ith bucket is given
   * by:   pow(10,(i-first_bucket_offset)/3) * (1,2,5)[(i-first_bucket_offset)%3]
   * @param firstBucketOffset firstBucketOffset or {@code null} for none
   */
  public Histogram setFirstBucketOffset(java.lang.Integer firstBucketOffset) {
    this.firstBucketOffset = firstBucketOffset;
    return this;
  }

  @Override
  public Histogram set(String fieldName, Object value) {
    return (Histogram) super.set(fieldName, value);
  }

  @Override
  public Histogram clone() {
    return (Histogram) super.clone();
  }

}
