/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes the data disk used by a workflow job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Disk extends com.google.api.client.json.GenericJson {

  /**
   * Disk storage type, as defined by Google Compute Engine.  This must be a disk type appropriate
   * to the project and zone in which the workers will run.  If unknown or unspecified, the service
   * will attempt to choose a reasonable default.
   *
   * For example, the standard persistent disk type is a resource name typically ending in "pd-
   * standard".  If SSD persistent disks are available, the resource name typically ends with "pd-
   * ssd".  The actual valid values are defined the Google Compute Engine API, not by the Cloud
   * Dataflow API; consult the Google Compute Engine documentation for more information about
   * determining the set of available disk types for a particular project and zone.
   *
   * Google Compute Engine Disk types are local to a particular project in a particular zone, and so
   * the resource name will typically look something like this:
   *
   * compute.googleapis.com/projects/project-id/zones/zone/diskTypes/pd-standard
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskType;

  /**
   * Directory in a VM where disk is mounted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mountPoint;

  /**
   * Size of disk in GB.  If zero or unspecified, the service will attempt to choose a reasonable
   * default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sizeGb;

  /**
   * Disk storage type, as defined by Google Compute Engine.  This must be a disk type appropriate
   * to the project and zone in which the workers will run.  If unknown or unspecified, the service
   * will attempt to choose a reasonable default.
   *
   * For example, the standard persistent disk type is a resource name typically ending in "pd-
   * standard".  If SSD persistent disks are available, the resource name typically ends with "pd-
   * ssd".  The actual valid values are defined the Google Compute Engine API, not by the Cloud
   * Dataflow API; consult the Google Compute Engine documentation for more information about
   * determining the set of available disk types for a particular project and zone.
   *
   * Google Compute Engine Disk types are local to a particular project in a particular zone, and so
   * the resource name will typically look something like this:
   *
   * compute.googleapis.com/projects/project-id/zones/zone/diskTypes/pd-standard
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskType() {
    return diskType;
  }

  /**
   * Disk storage type, as defined by Google Compute Engine.  This must be a disk type appropriate
   * to the project and zone in which the workers will run.  If unknown or unspecified, the service
   * will attempt to choose a reasonable default.
   *
   * For example, the standard persistent disk type is a resource name typically ending in "pd-
   * standard".  If SSD persistent disks are available, the resource name typically ends with "pd-
   * ssd".  The actual valid values are defined the Google Compute Engine API, not by the Cloud
   * Dataflow API; consult the Google Compute Engine documentation for more information about
   * determining the set of available disk types for a particular project and zone.
   *
   * Google Compute Engine Disk types are local to a particular project in a particular zone, and so
   * the resource name will typically look something like this:
   *
   * compute.googleapis.com/projects/project-id/zones/zone/diskTypes/pd-standard
   * @param diskType diskType or {@code null} for none
   */
  public Disk setDiskType(java.lang.String diskType) {
    this.diskType = diskType;
    return this;
  }

  /**
   * Directory in a VM where disk is mounted.
   * @return value or {@code null} for none
   */
  public java.lang.String getMountPoint() {
    return mountPoint;
  }

  /**
   * Directory in a VM where disk is mounted.
   * @param mountPoint mountPoint or {@code null} for none
   */
  public Disk setMountPoint(java.lang.String mountPoint) {
    this.mountPoint = mountPoint;
    return this;
  }

  /**
   * Size of disk in GB.  If zero or unspecified, the service will attempt to choose a reasonable
   * default.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSizeGb() {
    return sizeGb;
  }

  /**
   * Size of disk in GB.  If zero or unspecified, the service will attempt to choose a reasonable
   * default.
   * @param sizeGb sizeGb or {@code null} for none
   */
  public Disk setSizeGb(java.lang.Integer sizeGb) {
    this.sizeGb = sizeGb;
    return this;
  }

  @Override
  public Disk set(String fieldName, Object value) {
    return (Disk) super.set(fieldName, value);
  }

  @Override
  public Disk clone() {
    return (Disk) super.clone();
  }

}
