/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * The packages that must be installed in order for a worker to run the steps of the Cloud Dataflow
 * job that will be assigned to its worker pool.
 *
 * This is the mechanism by which the Cloud Dataflow SDK causes code to be loaded onto the workers.
 * For example, the Cloud Dataflow Java SDK might use this to install jars containing the user's
 * code and all of the various dependencies (libraries, data files, etc.) required in order for that
 * code to run.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataflowPackage extends com.google.api.client.json.GenericJson {

  /**
   * The resource to read the package from. The supported resource type is:
   *
   * Google Cloud Storage:
   *
   *   storage.googleapis.com/{bucket}   bucket.storage.googleapis.com/
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * The name of the package.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The resource to read the package from. The supported resource type is:
   *
   * Google Cloud Storage:
   *
   *   storage.googleapis.com/{bucket}   bucket.storage.googleapis.com/
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The resource to read the package from. The supported resource type is:
   *
   * Google Cloud Storage:
   *
   *   storage.googleapis.com/{bucket}   bucket.storage.googleapis.com/
   * @param location location or {@code null} for none
   */
  public DataflowPackage setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * The name of the package.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the package.
   * @param name name or {@code null} for none
   */
  public DataflowPackage setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public DataflowPackage set(String fieldName, Object value) {
    return (DataflowPackage) super.set(fieldName, value);
  }

  @Override
  public DataflowPackage clone() {
    return (DataflowPackage) super.clone();
  }

}
