/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow;

/**
 * Service definition for Dataflow (v1b3).
 *
 * <p>
 * Manages Google Cloud Dataflow projects on Google Cloud Platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/dataflow" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DataflowRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Dataflow extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.30.9 of the Dataflow API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://dataflow.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Dataflow(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Dataflow(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dataflow dataflow = new Dataflow(...);}
   *   {@code Dataflow.Projects.List request = dataflow.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Deletes a snapshot.
     *
     * Create a request for the method "projects.deleteSnapshots".
     *
     * This request holds the parameters needed by the dataflow server.  After setting any optional
     * parameters, call the {@link DeleteSnapshots#execute()} method to invoke the remote operation.
     *
     * @param projectId The ID of the Cloud Platform project that the snapshot belongs to.
     * @return the request
     */
    public DeleteSnapshots deleteSnapshots(java.lang.String projectId) throws java.io.IOException {
      DeleteSnapshots result = new DeleteSnapshots(projectId);
      initialize(result);
      return result;
    }

    public class DeleteSnapshots extends DataflowRequest<com.google.api.services.dataflow.model.DeleteSnapshotResponse> {

      private static final String REST_PATH = "v1b3/projects/{projectId}/snapshots";

      /**
       * Deletes a snapshot.
       *
       * Create a request for the method "projects.deleteSnapshots".
       *
       * This request holds the parameters needed by the the dataflow server.  After setting any
       * optional parameters, call the {@link DeleteSnapshots#execute()} method to invoke the remote
       * operation. <p> {@link DeleteSnapshots#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param projectId The ID of the Cloud Platform project that the snapshot belongs to.
       * @since 1.13
       */
      protected DeleteSnapshots(java.lang.String projectId) {
        super(Dataflow.this, "DELETE", REST_PATH, null, com.google.api.services.dataflow.model.DeleteSnapshotResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public DeleteSnapshots set$Xgafv(java.lang.String $Xgafv) {
        return (DeleteSnapshots) super.set$Xgafv($Xgafv);
      }

      @Override
      public DeleteSnapshots setAccessToken(java.lang.String accessToken) {
        return (DeleteSnapshots) super.setAccessToken(accessToken);
      }

      @Override
      public DeleteSnapshots setAlt(java.lang.String alt) {
        return (DeleteSnapshots) super.setAlt(alt);
      }

      @Override
      public DeleteSnapshots setCallback(java.lang.String callback) {
        return (DeleteSnapshots) super.setCallback(callback);
      }

      @Override
      public DeleteSnapshots setFields(java.lang.String fields) {
        return (DeleteSnapshots) super.setFields(fields);
      }

      @Override
      public DeleteSnapshots setKey(java.lang.String key) {
        return (DeleteSnapshots) super.setKey(key);
      }

      @Override
      public DeleteSnapshots setOauthToken(java.lang.String oauthToken) {
        return (DeleteSnapshots) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteSnapshots setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteSnapshots) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteSnapshots setQuotaUser(java.lang.String quotaUser) {
        return (DeleteSnapshots) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteSnapshots setUploadType(java.lang.String uploadType) {
        return (DeleteSnapshots) super.setUploadType(uploadType);
      }

      @Override
      public DeleteSnapshots setUploadProtocol(java.lang.String uploadProtocol) {
        return (DeleteSnapshots) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the Cloud Platform project that the snapshot belongs to. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** The ID of the Cloud Platform project that the snapshot belongs to.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** The ID of the Cloud Platform project that the snapshot belongs to. */
      public DeleteSnapshots setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** The location that contains this snapshot. */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The location that contains this snapshot.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /** The location that contains this snapshot. */
      public DeleteSnapshots setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /** The ID of the snapshot. */
      @com.google.api.client.util.Key
      private java.lang.String snapshotId;

      /** The ID of the snapshot.
       */
      public java.lang.String getSnapshotId() {
        return snapshotId;
      }

      /** The ID of the snapshot. */
      public DeleteSnapshots setSnapshotId(java.lang.String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
      }

      @Override
      public DeleteSnapshots set(String parameterName, Object value) {
        return (DeleteSnapshots) super.set(parameterName, value);
      }
    }
    /**
     * Send a worker_message to the service.
     *
     * Create a request for the method "projects.workerMessages".
     *
     * This request holds the parameters needed by the dataflow server.  After setting any optional
     * parameters, call the {@link WorkerMessages#execute()} method to invoke the remote operation.
     *
     * @param projectId The project to send the WorkerMessages to.
     * @param content the {@link com.google.api.services.dataflow.model.SendWorkerMessagesRequest}
     * @return the request
     */
    public WorkerMessages workerMessages(java.lang.String projectId, com.google.api.services.dataflow.model.SendWorkerMessagesRequest content) throws java.io.IOException {
      WorkerMessages result = new WorkerMessages(projectId, content);
      initialize(result);
      return result;
    }

    public class WorkerMessages extends DataflowRequest<com.google.api.services.dataflow.model.SendWorkerMessagesResponse> {

      private static final String REST_PATH = "v1b3/projects/{projectId}/WorkerMessages";

      /**
       * Send a worker_message to the service.
       *
       * Create a request for the method "projects.workerMessages".
       *
       * This request holds the parameters needed by the the dataflow server.  After setting any
       * optional parameters, call the {@link WorkerMessages#execute()} method to invoke the remote
       * operation. <p> {@link WorkerMessages#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param projectId The project to send the WorkerMessages to.
       * @param content the {@link com.google.api.services.dataflow.model.SendWorkerMessagesRequest}
       * @since 1.13
       */
      protected WorkerMessages(java.lang.String projectId, com.google.api.services.dataflow.model.SendWorkerMessagesRequest content) {
        super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.SendWorkerMessagesResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public WorkerMessages set$Xgafv(java.lang.String $Xgafv) {
        return (WorkerMessages) super.set$Xgafv($Xgafv);
      }

      @Override
      public WorkerMessages setAccessToken(java.lang.String accessToken) {
        return (WorkerMessages) super.setAccessToken(accessToken);
      }

      @Override
      public WorkerMessages setAlt(java.lang.String alt) {
        return (WorkerMessages) super.setAlt(alt);
      }

      @Override
      public WorkerMessages setCallback(java.lang.String callback) {
        return (WorkerMessages) super.setCallback(callback);
      }

      @Override
      public WorkerMessages setFields(java.lang.String fields) {
        return (WorkerMessages) super.setFields(fields);
      }

      @Override
      public WorkerMessages setKey(java.lang.String key) {
        return (WorkerMessages) super.setKey(key);
      }

      @Override
      public WorkerMessages setOauthToken(java.lang.String oauthToken) {
        return (WorkerMessages) super.setOauthToken(oauthToken);
      }

      @Override
      public WorkerMessages setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (WorkerMessages) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public WorkerMessages setQuotaUser(java.lang.String quotaUser) {
        return (WorkerMessages) super.setQuotaUser(quotaUser);
      }

      @Override
      public WorkerMessages setUploadType(java.lang.String uploadType) {
        return (WorkerMessages) super.setUploadType(uploadType);
      }

      @Override
      public WorkerMessages setUploadProtocol(java.lang.String uploadProtocol) {
        return (WorkerMessages) super.setUploadProtocol(uploadProtocol);
      }

      /** The project to send the WorkerMessages to. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** The project to send the WorkerMessages to.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** The project to send the WorkerMessages to. */
      public WorkerMessages setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public WorkerMessages set(String parameterName, Object value) {
        return (WorkerMessages) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Jobs collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Dataflow dataflow = new Dataflow(...);}
     *   {@code Dataflow.Jobs.List request = dataflow.jobs().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Jobs jobs() {
      return new Jobs();
    }

    /**
     * The "jobs" collection of methods.
     */
    public class Jobs {

      /**
       * List the jobs of a project across all regions.
       *
       * Create a request for the method "jobs.aggregated".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Aggregated#execute()} method to invoke the remote operation.
       *
       * @param projectId The project which owns the jobs.
       * @return the request
       */
      public Aggregated aggregated(java.lang.String projectId) throws java.io.IOException {
        Aggregated result = new Aggregated(projectId);
        initialize(result);
        return result;
      }

      public class Aggregated extends DataflowRequest<com.google.api.services.dataflow.model.ListJobsResponse> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/jobs:aggregated";

        /**
         * List the jobs of a project across all regions.
         *
         * Create a request for the method "jobs.aggregated".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Aggregated#execute()} method to invoke the remote
         * operation. <p> {@link
         * Aggregated#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId The project which owns the jobs.
         * @since 1.13
         */
        protected Aggregated(java.lang.String projectId) {
          super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ListJobsResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Aggregated set$Xgafv(java.lang.String $Xgafv) {
          return (Aggregated) super.set$Xgafv($Xgafv);
        }

        @Override
        public Aggregated setAccessToken(java.lang.String accessToken) {
          return (Aggregated) super.setAccessToken(accessToken);
        }

        @Override
        public Aggregated setAlt(java.lang.String alt) {
          return (Aggregated) super.setAlt(alt);
        }

        @Override
        public Aggregated setCallback(java.lang.String callback) {
          return (Aggregated) super.setCallback(callback);
        }

        @Override
        public Aggregated setFields(java.lang.String fields) {
          return (Aggregated) super.setFields(fields);
        }

        @Override
        public Aggregated setKey(java.lang.String key) {
          return (Aggregated) super.setKey(key);
        }

        @Override
        public Aggregated setOauthToken(java.lang.String oauthToken) {
          return (Aggregated) super.setOauthToken(oauthToken);
        }

        @Override
        public Aggregated setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Aggregated) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Aggregated setQuotaUser(java.lang.String quotaUser) {
          return (Aggregated) super.setQuotaUser(quotaUser);
        }

        @Override
        public Aggregated setUploadType(java.lang.String uploadType) {
          return (Aggregated) super.setUploadType(uploadType);
        }

        @Override
        public Aggregated setUploadProtocol(java.lang.String uploadProtocol) {
          return (Aggregated) super.setUploadProtocol(uploadProtocol);
        }

        /** The project which owns the jobs. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The project which owns the jobs.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The project which owns the jobs. */
        public Aggregated setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** The kind of filter to use. */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** The kind of filter to use.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /** The kind of filter to use. */
        public Aggregated setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       contains this job.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        public Aggregated setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        /**
         * If there are many jobs, limit response to at most this many. The actual number of jobs
         * returned will be the lesser of max_responses and an unspecified server-defined limit.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** If there are many jobs, limit response to at most this many. The actual number of jobs returned
       will be the lesser of max_responses and an unspecified server-defined limit.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * If there are many jobs, limit response to at most this many. The actual number of jobs
         * returned will be the lesser of max_responses and an unspecified server-defined limit.
         */
        public Aggregated setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Set this to the 'next_page_token' field of a previous response to request additional
         * results in a long list.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Set this to the 'next_page_token' field of a previous response to request additional results in a
       long list.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * Set this to the 'next_page_token' field of a previous response to request additional
         * results in a long list.
         */
        public Aggregated setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`. */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`.
         */
        public java.lang.String getView() {
          return view;
        }

        /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`. */
        public Aggregated setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public Aggregated set(String parameterName, Object value) {
          return (Aggregated) super.set(parameterName, value);
        }
      }
      /**
       * Creates a Cloud Dataflow job.
       *
       * To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint]
       * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
       * `projects.jobs.create` is not recommended, as your job will always start in `us-central1`.
       *
       * Create a request for the method "jobs.create".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param projectId The ID of the Cloud Platform project that the job belongs to.
       * @param content the {@link com.google.api.services.dataflow.model.Job}
       * @return the request
       */
      public Create create(java.lang.String projectId, com.google.api.services.dataflow.model.Job content) throws java.io.IOException {
        Create result = new Create(projectId, content);
        initialize(result);
        return result;
      }

      public class Create extends DataflowRequest<com.google.api.services.dataflow.model.Job> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/jobs";

        /**
         * Creates a Cloud Dataflow job.
         *
         * To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint]
         * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
         * `projects.jobs.create` is not recommended, as your job will always start in `us-central1`.
         *
         * Create a request for the method "jobs.create".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId The ID of the Cloud Platform project that the job belongs to.
         * @param content the {@link com.google.api.services.dataflow.model.Job}
         * @since 1.13
         */
        protected Create(java.lang.String projectId, com.google.api.services.dataflow.model.Job content) {
          super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.Job.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the Cloud Platform project that the job belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The ID of the Cloud Platform project that the job belongs to.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The ID of the Cloud Platform project that the job belongs to. */
        public Create setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       contains this job.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        public Create setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        /** Deprecated. This field is now in the Job message. */
        @com.google.api.client.util.Key
        private java.lang.String replaceJobId;

        /** Deprecated. This field is now in the Job message.
         */
        public java.lang.String getReplaceJobId() {
          return replaceJobId;
        }

        /** Deprecated. This field is now in the Job message. */
        public Create setReplaceJobId(java.lang.String replaceJobId) {
          this.replaceJobId = replaceJobId;
          return this;
        }

        /** The level of information requested in response. */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** The level of information requested in response.
         */
        public java.lang.String getView() {
          return view;
        }

        /** The level of information requested in response. */
        public Create setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Gets the state of the specified Cloud Dataflow job.
       *
       * To get the state of a job, we recommend using `projects.locations.jobs.get` with a [regional
       * endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
       * `projects.jobs.get` is not recommended, as you can only get the state of jobs that are running in
       * `us-central1`.
       *
       * Create a request for the method "jobs.get".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param projectId The ID of the Cloud Platform project that the job belongs to.
       * @param jobId The job ID.
       * @return the request
       */
      public Get get(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
        Get result = new Get(projectId, jobId);
        initialize(result);
        return result;
      }

      public class Get extends DataflowRequest<com.google.api.services.dataflow.model.Job> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}";

        /**
         * Gets the state of the specified Cloud Dataflow job.
         *
         * To get the state of a job, we recommend using `projects.locations.jobs.get` with a [regional
         * endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
         * `projects.jobs.get` is not recommended, as you can only get the state of jobs that are running
         * in `us-central1`.
         *
         * Create a request for the method "jobs.get".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId The ID of the Cloud Platform project that the job belongs to.
         * @param jobId The job ID.
         * @since 1.13
         */
        protected Get(java.lang.String projectId, java.lang.String jobId) {
          super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.Job.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the Cloud Platform project that the job belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The ID of the Cloud Platform project that the job belongs to.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The ID of the Cloud Platform project that the job belongs to. */
        public Get setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** The job ID. */
        @com.google.api.client.util.Key
        private java.lang.String jobId;

        /** The job ID.
         */
        public java.lang.String getJobId() {
          return jobId;
        }

        /** The job ID. */
        public Get setJobId(java.lang.String jobId) {
          this.jobId = jobId;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       contains this job.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        public Get setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        /** The level of information requested in response. */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** The level of information requested in response.
         */
        public java.lang.String getView() {
          return view;
        }

        /** The level of information requested in response. */
        public Get setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Request the job status.
       *
       * To request the status of a job, we recommend using `projects.locations.jobs.getMetrics` with a
       * [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
       * `projects.jobs.getMetrics` is not recommended, as you can only request the status of jobs that
       * are running in `us-central1`.
       *
       * Create a request for the method "jobs.getMetrics".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link GetMetrics#execute()} method to invoke the remote operation.
       *
       * @param projectId A project id.
       * @param jobId The job to get messages for.
       * @return the request
       */
      public GetMetrics getMetrics(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
        GetMetrics result = new GetMetrics(projectId, jobId);
        initialize(result);
        return result;
      }

      public class GetMetrics extends DataflowRequest<com.google.api.services.dataflow.model.JobMetrics> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/metrics";

        /**
         * Request the job status.
         *
         * To request the status of a job, we recommend using `projects.locations.jobs.getMetrics` with a
         * [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
         * `projects.jobs.getMetrics` is not recommended, as you can only request the status of jobs that
         * are running in `us-central1`.
         *
         * Create a request for the method "jobs.getMetrics".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link GetMetrics#execute()} method to invoke the remote
         * operation. <p> {@link
         * GetMetrics#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId A project id.
         * @param jobId The job to get messages for.
         * @since 1.13
         */
        protected GetMetrics(java.lang.String projectId, java.lang.String jobId) {
          super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.JobMetrics.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetMetrics set$Xgafv(java.lang.String $Xgafv) {
          return (GetMetrics) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetMetrics setAccessToken(java.lang.String accessToken) {
          return (GetMetrics) super.setAccessToken(accessToken);
        }

        @Override
        public GetMetrics setAlt(java.lang.String alt) {
          return (GetMetrics) super.setAlt(alt);
        }

        @Override
        public GetMetrics setCallback(java.lang.String callback) {
          return (GetMetrics) super.setCallback(callback);
        }

        @Override
        public GetMetrics setFields(java.lang.String fields) {
          return (GetMetrics) super.setFields(fields);
        }

        @Override
        public GetMetrics setKey(java.lang.String key) {
          return (GetMetrics) super.setKey(key);
        }

        @Override
        public GetMetrics setOauthToken(java.lang.String oauthToken) {
          return (GetMetrics) super.setOauthToken(oauthToken);
        }

        @Override
        public GetMetrics setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetMetrics) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetMetrics setQuotaUser(java.lang.String quotaUser) {
          return (GetMetrics) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetMetrics setUploadType(java.lang.String uploadType) {
          return (GetMetrics) super.setUploadType(uploadType);
        }

        @Override
        public GetMetrics setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetMetrics) super.setUploadProtocol(uploadProtocol);
        }

        /** A project id. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** A project id.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** A project id. */
        public GetMetrics setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** The job to get messages for. */
        @com.google.api.client.util.Key
        private java.lang.String jobId;

        /** The job to get messages for.
         */
        public java.lang.String getJobId() {
          return jobId;
        }

        /** The job to get messages for. */
        public GetMetrics setJobId(java.lang.String jobId) {
          this.jobId = jobId;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains the job specified by job_id.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       contains the job specified by job_id.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains the job specified by job_id.
         */
        public GetMetrics setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        /**
         * Return only metric data that has changed since this time. Default is to return all
         * information about all metrics for the job.
         */
        @com.google.api.client.util.Key
        private String startTime;

        /** Return only metric data that has changed since this time. Default is to return all information
       about all metrics for the job.
         */
        public String getStartTime() {
          return startTime;
        }

        /**
         * Return only metric data that has changed since this time. Default is to return all
         * information about all metrics for the job.
         */
        public GetMetrics setStartTime(String startTime) {
          this.startTime = startTime;
          return this;
        }

        @Override
        public GetMetrics set(String parameterName, Object value) {
          return (GetMetrics) super.set(parameterName, value);
        }
      }
      /**
       * List the jobs of a project.
       *
       * To list the jobs of a project in a region, we recommend using `projects.locations.jobs.get` with
       * a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
       * list the all jobs across all regions, use `projects.jobs.aggregated`. Using `projects.jobs.list`
       * is not recommended, as you can only get the list of jobs that are running in `us-central1`.
       *
       * Create a request for the method "jobs.list".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param projectId The project which owns the jobs.
       * @return the request
       */
      public List list(java.lang.String projectId) throws java.io.IOException {
        List result = new List(projectId);
        initialize(result);
        return result;
      }

      public class List extends DataflowRequest<com.google.api.services.dataflow.model.ListJobsResponse> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/jobs";

        /**
         * List the jobs of a project.
         *
         * To list the jobs of a project in a region, we recommend using `projects.locations.jobs.get`
         * with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints). To list the all jobs across all regions, use `projects.jobs.aggregated`. Using
         * `projects.jobs.list` is not recommended, as you can only get the list of jobs that are running
         * in `us-central1`.
         *
         * Create a request for the method "jobs.list".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId The project which owns the jobs.
         * @since 1.13
         */
        protected List(java.lang.String projectId) {
          super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ListJobsResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The project which owns the jobs. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The project which owns the jobs.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The project which owns the jobs. */
        public List setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** The kind of filter to use. */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** The kind of filter to use.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /** The kind of filter to use. */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       contains this job.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        public List setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        /**
         * If there are many jobs, limit response to at most this many. The actual number of jobs
         * returned will be the lesser of max_responses and an unspecified server-defined limit.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** If there are many jobs, limit response to at most this many. The actual number of jobs returned
       will be the lesser of max_responses and an unspecified server-defined limit.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * If there are many jobs, limit response to at most this many. The actual number of jobs
         * returned will be the lesser of max_responses and an unspecified server-defined limit.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Set this to the 'next_page_token' field of a previous response to request additional
         * results in a long list.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Set this to the 'next_page_token' field of a previous response to request additional results in a
       long list.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * Set this to the 'next_page_token' field of a previous response to request additional
         * results in a long list.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`. */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`.
         */
        public java.lang.String getView() {
          return view;
        }

        /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`. */
        public List setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Snapshot the state of a streaming job.
       *
       * Create a request for the method "jobs.snapshot".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Snapshot#execute()} method to invoke the remote operation.
       *
       * @param projectId The project which owns the job to be snapshotted.
       * @param jobId The job to be snapshotted.
       * @param content the {@link com.google.api.services.dataflow.model.SnapshotJobRequest}
       * @return the request
       */
      public Snapshot snapshot(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.SnapshotJobRequest content) throws java.io.IOException {
        Snapshot result = new Snapshot(projectId, jobId, content);
        initialize(result);
        return result;
      }

      public class Snapshot extends DataflowRequest<com.google.api.services.dataflow.model.Snapshot> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}:snapshot";

        /**
         * Snapshot the state of a streaming job.
         *
         * Create a request for the method "jobs.snapshot".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Snapshot#execute()} method to invoke the remote operation.
         * <p> {@link
         * Snapshot#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId The project which owns the job to be snapshotted.
         * @param jobId The job to be snapshotted.
         * @param content the {@link com.google.api.services.dataflow.model.SnapshotJobRequest}
         * @since 1.13
         */
        protected Snapshot(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.SnapshotJobRequest content) {
          super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.Snapshot.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
        }

        @Override
        public Snapshot set$Xgafv(java.lang.String $Xgafv) {
          return (Snapshot) super.set$Xgafv($Xgafv);
        }

        @Override
        public Snapshot setAccessToken(java.lang.String accessToken) {
          return (Snapshot) super.setAccessToken(accessToken);
        }

        @Override
        public Snapshot setAlt(java.lang.String alt) {
          return (Snapshot) super.setAlt(alt);
        }

        @Override
        public Snapshot setCallback(java.lang.String callback) {
          return (Snapshot) super.setCallback(callback);
        }

        @Override
        public Snapshot setFields(java.lang.String fields) {
          return (Snapshot) super.setFields(fields);
        }

        @Override
        public Snapshot setKey(java.lang.String key) {
          return (Snapshot) super.setKey(key);
        }

        @Override
        public Snapshot setOauthToken(java.lang.String oauthToken) {
          return (Snapshot) super.setOauthToken(oauthToken);
        }

        @Override
        public Snapshot setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Snapshot) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Snapshot setQuotaUser(java.lang.String quotaUser) {
          return (Snapshot) super.setQuotaUser(quotaUser);
        }

        @Override
        public Snapshot setUploadType(java.lang.String uploadType) {
          return (Snapshot) super.setUploadType(uploadType);
        }

        @Override
        public Snapshot setUploadProtocol(java.lang.String uploadProtocol) {
          return (Snapshot) super.setUploadProtocol(uploadProtocol);
        }

        /** The project which owns the job to be snapshotted. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The project which owns the job to be snapshotted.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The project which owns the job to be snapshotted. */
        public Snapshot setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** The job to be snapshotted. */
        @com.google.api.client.util.Key
        private java.lang.String jobId;

        /** The job to be snapshotted.
         */
        public java.lang.String getJobId() {
          return jobId;
        }

        /** The job to be snapshotted. */
        public Snapshot setJobId(java.lang.String jobId) {
          this.jobId = jobId;
          return this;
        }

        @Override
        public Snapshot set(String parameterName, Object value) {
          return (Snapshot) super.set(parameterName, value);
        }
      }
      /**
       * Updates the state of an existing Cloud Dataflow job.
       *
       * To update the state of an existing job, we recommend using `projects.locations.jobs.update` with
       * a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
       * `projects.jobs.update` is not recommended, as you can only update the state of jobs that are
       * running in `us-central1`.
       *
       * Create a request for the method "jobs.update".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param projectId The ID of the Cloud Platform project that the job belongs to.
       * @param jobId The job ID.
       * @param content the {@link com.google.api.services.dataflow.model.Job}
       * @return the request
       */
      public Update update(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.Job content) throws java.io.IOException {
        Update result = new Update(projectId, jobId, content);
        initialize(result);
        return result;
      }

      public class Update extends DataflowRequest<com.google.api.services.dataflow.model.Job> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}";

        /**
         * Updates the state of an existing Cloud Dataflow job.
         *
         * To update the state of an existing job, we recommend using `projects.locations.jobs.update`
         * with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints). Using `projects.jobs.update` is not recommended, as you can only update the state
         * of jobs that are running in `us-central1`.
         *
         * Create a request for the method "jobs.update".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId The ID of the Cloud Platform project that the job belongs to.
         * @param jobId The job ID.
         * @param content the {@link com.google.api.services.dataflow.model.Job}
         * @since 1.13
         */
        protected Update(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.Job content) {
          super(Dataflow.this, "PUT", REST_PATH, content, com.google.api.services.dataflow.model.Job.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the Cloud Platform project that the job belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The ID of the Cloud Platform project that the job belongs to.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The ID of the Cloud Platform project that the job belongs to. */
        public Update setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** The job ID. */
        @com.google.api.client.util.Key
        private java.lang.String jobId;

        /** The job ID.
         */
        public java.lang.String getJobId() {
          return jobId;
        }

        /** The job ID. */
        public Update setJobId(java.lang.String jobId) {
          this.jobId = jobId;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       contains this job.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains this job.
         */
        public Update setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Debug collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataflow dataflow = new Dataflow(...);}
       *   {@code Dataflow.Debug.List request = dataflow.debug().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Debug debug() {
        return new Debug();
      }

      /**
       * The "debug" collection of methods.
       */
      public class Debug {

        /**
         * Get encoded debug configuration for component. Not cacheable.
         *
         * Create a request for the method "debug.getConfig".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link GetConfig#execute()} method to invoke the remote operation.
         *
         * @param projectId The project id.
         * @param jobId The job id.
         * @param content the {@link com.google.api.services.dataflow.model.GetDebugConfigRequest}
         * @return the request
         */
        public GetConfig getConfig(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.GetDebugConfigRequest content) throws java.io.IOException {
          GetConfig result = new GetConfig(projectId, jobId, content);
          initialize(result);
          return result;
        }

        public class GetConfig extends DataflowRequest<com.google.api.services.dataflow.model.GetDebugConfigResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/debug/getConfig";

          /**
           * Get encoded debug configuration for component. Not cacheable.
           *
           * Create a request for the method "debug.getConfig".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link GetConfig#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The project id.
           * @param jobId The job id.
           * @param content the {@link com.google.api.services.dataflow.model.GetDebugConfigRequest}
           * @since 1.13
           */
          protected GetConfig(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.GetDebugConfigRequest content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.GetDebugConfigResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public GetConfig set$Xgafv(java.lang.String $Xgafv) {
            return (GetConfig) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetConfig setAccessToken(java.lang.String accessToken) {
            return (GetConfig) super.setAccessToken(accessToken);
          }

          @Override
          public GetConfig setAlt(java.lang.String alt) {
            return (GetConfig) super.setAlt(alt);
          }

          @Override
          public GetConfig setCallback(java.lang.String callback) {
            return (GetConfig) super.setCallback(callback);
          }

          @Override
          public GetConfig setFields(java.lang.String fields) {
            return (GetConfig) super.setFields(fields);
          }

          @Override
          public GetConfig setKey(java.lang.String key) {
            return (GetConfig) super.setKey(key);
          }

          @Override
          public GetConfig setOauthToken(java.lang.String oauthToken) {
            return (GetConfig) super.setOauthToken(oauthToken);
          }

          @Override
          public GetConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetConfig) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetConfig setQuotaUser(java.lang.String quotaUser) {
            return (GetConfig) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetConfig setUploadType(java.lang.String uploadType) {
            return (GetConfig) super.setUploadType(uploadType);
          }

          @Override
          public GetConfig setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetConfig) super.setUploadProtocol(uploadProtocol);
          }

          /** The project id. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The project id.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The project id. */
          public GetConfig setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** The job id. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** The job id.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** The job id. */
          public GetConfig setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public GetConfig set(String parameterName, Object value) {
            return (GetConfig) super.set(parameterName, value);
          }
        }
        /**
         * Send encoded debug capture data for component.
         *
         * Create a request for the method "debug.sendCapture".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link SendCapture#execute()} method to invoke the remote operation.
         *
         * @param projectId The project id.
         * @param jobId The job id.
         * @param content the {@link com.google.api.services.dataflow.model.SendDebugCaptureRequest}
         * @return the request
         */
        public SendCapture sendCapture(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.SendDebugCaptureRequest content) throws java.io.IOException {
          SendCapture result = new SendCapture(projectId, jobId, content);
          initialize(result);
          return result;
        }

        public class SendCapture extends DataflowRequest<com.google.api.services.dataflow.model.SendDebugCaptureResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/debug/sendCapture";

          /**
           * Send encoded debug capture data for component.
           *
           * Create a request for the method "debug.sendCapture".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link SendCapture#execute()} method to invoke the remote
           * operation. <p> {@link
           * SendCapture#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The project id.
           * @param jobId The job id.
           * @param content the {@link com.google.api.services.dataflow.model.SendDebugCaptureRequest}
           * @since 1.13
           */
          protected SendCapture(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.SendDebugCaptureRequest content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.SendDebugCaptureResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public SendCapture set$Xgafv(java.lang.String $Xgafv) {
            return (SendCapture) super.set$Xgafv($Xgafv);
          }

          @Override
          public SendCapture setAccessToken(java.lang.String accessToken) {
            return (SendCapture) super.setAccessToken(accessToken);
          }

          @Override
          public SendCapture setAlt(java.lang.String alt) {
            return (SendCapture) super.setAlt(alt);
          }

          @Override
          public SendCapture setCallback(java.lang.String callback) {
            return (SendCapture) super.setCallback(callback);
          }

          @Override
          public SendCapture setFields(java.lang.String fields) {
            return (SendCapture) super.setFields(fields);
          }

          @Override
          public SendCapture setKey(java.lang.String key) {
            return (SendCapture) super.setKey(key);
          }

          @Override
          public SendCapture setOauthToken(java.lang.String oauthToken) {
            return (SendCapture) super.setOauthToken(oauthToken);
          }

          @Override
          public SendCapture setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SendCapture) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SendCapture setQuotaUser(java.lang.String quotaUser) {
            return (SendCapture) super.setQuotaUser(quotaUser);
          }

          @Override
          public SendCapture setUploadType(java.lang.String uploadType) {
            return (SendCapture) super.setUploadType(uploadType);
          }

          @Override
          public SendCapture setUploadProtocol(java.lang.String uploadProtocol) {
            return (SendCapture) super.setUploadProtocol(uploadProtocol);
          }

          /** The project id. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The project id.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The project id. */
          public SendCapture setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** The job id. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** The job id.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** The job id. */
          public SendCapture setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public SendCapture set(String parameterName, Object value) {
            return (SendCapture) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Messages collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataflow dataflow = new Dataflow(...);}
       *   {@code Dataflow.Messages.List request = dataflow.messages().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Messages messages() {
        return new Messages();
      }

      /**
       * The "messages" collection of methods.
       */
      public class Messages {

        /**
         * Request the job status.
         *
         * To request the status of a job, we recommend using `projects.locations.jobs.messages.list` with a
         * [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
         * `projects.jobs.messages.list` is not recommended, as you can only request the status of jobs that
         * are running in `us-central1`.
         *
         * Create a request for the method "messages.list".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param projectId A project id.
         * @param jobId The job to get messages about.
         * @return the request
         */
        public List list(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
          List result = new List(projectId, jobId);
          initialize(result);
          return result;
        }

        public class List extends DataflowRequest<com.google.api.services.dataflow.model.ListJobMessagesResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/messages";

          /**
           * Request the job status.
           *
           * To request the status of a job, we recommend using `projects.locations.jobs.messages.list` with
           * a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints).
           * Using `projects.jobs.messages.list` is not recommended, as you can only request the status of
           * jobs that are running in `us-central1`.
           *
           * Create a request for the method "messages.list".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId A project id.
           * @param jobId The job to get messages about.
           * @since 1.13
           */
          protected List(java.lang.String projectId, java.lang.String jobId) {
            super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ListJobMessagesResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** A project id. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** A project id.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** A project id. */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** The job to get messages about. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** The job to get messages about.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** The job to get messages about. */
          public List setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          /**
           * Return only messages with timestamps < end_time. The default is now (i.e. return up to
           * the latest messages available).
           */
          @com.google.api.client.util.Key
          private String endTime;

          /** Return only messages with timestamps < end_time. The default is now (i.e. return up to the latest
         messages available).
           */
          public String getEndTime() {
            return endTime;
          }

          /**
           * Return only messages with timestamps < end_time. The default is now (i.e. return up to
           * the latest messages available).
           */
          public List setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains the job specified by job_id.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         contains the job specified by job_id.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains the job specified by job_id.
           */
          public List setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** Filter to only get messages with importance >= level */
          @com.google.api.client.util.Key
          private java.lang.String minimumImportance;

          /** Filter to only get messages with importance >= level
           */
          public java.lang.String getMinimumImportance() {
            return minimumImportance;
          }

          /** Filter to only get messages with importance >= level */
          public List setMinimumImportance(java.lang.String minimumImportance) {
            this.minimumImportance = minimumImportance;
            return this;
          }

          /**
           * If specified, determines the maximum number of messages to return.  If unspecified, the
           * service may choose an appropriate default, or may return an arbitrarily large number of
           * results.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** If specified, determines the maximum number of messages to return.  If unspecified, the service may
         choose an appropriate default, or may return an arbitrarily large number of results.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * If specified, determines the maximum number of messages to return.  If unspecified, the
           * service may choose an appropriate default, or may return an arbitrarily large number of
           * results.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * If supplied, this should be the value of next_page_token returned by an earlier call.
           * This will cause the next page of results to be returned.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** If supplied, this should be the value of next_page_token returned by an earlier call. This will
         cause the next page of results to be returned.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * If supplied, this should be the value of next_page_token returned by an earlier call.
           * This will cause the next page of results to be returned.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * If specified, return only messages with timestamps >= start_time. The default is the
           * job creation time (i.e. beginning of messages).
           */
          @com.google.api.client.util.Key
          private String startTime;

          /** If specified, return only messages with timestamps >= start_time. The default is the job creation
         time (i.e. beginning of messages).
           */
          public String getStartTime() {
            return startTime;
          }

          /**
           * If specified, return only messages with timestamps >= start_time. The default is the
           * job creation time (i.e. beginning of messages).
           */
          public List setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the WorkItems collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataflow dataflow = new Dataflow(...);}
       *   {@code Dataflow.WorkItems.List request = dataflow.workItems().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public WorkItems workItems() {
        return new WorkItems();
      }

      /**
       * The "workItems" collection of methods.
       */
      public class WorkItems {

        /**
         * Leases a dataflow WorkItem to run.
         *
         * Create a request for the method "workItems.lease".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Lease#execute()} method to invoke the remote operation.
         *
         * @param projectId Identifies the project this worker belongs to.
         * @param jobId Identifies the workflow job this worker belongs to.
         * @param content the {@link com.google.api.services.dataflow.model.LeaseWorkItemRequest}
         * @return the request
         */
        public Lease lease(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.LeaseWorkItemRequest content) throws java.io.IOException {
          Lease result = new Lease(projectId, jobId, content);
          initialize(result);
          return result;
        }

        public class Lease extends DataflowRequest<com.google.api.services.dataflow.model.LeaseWorkItemResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/workItems:lease";

          /**
           * Leases a dataflow WorkItem to run.
           *
           * Create a request for the method "workItems.lease".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Lease#execute()} method to invoke the remote operation.
           * <p> {@link
           * Lease#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Identifies the project this worker belongs to.
           * @param jobId Identifies the workflow job this worker belongs to.
           * @param content the {@link com.google.api.services.dataflow.model.LeaseWorkItemRequest}
           * @since 1.13
           */
          protected Lease(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.LeaseWorkItemRequest content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.LeaseWorkItemResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public Lease set$Xgafv(java.lang.String $Xgafv) {
            return (Lease) super.set$Xgafv($Xgafv);
          }

          @Override
          public Lease setAccessToken(java.lang.String accessToken) {
            return (Lease) super.setAccessToken(accessToken);
          }

          @Override
          public Lease setAlt(java.lang.String alt) {
            return (Lease) super.setAlt(alt);
          }

          @Override
          public Lease setCallback(java.lang.String callback) {
            return (Lease) super.setCallback(callback);
          }

          @Override
          public Lease setFields(java.lang.String fields) {
            return (Lease) super.setFields(fields);
          }

          @Override
          public Lease setKey(java.lang.String key) {
            return (Lease) super.setKey(key);
          }

          @Override
          public Lease setOauthToken(java.lang.String oauthToken) {
            return (Lease) super.setOauthToken(oauthToken);
          }

          @Override
          public Lease setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Lease) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Lease setQuotaUser(java.lang.String quotaUser) {
            return (Lease) super.setQuotaUser(quotaUser);
          }

          @Override
          public Lease setUploadType(java.lang.String uploadType) {
            return (Lease) super.setUploadType(uploadType);
          }

          @Override
          public Lease setUploadProtocol(java.lang.String uploadProtocol) {
            return (Lease) super.setUploadProtocol(uploadProtocol);
          }

          /** Identifies the project this worker belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Identifies the project this worker belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Identifies the project this worker belongs to. */
          public Lease setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Identifies the workflow job this worker belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** Identifies the workflow job this worker belongs to.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** Identifies the workflow job this worker belongs to. */
          public Lease setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public Lease set(String parameterName, Object value) {
            return (Lease) super.set(parameterName, value);
          }
        }
        /**
         * Reports the status of dataflow WorkItems leased by a worker.
         *
         * Create a request for the method "workItems.reportStatus".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link ReportStatus#execute()} method to invoke the remote operation.
         *
         * @param projectId The project which owns the WorkItem's job.
         * @param jobId The job which the WorkItem is part of.
         * @param content the {@link com.google.api.services.dataflow.model.ReportWorkItemStatusRequest}
         * @return the request
         */
        public ReportStatus reportStatus(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.ReportWorkItemStatusRequest content) throws java.io.IOException {
          ReportStatus result = new ReportStatus(projectId, jobId, content);
          initialize(result);
          return result;
        }

        public class ReportStatus extends DataflowRequest<com.google.api.services.dataflow.model.ReportWorkItemStatusResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/workItems:reportStatus";

          /**
           * Reports the status of dataflow WorkItems leased by a worker.
           *
           * Create a request for the method "workItems.reportStatus".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link ReportStatus#execute()} method to invoke the remote
           * operation. <p> {@link
           * ReportStatus#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The project which owns the WorkItem's job.
           * @param jobId The job which the WorkItem is part of.
           * @param content the {@link com.google.api.services.dataflow.model.ReportWorkItemStatusRequest}
           * @since 1.13
           */
          protected ReportStatus(java.lang.String projectId, java.lang.String jobId, com.google.api.services.dataflow.model.ReportWorkItemStatusRequest content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.ReportWorkItemStatusResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public ReportStatus set$Xgafv(java.lang.String $Xgafv) {
            return (ReportStatus) super.set$Xgafv($Xgafv);
          }

          @Override
          public ReportStatus setAccessToken(java.lang.String accessToken) {
            return (ReportStatus) super.setAccessToken(accessToken);
          }

          @Override
          public ReportStatus setAlt(java.lang.String alt) {
            return (ReportStatus) super.setAlt(alt);
          }

          @Override
          public ReportStatus setCallback(java.lang.String callback) {
            return (ReportStatus) super.setCallback(callback);
          }

          @Override
          public ReportStatus setFields(java.lang.String fields) {
            return (ReportStatus) super.setFields(fields);
          }

          @Override
          public ReportStatus setKey(java.lang.String key) {
            return (ReportStatus) super.setKey(key);
          }

          @Override
          public ReportStatus setOauthToken(java.lang.String oauthToken) {
            return (ReportStatus) super.setOauthToken(oauthToken);
          }

          @Override
          public ReportStatus setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (ReportStatus) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public ReportStatus setQuotaUser(java.lang.String quotaUser) {
            return (ReportStatus) super.setQuotaUser(quotaUser);
          }

          @Override
          public ReportStatus setUploadType(java.lang.String uploadType) {
            return (ReportStatus) super.setUploadType(uploadType);
          }

          @Override
          public ReportStatus setUploadProtocol(java.lang.String uploadProtocol) {
            return (ReportStatus) super.setUploadProtocol(uploadProtocol);
          }

          /** The project which owns the WorkItem's job. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The project which owns the WorkItem's job.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The project which owns the WorkItem's job. */
          public ReportStatus setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** The job which the WorkItem is part of. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** The job which the WorkItem is part of.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** The job which the WorkItem is part of. */
          public ReportStatus setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public ReportStatus set(String parameterName, Object value) {
            return (ReportStatus) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Dataflow dataflow = new Dataflow(...);}
     *   {@code Dataflow.Locations.List request = dataflow.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * Send a worker_message to the service.
       *
       * Create a request for the method "locations.workerMessages".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link WorkerMessages#execute()} method to invoke the remote operation.
       *
       * @param projectId The project to send the WorkerMessages to.
       * @param location The [regional endpoint]
      (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       *        contains the job.
       * @param content the {@link com.google.api.services.dataflow.model.SendWorkerMessagesRequest}
       * @return the request
       */
      public WorkerMessages workerMessages(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.SendWorkerMessagesRequest content) throws java.io.IOException {
        WorkerMessages result = new WorkerMessages(projectId, location, content);
        initialize(result);
        return result;
      }

      public class WorkerMessages extends DataflowRequest<com.google.api.services.dataflow.model.SendWorkerMessagesResponse> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/WorkerMessages";

        /**
         * Send a worker_message to the service.
         *
         * Create a request for the method "locations.workerMessages".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link WorkerMessages#execute()} method to invoke the remote
         * operation. <p> {@link WorkerMessages#initialize(com.google.api.client.googleapis.services.Abstr
         * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param projectId The project to send the WorkerMessages to.
         * @param location The [regional endpoint]
      (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       *        contains the job.
         * @param content the {@link com.google.api.services.dataflow.model.SendWorkerMessagesRequest}
         * @since 1.13
         */
        protected WorkerMessages(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.SendWorkerMessagesRequest content) {
          super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.SendWorkerMessagesResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
        }

        @Override
        public WorkerMessages set$Xgafv(java.lang.String $Xgafv) {
          return (WorkerMessages) super.set$Xgafv($Xgafv);
        }

        @Override
        public WorkerMessages setAccessToken(java.lang.String accessToken) {
          return (WorkerMessages) super.setAccessToken(accessToken);
        }

        @Override
        public WorkerMessages setAlt(java.lang.String alt) {
          return (WorkerMessages) super.setAlt(alt);
        }

        @Override
        public WorkerMessages setCallback(java.lang.String callback) {
          return (WorkerMessages) super.setCallback(callback);
        }

        @Override
        public WorkerMessages setFields(java.lang.String fields) {
          return (WorkerMessages) super.setFields(fields);
        }

        @Override
        public WorkerMessages setKey(java.lang.String key) {
          return (WorkerMessages) super.setKey(key);
        }

        @Override
        public WorkerMessages setOauthToken(java.lang.String oauthToken) {
          return (WorkerMessages) super.setOauthToken(oauthToken);
        }

        @Override
        public WorkerMessages setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (WorkerMessages) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public WorkerMessages setQuotaUser(java.lang.String quotaUser) {
          return (WorkerMessages) super.setQuotaUser(quotaUser);
        }

        @Override
        public WorkerMessages setUploadType(java.lang.String uploadType) {
          return (WorkerMessages) super.setUploadType(uploadType);
        }

        @Override
        public WorkerMessages setUploadProtocol(java.lang.String uploadProtocol) {
          return (WorkerMessages) super.setUploadProtocol(uploadProtocol);
        }

        /** The project to send the WorkerMessages to. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The project to send the WorkerMessages to.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The project to send the WorkerMessages to. */
        public WorkerMessages setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains the job.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
       contains the job.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) that contains the job.
         */
        public WorkerMessages setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        @Override
        public WorkerMessages set(String parameterName, Object value) {
          return (WorkerMessages) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the FlexTemplates collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataflow dataflow = new Dataflow(...);}
       *   {@code Dataflow.FlexTemplates.List request = dataflow.flexTemplates().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public FlexTemplates flexTemplates() {
        return new FlexTemplates();
      }

      /**
       * The "flexTemplates" collection of methods.
       */
      public class FlexTemplates {

        /**
         * Launch a job with a FlexTemplate.
         *
         * Create a request for the method "flexTemplates.launch".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Launch#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
         * @param location Required. The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-
         *        endpoints) to
        which to direct the request. E.g., us-central1, us-west1.
         * @param content the {@link com.google.api.services.dataflow.model.LaunchFlexTemplateRequest}
         * @return the request
         */
        public Launch launch(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.LaunchFlexTemplateRequest content) throws java.io.IOException {
          Launch result = new Launch(projectId, location, content);
          initialize(result);
          return result;
        }

        public class Launch extends DataflowRequest<com.google.api.services.dataflow.model.LaunchFlexTemplateResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/flexTemplates:launch";

          /**
           * Launch a job with a FlexTemplate.
           *
           * Create a request for the method "flexTemplates.launch".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Launch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Launch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
           * @param location Required. The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-
         *        endpoints) to
        which to direct the request. E.g., us-central1, us-west1.
           * @param content the {@link com.google.api.services.dataflow.model.LaunchFlexTemplateRequest}
           * @since 1.13
           */
          protected Launch(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.LaunchFlexTemplateRequest content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.LaunchFlexTemplateResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
          }

          @Override
          public Launch set$Xgafv(java.lang.String $Xgafv) {
            return (Launch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Launch setAccessToken(java.lang.String accessToken) {
            return (Launch) super.setAccessToken(accessToken);
          }

          @Override
          public Launch setAlt(java.lang.String alt) {
            return (Launch) super.setAlt(alt);
          }

          @Override
          public Launch setCallback(java.lang.String callback) {
            return (Launch) super.setCallback(callback);
          }

          @Override
          public Launch setFields(java.lang.String fields) {
            return (Launch) super.setFields(fields);
          }

          @Override
          public Launch setKey(java.lang.String key) {
            return (Launch) super.setKey(key);
          }

          @Override
          public Launch setOauthToken(java.lang.String oauthToken) {
            return (Launch) super.setOauthToken(oauthToken);
          }

          @Override
          public Launch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Launch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Launch setQuotaUser(java.lang.String quotaUser) {
            return (Launch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Launch setUploadType(java.lang.String uploadType) {
            return (Launch) super.setUploadType(uploadType);
          }

          @Override
          public Launch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Launch) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          public Launch setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Required. The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts
           * /regional-endpoints) to which to direct the request. E.g., us-central1, us-west1.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** Required. The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         endpoints) to which to direct the request. E.g., us-central1, us-west1.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * Required. The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts
           * /regional-endpoints) to which to direct the request. E.g., us-central1, us-west1.
           */
          public Launch setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          @Override
          public Launch set(String parameterName, Object value) {
            return (Launch) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Jobs collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataflow dataflow = new Dataflow(...);}
       *   {@code Dataflow.Jobs.List request = dataflow.jobs().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Jobs jobs() {
        return new Jobs();
      }

      /**
       * The "jobs" collection of methods.
       */
      public class Jobs {

        /**
         * Creates a Cloud Dataflow job.
         *
         * To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint]
         * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
         * `projects.jobs.create` is not recommended, as your job will always start in `us-central1`.
         *
         * Create a request for the method "jobs.create".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param projectId The ID of the Cloud Platform project that the job belongs to.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains this job.
         * @param content the {@link com.google.api.services.dataflow.model.Job}
         * @return the request
         */
        public Create create(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.Job content) throws java.io.IOException {
          Create result = new Create(projectId, location, content);
          initialize(result);
          return result;
        }

        public class Create extends DataflowRequest<com.google.api.services.dataflow.model.Job> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs";

          /**
           * Creates a Cloud Dataflow job.
           *
           * To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint]
           * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
           * `projects.jobs.create` is not recommended, as your job will always start in `us-central1`.
           *
           * Create a request for the method "jobs.create".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The ID of the Cloud Platform project that the job belongs to.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains this job.
           * @param content the {@link com.google.api.services.dataflow.model.Job}
           * @since 1.13
           */
          protected Create(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.Job content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.Job.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** The ID of the Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The ID of the Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The ID of the Cloud Platform project that the job belongs to. */
          public Create setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains this job.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         contains this job.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains this job.
           */
          public Create setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** Deprecated. This field is now in the Job message. */
          @com.google.api.client.util.Key
          private java.lang.String replaceJobId;

          /** Deprecated. This field is now in the Job message.
           */
          public java.lang.String getReplaceJobId() {
            return replaceJobId;
          }

          /** Deprecated. This field is now in the Job message. */
          public Create setReplaceJobId(java.lang.String replaceJobId) {
            this.replaceJobId = replaceJobId;
            return this;
          }

          /** The level of information requested in response. */
          @com.google.api.client.util.Key
          private java.lang.String view;

          /** The level of information requested in response.
           */
          public java.lang.String getView() {
            return view;
          }

          /** The level of information requested in response. */
          public Create setView(java.lang.String view) {
            this.view = view;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Gets the state of the specified Cloud Dataflow job.
         *
         * To get the state of a job, we recommend using `projects.locations.jobs.get` with a [regional
         * endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
         * `projects.jobs.get` is not recommended, as you can only get the state of jobs that are running in
         * `us-central1`.
         *
         * Create a request for the method "jobs.get".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param projectId The ID of the Cloud Platform project that the job belongs to.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains this job.
         * @param jobId The job ID.
         * @return the request
         */
        public Get get(java.lang.String projectId, java.lang.String location, java.lang.String jobId) throws java.io.IOException {
          Get result = new Get(projectId, location, jobId);
          initialize(result);
          return result;
        }

        public class Get extends DataflowRequest<com.google.api.services.dataflow.model.Job> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}";

          /**
           * Gets the state of the specified Cloud Dataflow job.
           *
           * To get the state of a job, we recommend using `projects.locations.jobs.get` with a [regional
           * endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
           * `projects.jobs.get` is not recommended, as you can only get the state of jobs that are running
           * in `us-central1`.
           *
           * Create a request for the method "jobs.get".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The ID of the Cloud Platform project that the job belongs to.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains this job.
           * @param jobId The job ID.
           * @since 1.13
           */
          protected Get(java.lang.String projectId, java.lang.String location, java.lang.String jobId) {
            super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.Job.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The ID of the Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The ID of the Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The ID of the Cloud Platform project that the job belongs to. */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains this job.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         contains this job.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains this job.
           */
          public Get setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** The job ID. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** The job ID.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** The job ID. */
          public Get setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          /** The level of information requested in response. */
          @com.google.api.client.util.Key
          private java.lang.String view;

          /** The level of information requested in response.
           */
          public java.lang.String getView() {
            return view;
          }

          /** The level of information requested in response. */
          public Get setView(java.lang.String view) {
            this.view = view;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Request the job status.
         *
         * To request the status of a job, we recommend using `projects.locations.jobs.getMetrics` with a
         * [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
         * `projects.jobs.getMetrics` is not recommended, as you can only request the status of jobs that
         * are running in `us-central1`.
         *
         * Create a request for the method "jobs.getMetrics".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link GetMetrics#execute()} method to invoke the remote operation.
         *
         * @param projectId A project id.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains the job specified by job_id.
         * @param jobId The job to get messages for.
         * @return the request
         */
        public GetMetrics getMetrics(java.lang.String projectId, java.lang.String location, java.lang.String jobId) throws java.io.IOException {
          GetMetrics result = new GetMetrics(projectId, location, jobId);
          initialize(result);
          return result;
        }

        public class GetMetrics extends DataflowRequest<com.google.api.services.dataflow.model.JobMetrics> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/metrics";

          /**
           * Request the job status.
           *
           * To request the status of a job, we recommend using `projects.locations.jobs.getMetrics` with a
           * [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
           * `projects.jobs.getMetrics` is not recommended, as you can only request the status of jobs that
           * are running in `us-central1`.
           *
           * Create a request for the method "jobs.getMetrics".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link GetMetrics#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetMetrics#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId A project id.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains the job specified by job_id.
           * @param jobId The job to get messages for.
           * @since 1.13
           */
          protected GetMetrics(java.lang.String projectId, java.lang.String location, java.lang.String jobId) {
            super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.JobMetrics.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetMetrics set$Xgafv(java.lang.String $Xgafv) {
            return (GetMetrics) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetMetrics setAccessToken(java.lang.String accessToken) {
            return (GetMetrics) super.setAccessToken(accessToken);
          }

          @Override
          public GetMetrics setAlt(java.lang.String alt) {
            return (GetMetrics) super.setAlt(alt);
          }

          @Override
          public GetMetrics setCallback(java.lang.String callback) {
            return (GetMetrics) super.setCallback(callback);
          }

          @Override
          public GetMetrics setFields(java.lang.String fields) {
            return (GetMetrics) super.setFields(fields);
          }

          @Override
          public GetMetrics setKey(java.lang.String key) {
            return (GetMetrics) super.setKey(key);
          }

          @Override
          public GetMetrics setOauthToken(java.lang.String oauthToken) {
            return (GetMetrics) super.setOauthToken(oauthToken);
          }

          @Override
          public GetMetrics setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetMetrics) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetMetrics setQuotaUser(java.lang.String quotaUser) {
            return (GetMetrics) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetMetrics setUploadType(java.lang.String uploadType) {
            return (GetMetrics) super.setUploadType(uploadType);
          }

          @Override
          public GetMetrics setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetMetrics) super.setUploadProtocol(uploadProtocol);
          }

          /** A project id. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** A project id.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** A project id. */
          public GetMetrics setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains the job specified by job_id.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         contains the job specified by job_id.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains the job specified by job_id.
           */
          public GetMetrics setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** The job to get messages for. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** The job to get messages for.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** The job to get messages for. */
          public GetMetrics setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          /**
           * Return only metric data that has changed since this time. Default is to return all
           * information about all metrics for the job.
           */
          @com.google.api.client.util.Key
          private String startTime;

          /** Return only metric data that has changed since this time. Default is to return all information
         about all metrics for the job.
           */
          public String getStartTime() {
            return startTime;
          }

          /**
           * Return only metric data that has changed since this time. Default is to return all
           * information about all metrics for the job.
           */
          public GetMetrics setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
          }

          @Override
          public GetMetrics set(String parameterName, Object value) {
            return (GetMetrics) super.set(parameterName, value);
          }
        }
        /**
         * List the jobs of a project.
         *
         * To list the jobs of a project in a region, we recommend using `projects.locations.jobs.get` with
         * a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
         * list the all jobs across all regions, use `projects.jobs.aggregated`. Using `projects.jobs.list`
         * is not recommended, as you can only get the list of jobs that are running in `us-central1`.
         *
         * Create a request for the method "jobs.list".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param projectId The project which owns the jobs.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains this job.
         * @return the request
         */
        public List list(java.lang.String projectId, java.lang.String location) throws java.io.IOException {
          List result = new List(projectId, location);
          initialize(result);
          return result;
        }

        public class List extends DataflowRequest<com.google.api.services.dataflow.model.ListJobsResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs";

          /**
           * List the jobs of a project.
           *
           * To list the jobs of a project in a region, we recommend using `projects.locations.jobs.get`
           * with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints). To list the all jobs across all regions, use `projects.jobs.aggregated`. Using
           * `projects.jobs.list` is not recommended, as you can only get the list of jobs that are running
           * in `us-central1`.
           *
           * Create a request for the method "jobs.list".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The project which owns the jobs.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains this job.
           * @since 1.13
           */
          protected List(java.lang.String projectId, java.lang.String location) {
            super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ListJobsResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The project which owns the jobs. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The project which owns the jobs.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The project which owns the jobs. */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains this job.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         contains this job.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains this job.
           */
          public List setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** The kind of filter to use. */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** The kind of filter to use.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /** The kind of filter to use. */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * If there are many jobs, limit response to at most this many. The actual number of jobs
           * returned will be the lesser of max_responses and an unspecified server-defined limit.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** If there are many jobs, limit response to at most this many. The actual number of jobs returned
         will be the lesser of max_responses and an unspecified server-defined limit.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * If there are many jobs, limit response to at most this many. The actual number of jobs
           * returned will be the lesser of max_responses and an unspecified server-defined limit.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * Set this to the 'next_page_token' field of a previous response to request additional
           * results in a long list.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Set this to the 'next_page_token' field of a previous response to request additional results in a
         long list.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Set this to the 'next_page_token' field of a previous response to request additional
           * results in a long list.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`. */
          @com.google.api.client.util.Key
          private java.lang.String view;

          /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`.
           */
          public java.lang.String getView() {
            return view;
          }

          /** Level of information requested in response. Default is `JOB_VIEW_SUMMARY`. */
          public List setView(java.lang.String view) {
            this.view = view;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Snapshot the state of a streaming job.
         *
         * Create a request for the method "jobs.snapshot".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Snapshot#execute()} method to invoke the remote operation.
         *
         * @param projectId The project which owns the job to be snapshotted.
         * @param location The location that contains this job.
         * @param jobId The job to be snapshotted.
         * @param content the {@link com.google.api.services.dataflow.model.SnapshotJobRequest}
         * @return the request
         */
        public Snapshot snapshot(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.SnapshotJobRequest content) throws java.io.IOException {
          Snapshot result = new Snapshot(projectId, location, jobId, content);
          initialize(result);
          return result;
        }

        public class Snapshot extends DataflowRequest<com.google.api.services.dataflow.model.Snapshot> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}:snapshot";

          /**
           * Snapshot the state of a streaming job.
           *
           * Create a request for the method "jobs.snapshot".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Snapshot#execute()} method to invoke the remote operation.
           * <p> {@link
           * Snapshot#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The project which owns the job to be snapshotted.
           * @param location The location that contains this job.
           * @param jobId The job to be snapshotted.
           * @param content the {@link com.google.api.services.dataflow.model.SnapshotJobRequest}
           * @since 1.13
           */
          protected Snapshot(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.SnapshotJobRequest content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.Snapshot.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public Snapshot set$Xgafv(java.lang.String $Xgafv) {
            return (Snapshot) super.set$Xgafv($Xgafv);
          }

          @Override
          public Snapshot setAccessToken(java.lang.String accessToken) {
            return (Snapshot) super.setAccessToken(accessToken);
          }

          @Override
          public Snapshot setAlt(java.lang.String alt) {
            return (Snapshot) super.setAlt(alt);
          }

          @Override
          public Snapshot setCallback(java.lang.String callback) {
            return (Snapshot) super.setCallback(callback);
          }

          @Override
          public Snapshot setFields(java.lang.String fields) {
            return (Snapshot) super.setFields(fields);
          }

          @Override
          public Snapshot setKey(java.lang.String key) {
            return (Snapshot) super.setKey(key);
          }

          @Override
          public Snapshot setOauthToken(java.lang.String oauthToken) {
            return (Snapshot) super.setOauthToken(oauthToken);
          }

          @Override
          public Snapshot setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Snapshot) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Snapshot setQuotaUser(java.lang.String quotaUser) {
            return (Snapshot) super.setQuotaUser(quotaUser);
          }

          @Override
          public Snapshot setUploadType(java.lang.String uploadType) {
            return (Snapshot) super.setUploadType(uploadType);
          }

          @Override
          public Snapshot setUploadProtocol(java.lang.String uploadProtocol) {
            return (Snapshot) super.setUploadProtocol(uploadProtocol);
          }

          /** The project which owns the job to be snapshotted. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The project which owns the job to be snapshotted.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The project which owns the job to be snapshotted. */
          public Snapshot setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** The location that contains this job. */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The location that contains this job.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /** The location that contains this job. */
          public Snapshot setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** The job to be snapshotted. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** The job to be snapshotted.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** The job to be snapshotted. */
          public Snapshot setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public Snapshot set(String parameterName, Object value) {
            return (Snapshot) super.set(parameterName, value);
          }
        }
        /**
         * Updates the state of an existing Cloud Dataflow job.
         *
         * To update the state of an existing job, we recommend using `projects.locations.jobs.update` with
         * a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
         * `projects.jobs.update` is not recommended, as you can only update the state of jobs that are
         * running in `us-central1`.
         *
         * Create a request for the method "jobs.update".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation.
         *
         * @param projectId The ID of the Cloud Platform project that the job belongs to.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains this job.
         * @param jobId The job ID.
         * @param content the {@link com.google.api.services.dataflow.model.Job}
         * @return the request
         */
        public Update update(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.Job content) throws java.io.IOException {
          Update result = new Update(projectId, location, jobId, content);
          initialize(result);
          return result;
        }

        public class Update extends DataflowRequest<com.google.api.services.dataflow.model.Job> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}";

          /**
           * Updates the state of an existing Cloud Dataflow job.
           *
           * To update the state of an existing job, we recommend using `projects.locations.jobs.update`
           * with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints). Using `projects.jobs.update` is not recommended, as you can only update the state
           * of jobs that are running in `us-central1`.
           *
           * Create a request for the method "jobs.update".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
           * <p> {@link
           * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The ID of the Cloud Platform project that the job belongs to.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         *        contains this job.
           * @param jobId The job ID.
           * @param content the {@link com.google.api.services.dataflow.model.Job}
           * @since 1.13
           */
          protected Update(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.Job content) {
            super(Dataflow.this, "PUT", REST_PATH, content, com.google.api.services.dataflow.model.Job.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public Update set$Xgafv(java.lang.String $Xgafv) {
            return (Update) super.set$Xgafv($Xgafv);
          }

          @Override
          public Update setAccessToken(java.lang.String accessToken) {
            return (Update) super.setAccessToken(accessToken);
          }

          @Override
          public Update setAlt(java.lang.String alt) {
            return (Update) super.setAlt(alt);
          }

          @Override
          public Update setCallback(java.lang.String callback) {
            return (Update) super.setCallback(callback);
          }

          @Override
          public Update setFields(java.lang.String fields) {
            return (Update) super.setFields(fields);
          }

          @Override
          public Update setKey(java.lang.String key) {
            return (Update) super.setKey(key);
          }

          @Override
          public Update setOauthToken(java.lang.String oauthToken) {
            return (Update) super.setOauthToken(oauthToken);
          }

          @Override
          public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Update) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Update setQuotaUser(java.lang.String quotaUser) {
            return (Update) super.setQuotaUser(quotaUser);
          }

          @Override
          public Update setUploadType(java.lang.String uploadType) {
            return (Update) super.setUploadType(uploadType);
          }

          @Override
          public Update setUploadProtocol(java.lang.String uploadProtocol) {
            return (Update) super.setUploadProtocol(uploadProtocol);
          }

          /** The ID of the Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The ID of the Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The ID of the Cloud Platform project that the job belongs to. */
          public Update setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains this job.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
         contains this job.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) that contains this job.
           */
          public Update setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** The job ID. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** The job ID.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** The job ID. */
          public Update setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public Update set(String parameterName, Object value) {
            return (Update) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the Debug collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Dataflow dataflow = new Dataflow(...);}
         *   {@code Dataflow.Debug.List request = dataflow.debug().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Debug debug() {
          return new Debug();
        }

        /**
         * The "debug" collection of methods.
         */
        public class Debug {

          /**
           * Get encoded debug configuration for component. Not cacheable.
           *
           * Create a request for the method "debug.getConfig".
           *
           * This request holds the parameters needed by the dataflow server.  After setting any optional
           * parameters, call the {@link GetConfig#execute()} method to invoke the remote operation.
           *
           * @param projectId The project id.
           * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the job specified by job_id.
           * @param jobId The job id.
           * @param content the {@link com.google.api.services.dataflow.model.GetDebugConfigRequest}
           * @return the request
           */
          public GetConfig getConfig(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.GetDebugConfigRequest content) throws java.io.IOException {
            GetConfig result = new GetConfig(projectId, location, jobId, content);
            initialize(result);
            return result;
          }

          public class GetConfig extends DataflowRequest<com.google.api.services.dataflow.model.GetDebugConfigResponse> {

            private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/debug/getConfig";

            /**
             * Get encoded debug configuration for component. Not cacheable.
             *
             * Create a request for the method "debug.getConfig".
             *
             * This request holds the parameters needed by the the dataflow server.  After setting any
             * optional parameters, call the {@link GetConfig#execute()} method to invoke the remote
             * operation. <p> {@link
             * GetConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId The project id.
             * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the job specified by job_id.
             * @param jobId The job id.
             * @param content the {@link com.google.api.services.dataflow.model.GetDebugConfigRequest}
             * @since 1.13
             */
            protected GetConfig(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.GetDebugConfigRequest content) {
              super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.GetDebugConfigResponse.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
              this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
            }

            @Override
            public GetConfig set$Xgafv(java.lang.String $Xgafv) {
              return (GetConfig) super.set$Xgafv($Xgafv);
            }

            @Override
            public GetConfig setAccessToken(java.lang.String accessToken) {
              return (GetConfig) super.setAccessToken(accessToken);
            }

            @Override
            public GetConfig setAlt(java.lang.String alt) {
              return (GetConfig) super.setAlt(alt);
            }

            @Override
            public GetConfig setCallback(java.lang.String callback) {
              return (GetConfig) super.setCallback(callback);
            }

            @Override
            public GetConfig setFields(java.lang.String fields) {
              return (GetConfig) super.setFields(fields);
            }

            @Override
            public GetConfig setKey(java.lang.String key) {
              return (GetConfig) super.setKey(key);
            }

            @Override
            public GetConfig setOauthToken(java.lang.String oauthToken) {
              return (GetConfig) super.setOauthToken(oauthToken);
            }

            @Override
            public GetConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (GetConfig) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public GetConfig setQuotaUser(java.lang.String quotaUser) {
              return (GetConfig) super.setQuotaUser(quotaUser);
            }

            @Override
            public GetConfig setUploadType(java.lang.String uploadType) {
              return (GetConfig) super.setUploadType(uploadType);
            }

            @Override
            public GetConfig setUploadProtocol(java.lang.String uploadProtocol) {
              return (GetConfig) super.setUploadProtocol(uploadProtocol);
            }

            /** The project id. */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** The project id.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /** The project id. */
            public GetConfig setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the job specified by job_id.
             */
            @com.google.api.client.util.Key
            private java.lang.String location;

            /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           contains the job specified by job_id.
             */
            public java.lang.String getLocation() {
              return location;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the job specified by job_id.
             */
            public GetConfig setLocation(java.lang.String location) {
              this.location = location;
              return this;
            }

            /** The job id. */
            @com.google.api.client.util.Key
            private java.lang.String jobId;

            /** The job id.
             */
            public java.lang.String getJobId() {
              return jobId;
            }

            /** The job id. */
            public GetConfig setJobId(java.lang.String jobId) {
              this.jobId = jobId;
              return this;
            }

            @Override
            public GetConfig set(String parameterName, Object value) {
              return (GetConfig) super.set(parameterName, value);
            }
          }
          /**
           * Send encoded debug capture data for component.
           *
           * Create a request for the method "debug.sendCapture".
           *
           * This request holds the parameters needed by the dataflow server.  After setting any optional
           * parameters, call the {@link SendCapture#execute()} method to invoke the remote operation.
           *
           * @param projectId The project id.
           * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the job specified by job_id.
           * @param jobId The job id.
           * @param content the {@link com.google.api.services.dataflow.model.SendDebugCaptureRequest}
           * @return the request
           */
          public SendCapture sendCapture(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.SendDebugCaptureRequest content) throws java.io.IOException {
            SendCapture result = new SendCapture(projectId, location, jobId, content);
            initialize(result);
            return result;
          }

          public class SendCapture extends DataflowRequest<com.google.api.services.dataflow.model.SendDebugCaptureResponse> {

            private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/debug/sendCapture";

            /**
             * Send encoded debug capture data for component.
             *
             * Create a request for the method "debug.sendCapture".
             *
             * This request holds the parameters needed by the the dataflow server.  After setting any
             * optional parameters, call the {@link SendCapture#execute()} method to invoke the remote
             * operation. <p> {@link
             * SendCapture#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId The project id.
             * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the job specified by job_id.
             * @param jobId The job id.
             * @param content the {@link com.google.api.services.dataflow.model.SendDebugCaptureRequest}
             * @since 1.13
             */
            protected SendCapture(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.SendDebugCaptureRequest content) {
              super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.SendDebugCaptureResponse.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
              this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
            }

            @Override
            public SendCapture set$Xgafv(java.lang.String $Xgafv) {
              return (SendCapture) super.set$Xgafv($Xgafv);
            }

            @Override
            public SendCapture setAccessToken(java.lang.String accessToken) {
              return (SendCapture) super.setAccessToken(accessToken);
            }

            @Override
            public SendCapture setAlt(java.lang.String alt) {
              return (SendCapture) super.setAlt(alt);
            }

            @Override
            public SendCapture setCallback(java.lang.String callback) {
              return (SendCapture) super.setCallback(callback);
            }

            @Override
            public SendCapture setFields(java.lang.String fields) {
              return (SendCapture) super.setFields(fields);
            }

            @Override
            public SendCapture setKey(java.lang.String key) {
              return (SendCapture) super.setKey(key);
            }

            @Override
            public SendCapture setOauthToken(java.lang.String oauthToken) {
              return (SendCapture) super.setOauthToken(oauthToken);
            }

            @Override
            public SendCapture setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SendCapture) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SendCapture setQuotaUser(java.lang.String quotaUser) {
              return (SendCapture) super.setQuotaUser(quotaUser);
            }

            @Override
            public SendCapture setUploadType(java.lang.String uploadType) {
              return (SendCapture) super.setUploadType(uploadType);
            }

            @Override
            public SendCapture setUploadProtocol(java.lang.String uploadProtocol) {
              return (SendCapture) super.setUploadProtocol(uploadProtocol);
            }

            /** The project id. */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** The project id.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /** The project id. */
            public SendCapture setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the job specified by job_id.
             */
            @com.google.api.client.util.Key
            private java.lang.String location;

            /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           contains the job specified by job_id.
             */
            public java.lang.String getLocation() {
              return location;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the job specified by job_id.
             */
            public SendCapture setLocation(java.lang.String location) {
              this.location = location;
              return this;
            }

            /** The job id. */
            @com.google.api.client.util.Key
            private java.lang.String jobId;

            /** The job id.
             */
            public java.lang.String getJobId() {
              return jobId;
            }

            /** The job id. */
            public SendCapture setJobId(java.lang.String jobId) {
              this.jobId = jobId;
              return this;
            }

            @Override
            public SendCapture set(String parameterName, Object value) {
              return (SendCapture) super.set(parameterName, value);
            }
          }

        }
        /**
         * An accessor for creating requests from the Messages collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Dataflow dataflow = new Dataflow(...);}
         *   {@code Dataflow.Messages.List request = dataflow.messages().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Messages messages() {
          return new Messages();
        }

        /**
         * The "messages" collection of methods.
         */
        public class Messages {

          /**
           * Request the job status.
           *
           * To request the status of a job, we recommend using `projects.locations.jobs.messages.list` with a
           * [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
           * `projects.jobs.messages.list` is not recommended, as you can only request the status of jobs that
           * are running in `us-central1`.
           *
           * Create a request for the method "messages.list".
           *
           * This request holds the parameters needed by the dataflow server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param projectId A project id.
           * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the job specified by job_id.
           * @param jobId The job to get messages about.
           * @return the request
           */
          public List list(java.lang.String projectId, java.lang.String location, java.lang.String jobId) throws java.io.IOException {
            List result = new List(projectId, location, jobId);
            initialize(result);
            return result;
          }

          public class List extends DataflowRequest<com.google.api.services.dataflow.model.ListJobMessagesResponse> {

            private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/messages";

            /**
             * Request the job status.
             *
             * To request the status of a job, we recommend using `projects.locations.jobs.messages.list` with
             * a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints).
             * Using `projects.jobs.messages.list` is not recommended, as you can only request the status of
             * jobs that are running in `us-central1`.
             *
             * Create a request for the method "messages.list".
             *
             * This request holds the parameters needed by the the dataflow server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId A project id.
             * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the job specified by job_id.
             * @param jobId The job to get messages about.
             * @since 1.13
             */
            protected List(java.lang.String projectId, java.lang.String location, java.lang.String jobId) {
              super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ListJobMessagesResponse.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
              this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** A project id. */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** A project id.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /** A project id. */
            public List setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the job specified by job_id.
             */
            @com.google.api.client.util.Key
            private java.lang.String location;

            /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           contains the job specified by job_id.
             */
            public java.lang.String getLocation() {
              return location;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the job specified by job_id.
             */
            public List setLocation(java.lang.String location) {
              this.location = location;
              return this;
            }

            /** The job to get messages about. */
            @com.google.api.client.util.Key
            private java.lang.String jobId;

            /** The job to get messages about.
             */
            public java.lang.String getJobId() {
              return jobId;
            }

            /** The job to get messages about. */
            public List setJobId(java.lang.String jobId) {
              this.jobId = jobId;
              return this;
            }

            /**
             * Return only messages with timestamps < end_time. The default is now (i.e. return up
             * to the latest messages available).
             */
            @com.google.api.client.util.Key
            private String endTime;

            /** Return only messages with timestamps < end_time. The default is now (i.e. return up to the latest
           messages available).
             */
            public String getEndTime() {
              return endTime;
            }

            /**
             * Return only messages with timestamps < end_time. The default is now (i.e. return up
             * to the latest messages available).
             */
            public List setEndTime(String endTime) {
              this.endTime = endTime;
              return this;
            }

            /** Filter to only get messages with importance >= level */
            @com.google.api.client.util.Key
            private java.lang.String minimumImportance;

            /** Filter to only get messages with importance >= level
             */
            public java.lang.String getMinimumImportance() {
              return minimumImportance;
            }

            /** Filter to only get messages with importance >= level */
            public List setMinimumImportance(java.lang.String minimumImportance) {
              this.minimumImportance = minimumImportance;
              return this;
            }

            /**
             * If specified, determines the maximum number of messages to return.  If unspecified,
             * the service may choose an appropriate default, or may return an arbitrarily large
             * number of results.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** If specified, determines the maximum number of messages to return.  If unspecified, the service may
           choose an appropriate default, or may return an arbitrarily large number of results.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * If specified, determines the maximum number of messages to return.  If unspecified,
             * the service may choose an appropriate default, or may return an arbitrarily large
             * number of results.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /**
             * If supplied, this should be the value of next_page_token returned by an earlier call.
             * This will cause the next page of results to be returned.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** If supplied, this should be the value of next_page_token returned by an earlier call. This will
           cause the next page of results to be returned.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * If supplied, this should be the value of next_page_token returned by an earlier call.
             * This will cause the next page of results to be returned.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            /**
             * If specified, return only messages with timestamps >= start_time. The default is the
             * job creation time (i.e. beginning of messages).
             */
            @com.google.api.client.util.Key
            private String startTime;

            /** If specified, return only messages with timestamps >= start_time. The default is the job creation
           time (i.e. beginning of messages).
             */
            public String getStartTime() {
              return startTime;
            }

            /**
             * If specified, return only messages with timestamps >= start_time. The default is the
             * job creation time (i.e. beginning of messages).
             */
            public List setStartTime(String startTime) {
              this.startTime = startTime;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }

        }
        /**
         * An accessor for creating requests from the Snapshots collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Dataflow dataflow = new Dataflow(...);}
         *   {@code Dataflow.Snapshots.List request = dataflow.snapshots().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Snapshots snapshots() {
          return new Snapshots();
        }

        /**
         * The "snapshots" collection of methods.
         */
        public class Snapshots {

          /**
           * Lists snapshots.
           *
           * Create a request for the method "snapshots.list".
           *
           * This request holds the parameters needed by the dataflow server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param projectId The project ID to list snapshots for.
           * @param location The location to list snapshots in.
           * @param jobId If specified, list snapshots created from this job.
           * @return the request
           */
          public List list(java.lang.String projectId, java.lang.String location, java.lang.String jobId) throws java.io.IOException {
            List result = new List(projectId, location, jobId);
            initialize(result);
            return result;
          }

          public class List extends DataflowRequest<com.google.api.services.dataflow.model.ListSnapshotsResponse> {

            private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/snapshots";

            /**
             * Lists snapshots.
             *
             * Create a request for the method "snapshots.list".
             *
             * This request holds the parameters needed by the the dataflow server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId The project ID to list snapshots for.
             * @param location The location to list snapshots in.
             * @param jobId If specified, list snapshots created from this job.
             * @since 1.13
             */
            protected List(java.lang.String projectId, java.lang.String location, java.lang.String jobId) {
              super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ListSnapshotsResponse.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
              this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** The project ID to list snapshots for. */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** The project ID to list snapshots for.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /** The project ID to list snapshots for. */
            public List setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /** The location to list snapshots in. */
            @com.google.api.client.util.Key
            private java.lang.String location;

            /** The location to list snapshots in.
             */
            public java.lang.String getLocation() {
              return location;
            }

            /** The location to list snapshots in. */
            public List setLocation(java.lang.String location) {
              this.location = location;
              return this;
            }

            /** If specified, list snapshots created from this job. */
            @com.google.api.client.util.Key
            private java.lang.String jobId;

            /** If specified, list snapshots created from this job.
             */
            public java.lang.String getJobId() {
              return jobId;
            }

            /** If specified, list snapshots created from this job. */
            public List setJobId(java.lang.String jobId) {
              this.jobId = jobId;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }

        }
        /**
         * An accessor for creating requests from the WorkItems collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Dataflow dataflow = new Dataflow(...);}
         *   {@code Dataflow.WorkItems.List request = dataflow.workItems().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public WorkItems workItems() {
          return new WorkItems();
        }

        /**
         * The "workItems" collection of methods.
         */
        public class WorkItems {

          /**
           * Leases a dataflow WorkItem to run.
           *
           * Create a request for the method "workItems.lease".
           *
           * This request holds the parameters needed by the dataflow server.  After setting any optional
           * parameters, call the {@link Lease#execute()} method to invoke the remote operation.
           *
           * @param projectId Identifies the project this worker belongs to.
           * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the WorkItem's job.
           * @param jobId Identifies the workflow job this worker belongs to.
           * @param content the {@link com.google.api.services.dataflow.model.LeaseWorkItemRequest}
           * @return the request
           */
          public Lease lease(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.LeaseWorkItemRequest content) throws java.io.IOException {
            Lease result = new Lease(projectId, location, jobId, content);
            initialize(result);
            return result;
          }

          public class Lease extends DataflowRequest<com.google.api.services.dataflow.model.LeaseWorkItemResponse> {

            private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/workItems:lease";

            /**
             * Leases a dataflow WorkItem to run.
             *
             * Create a request for the method "workItems.lease".
             *
             * This request holds the parameters needed by the the dataflow server.  After setting any
             * optional parameters, call the {@link Lease#execute()} method to invoke the remote operation.
             * <p> {@link
             * Lease#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Identifies the project this worker belongs to.
             * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the WorkItem's job.
             * @param jobId Identifies the workflow job this worker belongs to.
             * @param content the {@link com.google.api.services.dataflow.model.LeaseWorkItemRequest}
             * @since 1.13
             */
            protected Lease(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.LeaseWorkItemRequest content) {
              super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.LeaseWorkItemResponse.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
              this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
            }

            @Override
            public Lease set$Xgafv(java.lang.String $Xgafv) {
              return (Lease) super.set$Xgafv($Xgafv);
            }

            @Override
            public Lease setAccessToken(java.lang.String accessToken) {
              return (Lease) super.setAccessToken(accessToken);
            }

            @Override
            public Lease setAlt(java.lang.String alt) {
              return (Lease) super.setAlt(alt);
            }

            @Override
            public Lease setCallback(java.lang.String callback) {
              return (Lease) super.setCallback(callback);
            }

            @Override
            public Lease setFields(java.lang.String fields) {
              return (Lease) super.setFields(fields);
            }

            @Override
            public Lease setKey(java.lang.String key) {
              return (Lease) super.setKey(key);
            }

            @Override
            public Lease setOauthToken(java.lang.String oauthToken) {
              return (Lease) super.setOauthToken(oauthToken);
            }

            @Override
            public Lease setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Lease) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Lease setQuotaUser(java.lang.String quotaUser) {
              return (Lease) super.setQuotaUser(quotaUser);
            }

            @Override
            public Lease setUploadType(java.lang.String uploadType) {
              return (Lease) super.setUploadType(uploadType);
            }

            @Override
            public Lease setUploadProtocol(java.lang.String uploadProtocol) {
              return (Lease) super.setUploadProtocol(uploadProtocol);
            }

            /** Identifies the project this worker belongs to. */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Identifies the project this worker belongs to.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /** Identifies the project this worker belongs to. */
            public Lease setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the WorkItem's job.
             */
            @com.google.api.client.util.Key
            private java.lang.String location;

            /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           contains the WorkItem's job.
             */
            public java.lang.String getLocation() {
              return location;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the WorkItem's job.
             */
            public Lease setLocation(java.lang.String location) {
              this.location = location;
              return this;
            }

            /** Identifies the workflow job this worker belongs to. */
            @com.google.api.client.util.Key
            private java.lang.String jobId;

            /** Identifies the workflow job this worker belongs to.
             */
            public java.lang.String getJobId() {
              return jobId;
            }

            /** Identifies the workflow job this worker belongs to. */
            public Lease setJobId(java.lang.String jobId) {
              this.jobId = jobId;
              return this;
            }

            @Override
            public Lease set(String parameterName, Object value) {
              return (Lease) super.set(parameterName, value);
            }
          }
          /**
           * Reports the status of dataflow WorkItems leased by a worker.
           *
           * Create a request for the method "workItems.reportStatus".
           *
           * This request holds the parameters needed by the dataflow server.  After setting any optional
           * parameters, call the {@link ReportStatus#execute()} method to invoke the remote operation.
           *
           * @param projectId The project which owns the WorkItem's job.
           * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the WorkItem's job.
           * @param jobId The job which the WorkItem is part of.
           * @param content the {@link com.google.api.services.dataflow.model.ReportWorkItemStatusRequest}
           * @return the request
           */
          public ReportStatus reportStatus(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.ReportWorkItemStatusRequest content) throws java.io.IOException {
            ReportStatus result = new ReportStatus(projectId, location, jobId, content);
            initialize(result);
            return result;
          }

          public class ReportStatus extends DataflowRequest<com.google.api.services.dataflow.model.ReportWorkItemStatusResponse> {

            private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/workItems:reportStatus";

            /**
             * Reports the status of dataflow WorkItems leased by a worker.
             *
             * Create a request for the method "workItems.reportStatus".
             *
             * This request holds the parameters needed by the the dataflow server.  After setting any
             * optional parameters, call the {@link ReportStatus#execute()} method to invoke the remote
             * operation. <p> {@link
             * ReportStatus#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId The project which owns the WorkItem's job.
             * @param location The [regional endpoint]
          (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           *        contains the WorkItem's job.
             * @param jobId The job which the WorkItem is part of.
             * @param content the {@link com.google.api.services.dataflow.model.ReportWorkItemStatusRequest}
             * @since 1.13
             */
            protected ReportStatus(java.lang.String projectId, java.lang.String location, java.lang.String jobId, com.google.api.services.dataflow.model.ReportWorkItemStatusRequest content) {
              super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.ReportWorkItemStatusResponse.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
              this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
            }

            @Override
            public ReportStatus set$Xgafv(java.lang.String $Xgafv) {
              return (ReportStatus) super.set$Xgafv($Xgafv);
            }

            @Override
            public ReportStatus setAccessToken(java.lang.String accessToken) {
              return (ReportStatus) super.setAccessToken(accessToken);
            }

            @Override
            public ReportStatus setAlt(java.lang.String alt) {
              return (ReportStatus) super.setAlt(alt);
            }

            @Override
            public ReportStatus setCallback(java.lang.String callback) {
              return (ReportStatus) super.setCallback(callback);
            }

            @Override
            public ReportStatus setFields(java.lang.String fields) {
              return (ReportStatus) super.setFields(fields);
            }

            @Override
            public ReportStatus setKey(java.lang.String key) {
              return (ReportStatus) super.setKey(key);
            }

            @Override
            public ReportStatus setOauthToken(java.lang.String oauthToken) {
              return (ReportStatus) super.setOauthToken(oauthToken);
            }

            @Override
            public ReportStatus setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (ReportStatus) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public ReportStatus setQuotaUser(java.lang.String quotaUser) {
              return (ReportStatus) super.setQuotaUser(quotaUser);
            }

            @Override
            public ReportStatus setUploadType(java.lang.String uploadType) {
              return (ReportStatus) super.setUploadType(uploadType);
            }

            @Override
            public ReportStatus setUploadProtocol(java.lang.String uploadProtocol) {
              return (ReportStatus) super.setUploadProtocol(uploadProtocol);
            }

            /** The project which owns the WorkItem's job. */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** The project which owns the WorkItem's job.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /** The project which owns the WorkItem's job. */
            public ReportStatus setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the WorkItem's job.
             */
            @com.google.api.client.util.Key
            private java.lang.String location;

            /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
           contains the WorkItem's job.
             */
            public java.lang.String getLocation() {
              return location;
            }

            /**
             * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
             * endpoints) that contains the WorkItem's job.
             */
            public ReportStatus setLocation(java.lang.String location) {
              this.location = location;
              return this;
            }

            /** The job which the WorkItem is part of. */
            @com.google.api.client.util.Key
            private java.lang.String jobId;

            /** The job which the WorkItem is part of.
             */
            public java.lang.String getJobId() {
              return jobId;
            }

            /** The job which the WorkItem is part of. */
            public ReportStatus setJobId(java.lang.String jobId) {
              this.jobId = jobId;
              return this;
            }

            @Override
            public ReportStatus set(String parameterName, Object value) {
              return (ReportStatus) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Snapshots collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataflow dataflow = new Dataflow(...);}
       *   {@code Dataflow.Snapshots.List request = dataflow.snapshots().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Snapshots snapshots() {
        return new Snapshots();
      }

      /**
       * The "snapshots" collection of methods.
       */
      public class Snapshots {

        /**
         * Deletes a snapshot.
         *
         * Create a request for the method "snapshots.delete".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param projectId The ID of the Cloud Platform project that the snapshot belongs to.
         * @param location The location that contains this snapshot.
         * @param snapshotId The ID of the snapshot.
         * @return the request
         */
        public Delete delete(java.lang.String projectId, java.lang.String location, java.lang.String snapshotId) throws java.io.IOException {
          Delete result = new Delete(projectId, location, snapshotId);
          initialize(result);
          return result;
        }

        public class Delete extends DataflowRequest<com.google.api.services.dataflow.model.DeleteSnapshotResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/snapshots/{snapshotId}";

          /**
           * Deletes a snapshot.
           *
           * Create a request for the method "snapshots.delete".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The ID of the Cloud Platform project that the snapshot belongs to.
           * @param location The location that contains this snapshot.
           * @param snapshotId The ID of the snapshot.
           * @since 1.13
           */
          protected Delete(java.lang.String projectId, java.lang.String location, java.lang.String snapshotId) {
            super(Dataflow.this, "DELETE", REST_PATH, null, com.google.api.services.dataflow.model.DeleteSnapshotResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
            this.snapshotId = com.google.api.client.util.Preconditions.checkNotNull(snapshotId, "Required parameter snapshotId must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The ID of the Cloud Platform project that the snapshot belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The ID of the Cloud Platform project that the snapshot belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The ID of the Cloud Platform project that the snapshot belongs to. */
          public Delete setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** The location that contains this snapshot. */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The location that contains this snapshot.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /** The location that contains this snapshot. */
          public Delete setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** The ID of the snapshot. */
          @com.google.api.client.util.Key
          private java.lang.String snapshotId;

          /** The ID of the snapshot.
           */
          public java.lang.String getSnapshotId() {
            return snapshotId;
          }

          /** The ID of the snapshot. */
          public Delete setSnapshotId(java.lang.String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets information about a snapshot.
         *
         * Create a request for the method "snapshots.get".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param projectId The ID of the Cloud Platform project that the snapshot belongs to.
         * @param location The location that contains this snapshot.
         * @param snapshotId The ID of the snapshot.
         * @return the request
         */
        public Get get(java.lang.String projectId, java.lang.String location, java.lang.String snapshotId) throws java.io.IOException {
          Get result = new Get(projectId, location, snapshotId);
          initialize(result);
          return result;
        }

        public class Get extends DataflowRequest<com.google.api.services.dataflow.model.Snapshot> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/snapshots/{snapshotId}";

          /**
           * Gets information about a snapshot.
           *
           * Create a request for the method "snapshots.get".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The ID of the Cloud Platform project that the snapshot belongs to.
           * @param location The location that contains this snapshot.
           * @param snapshotId The ID of the snapshot.
           * @since 1.13
           */
          protected Get(java.lang.String projectId, java.lang.String location, java.lang.String snapshotId) {
            super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.Snapshot.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
            this.snapshotId = com.google.api.client.util.Preconditions.checkNotNull(snapshotId, "Required parameter snapshotId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The ID of the Cloud Platform project that the snapshot belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The ID of the Cloud Platform project that the snapshot belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The ID of the Cloud Platform project that the snapshot belongs to. */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** The location that contains this snapshot. */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The location that contains this snapshot.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /** The location that contains this snapshot. */
          public Get setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** The ID of the snapshot. */
          @com.google.api.client.util.Key
          private java.lang.String snapshotId;

          /** The ID of the snapshot.
           */
          public java.lang.String getSnapshotId() {
            return snapshotId;
          }

          /** The ID of the snapshot. */
          public Get setSnapshotId(java.lang.String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists snapshots.
         *
         * Create a request for the method "snapshots.list".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param projectId The project ID to list snapshots for.
         * @param location The location to list snapshots in.
         * @return the request
         */
        public List list(java.lang.String projectId, java.lang.String location) throws java.io.IOException {
          List result = new List(projectId, location);
          initialize(result);
          return result;
        }

        public class List extends DataflowRequest<com.google.api.services.dataflow.model.ListSnapshotsResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/snapshots";

          /**
           * Lists snapshots.
           *
           * Create a request for the method "snapshots.list".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId The project ID to list snapshots for.
           * @param location The location to list snapshots in.
           * @since 1.13
           */
          protected List(java.lang.String projectId, java.lang.String location) {
            super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ListSnapshotsResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The project ID to list snapshots for. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** The project ID to list snapshots for.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** The project ID to list snapshots for. */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** The location to list snapshots in. */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The location to list snapshots in.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /** The location to list snapshots in. */
          public List setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** If specified, list snapshots created from this job. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** If specified, list snapshots created from this job.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** If specified, list snapshots created from this job. */
          public List setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Sql collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataflow dataflow = new Dataflow(...);}
       *   {@code Dataflow.Sql.List request = dataflow.sql().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Sql sql() {
        return new Sql();
      }

      /**
       * The "sql" collection of methods.
       */
      public class Sql {

        /**
         * Validates a GoogleSQL query for Cloud Dataflow syntax. Will always confirm the given query parses
         * correctly, and if able to look up schema information from DataCatalog, will validate that the
         * query analyzes properly as well.
         *
         * Create a request for the method "sql.validate".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Validate#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         *        which to direct the request.
         * @return the request
         */
        public Validate validate(java.lang.String projectId, java.lang.String location) throws java.io.IOException {
          Validate result = new Validate(projectId, location);
          initialize(result);
          return result;
        }

        public class Validate extends DataflowRequest<com.google.api.services.dataflow.model.ValidateResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/sql:validate";

          /**
           * Validates a GoogleSQL query for Cloud Dataflow syntax. Will always confirm the given query
           * parses correctly, and if able to look up schema information from DataCatalog, will validate
           * that the query analyzes properly as well.
           *
           * Create a request for the method "sql.validate".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Validate#execute()} method to invoke the remote operation.
           * <p> {@link
           * Validate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         *        which to direct the request.
           * @since 1.13
           */
          protected Validate(java.lang.String projectId, java.lang.String location) {
            super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ValidateResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Validate set$Xgafv(java.lang.String $Xgafv) {
            return (Validate) super.set$Xgafv($Xgafv);
          }

          @Override
          public Validate setAccessToken(java.lang.String accessToken) {
            return (Validate) super.setAccessToken(accessToken);
          }

          @Override
          public Validate setAlt(java.lang.String alt) {
            return (Validate) super.setAlt(alt);
          }

          @Override
          public Validate setCallback(java.lang.String callback) {
            return (Validate) super.setCallback(callback);
          }

          @Override
          public Validate setFields(java.lang.String fields) {
            return (Validate) super.setFields(fields);
          }

          @Override
          public Validate setKey(java.lang.String key) {
            return (Validate) super.setKey(key);
          }

          @Override
          public Validate setOauthToken(java.lang.String oauthToken) {
            return (Validate) super.setOauthToken(oauthToken);
          }

          @Override
          public Validate setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Validate) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Validate setQuotaUser(java.lang.String quotaUser) {
            return (Validate) super.setQuotaUser(quotaUser);
          }

          @Override
          public Validate setUploadType(java.lang.String uploadType) {
            return (Validate) super.setUploadType(uploadType);
          }

          @Override
          public Validate setUploadProtocol(java.lang.String uploadProtocol) {
            return (Validate) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          public Validate setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) to which to direct the request.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         which to direct the request.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) to which to direct the request.
           */
          public Validate setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /** The sql query to validate. */
          @com.google.api.client.util.Key
          private java.lang.String query;

          /** The sql query to validate.
           */
          public java.lang.String getQuery() {
            return query;
          }

          /** The sql query to validate. */
          public Validate setQuery(java.lang.String query) {
            this.query = query;
            return this;
          }

          @Override
          public Validate set(String parameterName, Object value) {
            return (Validate) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Templates collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataflow dataflow = new Dataflow(...);}
       *   {@code Dataflow.Templates.List request = dataflow.templates().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Templates templates() {
        return new Templates();
      }

      /**
       * The "templates" collection of methods.
       */
      public class Templates {

        /**
         * Creates a Cloud Dataflow job from a template.
         *
         * Create a request for the method "templates.create".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         *        which to direct the request.
         * @param content the {@link com.google.api.services.dataflow.model.CreateJobFromTemplateRequest}
         * @return the request
         */
        public Create create(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.CreateJobFromTemplateRequest content) throws java.io.IOException {
          Create result = new Create(projectId, location, content);
          initialize(result);
          return result;
        }

        public class Create extends DataflowRequest<com.google.api.services.dataflow.model.Job> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/templates";

          /**
           * Creates a Cloud Dataflow job from a template.
           *
           * Create a request for the method "templates.create".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         *        which to direct the request.
           * @param content the {@link com.google.api.services.dataflow.model.CreateJobFromTemplateRequest}
           * @since 1.13
           */
          protected Create(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.CreateJobFromTemplateRequest content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.Job.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          public Create setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) to which to direct the request.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         which to direct the request.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) to which to direct the request.
           */
          public Create setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Get the template associated with a template.
         *
         * Create a request for the method "templates.get".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         *        which to direct the request.
         * @return the request
         */
        public Get get(java.lang.String projectId, java.lang.String location) throws java.io.IOException {
          Get result = new Get(projectId, location);
          initialize(result);
          return result;
        }

        public class Get extends DataflowRequest<com.google.api.services.dataflow.model.GetTemplateResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/templates:get";

          /**
           * Get the template associated with a template.
           *
           * Create a request for the method "templates.get".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         *        which to direct the request.
           * @since 1.13
           */
          protected Get(java.lang.String projectId, java.lang.String location) {
            super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.GetTemplateResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) to which to direct the request.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         which to direct the request.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) to which to direct the request.
           */
          public Get setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /**
           * Required. A Cloud Storage path to the template from which to create the job. Must be
           * valid Cloud Storage URL, beginning with 'gs://'.
           */
          @com.google.api.client.util.Key
          private java.lang.String gcsPath;

          /** Required. A Cloud Storage path to the template from which to create the job. Must be valid Cloud
         Storage URL, beginning with 'gs://'.
           */
          public java.lang.String getGcsPath() {
            return gcsPath;
          }

          /**
           * Required. A Cloud Storage path to the template from which to create the job. Must be
           * valid Cloud Storage URL, beginning with 'gs://'.
           */
          public Get setGcsPath(java.lang.String gcsPath) {
            this.gcsPath = gcsPath;
            return this;
          }

          /** The view to retrieve. Defaults to METADATA_ONLY. */
          @com.google.api.client.util.Key
          private java.lang.String view;

          /** The view to retrieve. Defaults to METADATA_ONLY.
           */
          public java.lang.String getView() {
            return view;
          }

          /** The view to retrieve. Defaults to METADATA_ONLY. */
          public Get setView(java.lang.String view) {
            this.view = view;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Launch a template.
         *
         * Create a request for the method "templates.launch".
         *
         * This request holds the parameters needed by the dataflow server.  After setting any optional
         * parameters, call the {@link Launch#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
         * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         *        which to direct the request.
         * @param content the {@link com.google.api.services.dataflow.model.LaunchTemplateParameters}
         * @return the request
         */
        public Launch launch(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.LaunchTemplateParameters content) throws java.io.IOException {
          Launch result = new Launch(projectId, location, content);
          initialize(result);
          return result;
        }

        public class Launch extends DataflowRequest<com.google.api.services.dataflow.model.LaunchTemplateResponse> {

          private static final String REST_PATH = "v1b3/projects/{projectId}/locations/{location}/templates:launch";

          /**
           * Launch a template.
           *
           * Create a request for the method "templates.launch".
           *
           * This request holds the parameters needed by the the dataflow server.  After setting any
           * optional parameters, call the {@link Launch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Launch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
           * @param location The [regional endpoint]
        (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         *        which to direct the request.
           * @param content the {@link com.google.api.services.dataflow.model.LaunchTemplateParameters}
           * @since 1.13
           */
          protected Launch(java.lang.String projectId, java.lang.String location, com.google.api.services.dataflow.model.LaunchTemplateParameters content) {
            super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.LaunchTemplateResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.location = com.google.api.client.util.Preconditions.checkNotNull(location, "Required parameter location must be specified.");
          }

          @Override
          public Launch set$Xgafv(java.lang.String $Xgafv) {
            return (Launch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Launch setAccessToken(java.lang.String accessToken) {
            return (Launch) super.setAccessToken(accessToken);
          }

          @Override
          public Launch setAlt(java.lang.String alt) {
            return (Launch) super.setAlt(alt);
          }

          @Override
          public Launch setCallback(java.lang.String callback) {
            return (Launch) super.setCallback(callback);
          }

          @Override
          public Launch setFields(java.lang.String fields) {
            return (Launch) super.setFields(fields);
          }

          @Override
          public Launch setKey(java.lang.String key) {
            return (Launch) super.setKey(key);
          }

          @Override
          public Launch setOauthToken(java.lang.String oauthToken) {
            return (Launch) super.setOauthToken(oauthToken);
          }

          @Override
          public Launch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Launch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Launch setQuotaUser(java.lang.String quotaUser) {
            return (Launch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Launch setUploadType(java.lang.String uploadType) {
            return (Launch) super.setUploadType(uploadType);
          }

          @Override
          public Launch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Launch) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Cloud Platform project that the job belongs to. */
          public Launch setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) to which to direct the request.
           */
          @com.google.api.client.util.Key
          private java.lang.String location;

          /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
         which to direct the request.
           */
          public java.lang.String getLocation() {
            return location;
          }

          /**
           * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
           * endpoints) to which to direct the request.
           */
          public Launch setLocation(java.lang.String location) {
            this.location = location;
            return this;
          }

          /**
           * Path to dynamic template spec file on GCS. The file must be a Json serialized
           * DynamicTemplateFieSpec object.
           */
          @com.google.api.client.util.Key("dynamicTemplate.gcsPath")
          private java.lang.String dynamicTemplateGcsPath;

          /** Path to dynamic template spec file on GCS. The file must be a Json serialized
         DynamicTemplateFieSpec object.
           */
          public java.lang.String getDynamicTemplateGcsPath() {
            return dynamicTemplateGcsPath;
          }

          /**
           * Path to dynamic template spec file on GCS. The file must be a Json serialized
           * DynamicTemplateFieSpec object.
           */
          public Launch setDynamicTemplateGcsPath(java.lang.String dynamicTemplateGcsPath) {
            this.dynamicTemplateGcsPath = dynamicTemplateGcsPath;
            return this;
          }

          /**
           * Cloud Storage path for staging dependencies. Must be a valid Cloud Storage URL,
           * beginning with `gs://`.
           */
          @com.google.api.client.util.Key("dynamicTemplate.stagingLocation")
          private java.lang.String dynamicTemplateStagingLocation;

          /** Cloud Storage path for staging dependencies. Must be a valid Cloud Storage URL, beginning with
         `gs://`.
           */
          public java.lang.String getDynamicTemplateStagingLocation() {
            return dynamicTemplateStagingLocation;
          }

          /**
           * Cloud Storage path for staging dependencies. Must be a valid Cloud Storage URL,
           * beginning with `gs://`.
           */
          public Launch setDynamicTemplateStagingLocation(java.lang.String dynamicTemplateStagingLocation) {
            this.dynamicTemplateStagingLocation = dynamicTemplateStagingLocation;
            return this;
          }

          /**
           * A Cloud Storage path to the template from which to create the job. Must be valid Cloud
           * Storage URL, beginning with 'gs://'.
           */
          @com.google.api.client.util.Key
          private java.lang.String gcsPath;

          /** A Cloud Storage path to the template from which to create the job. Must be valid Cloud Storage URL,
         beginning with 'gs://'.
           */
          public java.lang.String getGcsPath() {
            return gcsPath;
          }

          /**
           * A Cloud Storage path to the template from which to create the job. Must be valid Cloud
           * Storage URL, beginning with 'gs://'.
           */
          public Launch setGcsPath(java.lang.String gcsPath) {
            this.gcsPath = gcsPath;
            return this;
          }

          /**
           * If true, the request is validated but not actually executed. Defaults to false.
           */
          @com.google.api.client.util.Key
          private java.lang.Boolean validateOnly;

          /** If true, the request is validated but not actually executed. Defaults to false.
           */
          public java.lang.Boolean getValidateOnly() {
            return validateOnly;
          }

          /**
           * If true, the request is validated but not actually executed. Defaults to false.
           */
          public Launch setValidateOnly(java.lang.Boolean validateOnly) {
            this.validateOnly = validateOnly;
            return this;
          }

          @Override
          public Launch set(String parameterName, Object value) {
            return (Launch) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the Snapshots collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Dataflow dataflow = new Dataflow(...);}
     *   {@code Dataflow.Snapshots.List request = dataflow.snapshots().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Snapshots snapshots() {
      return new Snapshots();
    }

    /**
     * The "snapshots" collection of methods.
     */
    public class Snapshots {

      /**
       * Gets information about a snapshot.
       *
       * Create a request for the method "snapshots.get".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param projectId The ID of the Cloud Platform project that the snapshot belongs to.
       * @param snapshotId The ID of the snapshot.
       * @return the request
       */
      public Get get(java.lang.String projectId, java.lang.String snapshotId) throws java.io.IOException {
        Get result = new Get(projectId, snapshotId);
        initialize(result);
        return result;
      }

      public class Get extends DataflowRequest<com.google.api.services.dataflow.model.Snapshot> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/snapshots/{snapshotId}";

        /**
         * Gets information about a snapshot.
         *
         * Create a request for the method "snapshots.get".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId The ID of the Cloud Platform project that the snapshot belongs to.
         * @param snapshotId The ID of the snapshot.
         * @since 1.13
         */
        protected Get(java.lang.String projectId, java.lang.String snapshotId) {
          super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.Snapshot.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.snapshotId = com.google.api.client.util.Preconditions.checkNotNull(snapshotId, "Required parameter snapshotId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the Cloud Platform project that the snapshot belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The ID of the Cloud Platform project that the snapshot belongs to.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The ID of the Cloud Platform project that the snapshot belongs to. */
        public Get setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** The ID of the snapshot. */
        @com.google.api.client.util.Key
        private java.lang.String snapshotId;

        /** The ID of the snapshot.
         */
        public java.lang.String getSnapshotId() {
          return snapshotId;
        }

        /** The ID of the snapshot. */
        public Get setSnapshotId(java.lang.String snapshotId) {
          this.snapshotId = snapshotId;
          return this;
        }

        /** The location that contains this snapshot. */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The location that contains this snapshot.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /** The location that contains this snapshot. */
        public Get setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists snapshots.
       *
       * Create a request for the method "snapshots.list".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param projectId The project ID to list snapshots for.
       * @return the request
       */
      public List list(java.lang.String projectId) throws java.io.IOException {
        List result = new List(projectId);
        initialize(result);
        return result;
      }

      public class List extends DataflowRequest<com.google.api.services.dataflow.model.ListSnapshotsResponse> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/snapshots";

        /**
         * Lists snapshots.
         *
         * Create a request for the method "snapshots.list".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId The project ID to list snapshots for.
         * @since 1.13
         */
        protected List(java.lang.String projectId) {
          super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.ListSnapshotsResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The project ID to list snapshots for. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** The project ID to list snapshots for.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** The project ID to list snapshots for. */
        public List setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** If specified, list snapshots created from this job. */
        @com.google.api.client.util.Key
        private java.lang.String jobId;

        /** If specified, list snapshots created from this job.
         */
        public java.lang.String getJobId() {
          return jobId;
        }

        /** If specified, list snapshots created from this job. */
        public List setJobId(java.lang.String jobId) {
          this.jobId = jobId;
          return this;
        }

        /** The location to list snapshots in. */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The location to list snapshots in.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /** The location to list snapshots in. */
        public List setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Templates collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Dataflow dataflow = new Dataflow(...);}
     *   {@code Dataflow.Templates.List request = dataflow.templates().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Templates templates() {
      return new Templates();
    }

    /**
     * The "templates" collection of methods.
     */
    public class Templates {

      /**
       * Creates a Cloud Dataflow job from a template.
       *
       * Create a request for the method "templates.create".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
       * @param content the {@link com.google.api.services.dataflow.model.CreateJobFromTemplateRequest}
       * @return the request
       */
      public Create create(java.lang.String projectId, com.google.api.services.dataflow.model.CreateJobFromTemplateRequest content) throws java.io.IOException {
        Create result = new Create(projectId, content);
        initialize(result);
        return result;
      }

      public class Create extends DataflowRequest<com.google.api.services.dataflow.model.Job> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/templates";

        /**
         * Creates a Cloud Dataflow job from a template.
         *
         * Create a request for the method "templates.create".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
         * @param content the {@link com.google.api.services.dataflow.model.CreateJobFromTemplateRequest}
         * @since 1.13
         */
        protected Create(java.lang.String projectId, com.google.api.services.dataflow.model.CreateJobFromTemplateRequest content) {
          super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.Job.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The ID of the Cloud Platform project that the job belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** Required. The ID of the Cloud Platform project that the job belongs to.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** Required. The ID of the Cloud Platform project that the job belongs to. */
        public Create setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Get the template associated with a template.
       *
       * Create a request for the method "templates.get".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
       * @return the request
       */
      public Get get(java.lang.String projectId) throws java.io.IOException {
        Get result = new Get(projectId);
        initialize(result);
        return result;
      }

      public class Get extends DataflowRequest<com.google.api.services.dataflow.model.GetTemplateResponse> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/templates:get";

        /**
         * Get the template associated with a template.
         *
         * Create a request for the method "templates.get".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
         * @since 1.13
         */
        protected Get(java.lang.String projectId) {
          super(Dataflow.this, "GET", REST_PATH, null, com.google.api.services.dataflow.model.GetTemplateResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The ID of the Cloud Platform project that the job belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** Required. The ID of the Cloud Platform project that the job belongs to.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** Required. The ID of the Cloud Platform project that the job belongs to. */
        public Get setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /**
         * Required. A Cloud Storage path to the template from which to create the job. Must be
         * valid Cloud Storage URL, beginning with 'gs://'.
         */
        @com.google.api.client.util.Key
        private java.lang.String gcsPath;

        /** Required. A Cloud Storage path to the template from which to create the job. Must be valid Cloud
       Storage URL, beginning with 'gs://'.
         */
        public java.lang.String getGcsPath() {
          return gcsPath;
        }

        /**
         * Required. A Cloud Storage path to the template from which to create the job. Must be
         * valid Cloud Storage URL, beginning with 'gs://'.
         */
        public Get setGcsPath(java.lang.String gcsPath) {
          this.gcsPath = gcsPath;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) to which to direct the request.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
       which to direct the request.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) to which to direct the request.
         */
        public Get setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        /** The view to retrieve. Defaults to METADATA_ONLY. */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** The view to retrieve. Defaults to METADATA_ONLY.
         */
        public java.lang.String getView() {
          return view;
        }

        /** The view to retrieve. Defaults to METADATA_ONLY. */
        public Get setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Launch a template.
       *
       * Create a request for the method "templates.launch".
       *
       * This request holds the parameters needed by the dataflow server.  After setting any optional
       * parameters, call the {@link Launch#execute()} method to invoke the remote operation.
       *
       * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
       * @param content the {@link com.google.api.services.dataflow.model.LaunchTemplateParameters}
       * @return the request
       */
      public Launch launch(java.lang.String projectId, com.google.api.services.dataflow.model.LaunchTemplateParameters content) throws java.io.IOException {
        Launch result = new Launch(projectId, content);
        initialize(result);
        return result;
      }

      public class Launch extends DataflowRequest<com.google.api.services.dataflow.model.LaunchTemplateResponse> {

        private static final String REST_PATH = "v1b3/projects/{projectId}/templates:launch";

        /**
         * Launch a template.
         *
         * Create a request for the method "templates.launch".
         *
         * This request holds the parameters needed by the the dataflow server.  After setting any
         * optional parameters, call the {@link Launch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Launch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId Required. The ID of the Cloud Platform project that the job belongs to.
         * @param content the {@link com.google.api.services.dataflow.model.LaunchTemplateParameters}
         * @since 1.13
         */
        protected Launch(java.lang.String projectId, com.google.api.services.dataflow.model.LaunchTemplateParameters content) {
          super(Dataflow.this, "POST", REST_PATH, content, com.google.api.services.dataflow.model.LaunchTemplateResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public Launch set$Xgafv(java.lang.String $Xgafv) {
          return (Launch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Launch setAccessToken(java.lang.String accessToken) {
          return (Launch) super.setAccessToken(accessToken);
        }

        @Override
        public Launch setAlt(java.lang.String alt) {
          return (Launch) super.setAlt(alt);
        }

        @Override
        public Launch setCallback(java.lang.String callback) {
          return (Launch) super.setCallback(callback);
        }

        @Override
        public Launch setFields(java.lang.String fields) {
          return (Launch) super.setFields(fields);
        }

        @Override
        public Launch setKey(java.lang.String key) {
          return (Launch) super.setKey(key);
        }

        @Override
        public Launch setOauthToken(java.lang.String oauthToken) {
          return (Launch) super.setOauthToken(oauthToken);
        }

        @Override
        public Launch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Launch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Launch setQuotaUser(java.lang.String quotaUser) {
          return (Launch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Launch setUploadType(java.lang.String uploadType) {
          return (Launch) super.setUploadType(uploadType);
        }

        @Override
        public Launch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Launch) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The ID of the Cloud Platform project that the job belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** Required. The ID of the Cloud Platform project that the job belongs to.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** Required. The ID of the Cloud Platform project that the job belongs to. */
        public Launch setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /**
         * Path to dynamic template spec file on GCS. The file must be a Json serialized
         * DynamicTemplateFieSpec object.
         */
        @com.google.api.client.util.Key("dynamicTemplate.gcsPath")
        private java.lang.String dynamicTemplateGcsPath;

        /** Path to dynamic template spec file on GCS. The file must be a Json serialized
       DynamicTemplateFieSpec object.
         */
        public java.lang.String getDynamicTemplateGcsPath() {
          return dynamicTemplateGcsPath;
        }

        /**
         * Path to dynamic template spec file on GCS. The file must be a Json serialized
         * DynamicTemplateFieSpec object.
         */
        public Launch setDynamicTemplateGcsPath(java.lang.String dynamicTemplateGcsPath) {
          this.dynamicTemplateGcsPath = dynamicTemplateGcsPath;
          return this;
        }

        /**
         * Cloud Storage path for staging dependencies. Must be a valid Cloud Storage URL, beginning
         * with `gs://`.
         */
        @com.google.api.client.util.Key("dynamicTemplate.stagingLocation")
        private java.lang.String dynamicTemplateStagingLocation;

        /** Cloud Storage path for staging dependencies. Must be a valid Cloud Storage URL, beginning with
       `gs://`.
         */
        public java.lang.String getDynamicTemplateStagingLocation() {
          return dynamicTemplateStagingLocation;
        }

        /**
         * Cloud Storage path for staging dependencies. Must be a valid Cloud Storage URL, beginning
         * with `gs://`.
         */
        public Launch setDynamicTemplateStagingLocation(java.lang.String dynamicTemplateStagingLocation) {
          this.dynamicTemplateStagingLocation = dynamicTemplateStagingLocation;
          return this;
        }

        /**
         * A Cloud Storage path to the template from which to create the job. Must be valid Cloud
         * Storage URL, beginning with 'gs://'.
         */
        @com.google.api.client.util.Key
        private java.lang.String gcsPath;

        /** A Cloud Storage path to the template from which to create the job. Must be valid Cloud Storage URL,
       beginning with 'gs://'.
         */
        public java.lang.String getGcsPath() {
          return gcsPath;
        }

        /**
         * A Cloud Storage path to the template from which to create the job. Must be valid Cloud
         * Storage URL, beginning with 'gs://'.
         */
        public Launch setGcsPath(java.lang.String gcsPath) {
          this.gcsPath = gcsPath;
          return this;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) to which to direct the request.
         */
        @com.google.api.client.util.Key
        private java.lang.String location;

        /** The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
       which to direct the request.
         */
        public java.lang.String getLocation() {
          return location;
        }

        /**
         * The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-
         * endpoints) to which to direct the request.
         */
        public Launch setLocation(java.lang.String location) {
          this.location = location;
          return this;
        }

        /**
         * If true, the request is validated but not actually executed. Defaults to false.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean validateOnly;

        /** If true, the request is validated but not actually executed. Defaults to false.
         */
        public java.lang.Boolean getValidateOnly() {
          return validateOnly;
        }

        /**
         * If true, the request is validated but not actually executed. Defaults to false.
         */
        public Launch setValidateOnly(java.lang.Boolean validateOnly) {
          this.validateOnly = validateOnly;
          return this;
        }

        @Override
        public Launch set(String parameterName, Object value) {
          return (Launch) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Dataflow}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Dataflow}. */
    @Override
    public Dataflow build() {
      return new Dataflow(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DataflowRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDataflowRequestInitializer(
        DataflowRequestInitializer dataflowRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(dataflowRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
