/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A shielded Instance identity entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShieldedInstanceIdentity extends com.google.api.client.json.GenericJson {

  /**
   * An Endorsement Key (EK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ShieldedInstanceIdentityEntry encryptionKey;

  /**
   * [Output Only] Type of the resource. Always compute#shieldedInstanceIdentity for shielded
   * Instance identity entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * An Attestation Key (AK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ShieldedInstanceIdentityEntry signingKey;

  /**
   * An Endorsement Key (EK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.
   * @return value or {@code null} for none
   */
  public ShieldedInstanceIdentityEntry getEncryptionKey() {
    return encryptionKey;
  }

  /**
   * An Endorsement Key (EK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.
   * @param encryptionKey encryptionKey or {@code null} for none
   */
  public ShieldedInstanceIdentity setEncryptionKey(ShieldedInstanceIdentityEntry encryptionKey) {
    this.encryptionKey = encryptionKey;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#shieldedInstanceIdentity for shielded
   * Instance identity entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#shieldedInstanceIdentity for shielded
   * Instance identity entry.
   * @param kind kind or {@code null} for none
   */
  public ShieldedInstanceIdentity setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * An Attestation Key (AK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.
   * @return value or {@code null} for none
   */
  public ShieldedInstanceIdentityEntry getSigningKey() {
    return signingKey;
  }

  /**
   * An Attestation Key (AK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.
   * @param signingKey signingKey or {@code null} for none
   */
  public ShieldedInstanceIdentity setSigningKey(ShieldedInstanceIdentityEntry signingKey) {
    this.signingKey = signingKey;
    return this;
  }

  @Override
  public ShieldedInstanceIdentity set(String fieldName, Object value) {
    return (ShieldedInstanceIdentity) super.set(fieldName, value);
  }

  @Override
  public ShieldedInstanceIdentity clone() {
    return (ShieldedInstanceIdentity) super.clone();
  }

}
