/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SchedulingNodeAffinity extends com.google.api.client.json.GenericJson {

  /**
   * Corresponds to the label key of Node resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for
   * anti-affinity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operator;

  /**
   * Corresponds to the label values of Node resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> values;

  /**
   * Corresponds to the label key of Node resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * Corresponds to the label key of Node resource.
   * @param key key or {@code null} for none
   */
  public SchedulingNodeAffinity setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for
   * anti-affinity.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperator() {
    return operator;
  }

  /**
   * Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for
   * anti-affinity.
   * @param operator operator or {@code null} for none
   */
  public SchedulingNodeAffinity setOperator(java.lang.String operator) {
    this.operator = operator;
    return this;
  }

  /**
   * Corresponds to the label values of Node resource.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getValues() {
    return values;
  }

  /**
   * Corresponds to the label values of Node resource.
   * @param values values or {@code null} for none
   */
  public SchedulingNodeAffinity setValues(java.util.List<java.lang.String> values) {
    this.values = values;
    return this;
  }

  @Override
  public SchedulingNodeAffinity set(String fieldName, Object value) {
    return (SchedulingNodeAffinity) super.set(fieldName, value);
  }

  @Override
  public SchedulingNodeAffinity clone() {
    return (SchedulingNodeAffinity) super.clone();
  }

}
