/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Specification determining how headers are added to requests or responses.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpHeaderOption extends com.google.api.client.json.GenericJson {

  /**
   * The name of the header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String headerName;

  /**
   * The value of the header to add.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String headerValue;

  /**
   * If false, headerValue is appended to any values that already exist for the header. If true,
   * headerValue is set for the header, discarding any values that were set for that header. The
   * default value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean replace;

  /**
   * The name of the header.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeaderName() {
    return headerName;
  }

  /**
   * The name of the header.
   * @param headerName headerName or {@code null} for none
   */
  public HttpHeaderOption setHeaderName(java.lang.String headerName) {
    this.headerName = headerName;
    return this;
  }

  /**
   * The value of the header to add.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeaderValue() {
    return headerValue;
  }

  /**
   * The value of the header to add.
   * @param headerValue headerValue or {@code null} for none
   */
  public HttpHeaderOption setHeaderValue(java.lang.String headerValue) {
    this.headerValue = headerValue;
    return this;
  }

  /**
   * If false, headerValue is appended to any values that already exist for the header. If true,
   * headerValue is set for the header, discarding any values that were set for that header. The
   * default value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getReplace() {
    return replace;
  }

  /**
   * If false, headerValue is appended to any values that already exist for the header. If true,
   * headerValue is set for the header, discarding any values that were set for that header. The
   * default value is false.
   * @param replace replace or {@code null} for none
   */
  public HttpHeaderOption setReplace(java.lang.Boolean replace) {
    this.replace = replace;
    return this;
  }

  @Override
  public HttpHeaderOption set(String fieldName, Object value) {
    return (HttpHeaderOption) super.set(fieldName, value);
  }

  @Override
  public HttpHeaderOption clone() {
    return (HttpHeaderOption) super.clone();
  }

}
