/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A guest attributes namespace/key/value entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GuestAttributesEntry extends com.google.api.client.json.GenericJson {

  /**
   * Key for the guest attribute entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * Namespace for the guest attribute entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String namespace;

  /**
   * Value for the guest attribute entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * Key for the guest attribute entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * Key for the guest attribute entry.
   * @param key key or {@code null} for none
   */
  public GuestAttributesEntry setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * Namespace for the guest attribute entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getNamespace() {
    return namespace;
  }

  /**
   * Namespace for the guest attribute entry.
   * @param namespace namespace or {@code null} for none
   */
  public GuestAttributesEntry setNamespace(java.lang.String namespace) {
    this.namespace = namespace;
    return this;
  }

  /**
   * Value for the guest attribute entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * Value for the guest attribute entry.
   * @param value value or {@code null} for none
   */
  public GuestAttributesEntry setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public GuestAttributesEntry set(String fieldName, Object value) {
    return (GuestAttributesEntry) super.set(fieldName, value);
  }

  @Override
  public GuestAttributesEntry clone() {
    return (GuestAttributesEntry) super.clone();
  }

}
