/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Message containing information of one individual backend.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Backend extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the balancing mode for the backend.
   *
   * When choosing a balancing mode, you need to consider the loadBalancingScheme, and protocol for
   * the backend service, as well as the type of backend (instance group or NEG).
   *
   *   - If the load balancing mode is CONNECTION, then the load is spread based on how many
   * concurrent connections the backend can handle. You can use the CONNECTION balancing mode if the
   * protocol for the backend service is SSL, TCP, or UDP.
   *
   * If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and TCP Proxy load
   * balancers), you must also specify exactly one of the following parameters: maxConnections,
   * maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
   *
   * If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/UDP load
   * balancers), you cannot specify any additional parameters.   - If the load balancing mode is
   * RATE, the load is spread based on the rate of HTTP requests per second (RPS). You can use the
   * RATE balancing mode if the protocol for the backend service is HTTP or HTTPS. You must specify
   * exactly one of the following parameters: maxRate, maxRatePerInstance, or maxRatePerEndpoint.
   * - If the load balancing mode is UTILIZATION, the load is spread based on the CPU utilization of
   * instances in an instance group. You can use the UTILIZATION balancing mode if the
   * loadBalancingScheme of the backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or
   * INTERNAL_MANAGED and the backends are instance groups. There are no restrictions on the backend
   * service protocol.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String balancingMode;

  /**
   * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or
   * CONNECTION). Default value is 1, which means the group will serve up to 100% of its configured
   * capacity (depending on balancingMode). A setting of 0 means the group is completely drained,
   * offering 0% of its available Capacity. Valid range is [0.0,1.0].
   *
   * This cannot be used for internal load balancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float capacityScaler;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type
   * of backend that a backend service supports depends on the backend service's
   * loadBalancingScheme.
   *
   *   - When the loadBalancingScheme for the backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or
   * INTERNAL_MANAGED, the backend can be either an instance group or a NEG. The backends on the
   * backend service must be either all instance groups or all NEGs. You cannot mix instance group
   * and NEG backends on the same backend service.
   *
   * - When the loadBalancingScheme for the backend service is INTERNAL, the backend must be an
   * instance group in the same region as the backend service. NEGs are not supported.
   *
   * You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the
   * instance group or NEG. Partial URLs are not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String group;

  /**
   * Defines a maximum target for simultaneous connections for the entire backend (instance group or
   * NEG). If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the
   * backend's balancingMode is CONNECTION, and backend is attached to a backend service whose
   * loadBalancingScheme is EXTERNAL, you must specify either this parameter,
   * maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
   *
   * Not available if the backend's balancingMode is RATE. If the loadBalancingScheme is INTERNAL,
   * then maxConnections is not supported, even though the backend requires a balancing mode of
   * CONNECTION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxConnections;

  /**
   * Defines a maximum target for simultaneous connections for an endpoint of a NEG. This is
   * multiplied by the number of endpoints in the NEG to implicitly calculate a maximum number of
   * target maximum simultaneous connections for the NEG. If the backend's balancingMode is
   * CONNECTION, and the backend is attached to a backend service whose loadBalancingScheme is
   * EXTERNAL, you must specify either this parameter, maxConnections, or maxConnectionsPerInstance.
   *
   * Not available if the backend's balancingMode is RATE. Internal TCP/UDP load balancing does not
   * support setting maxConnectionsPerEndpoint even though its backends require a balancing mode of
   * CONNECTION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxConnectionsPerEndpoint;

  /**
   * Defines a maximum target for simultaneous connections for a single VM in a backend instance
   * group. This is multiplied by the number of instances in the instance group to implicitly
   * calculate a target maximum number of simultaneous connections for the whole instance group. If
   * the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's
   * balancingMode is CONNECTION, and backend is attached to a backend service whose
   * loadBalancingScheme is EXTERNAL, you must specify either this parameter, maxConnections, or
   * maxConnectionsPerEndpoint.
   *
   * Not available if the backend's balancingMode is RATE. Internal TCP/UDP load balancing does not
   * support setting maxConnectionsPerInstance even though its backends require a balancing mode of
   * CONNECTION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxConnectionsPerInstance;

  /**
   * The max requests per second (RPS) of the group. Can be used with either RATE or UTILIZATION
   * balancing modes, but required if RATE mode. For RATE mode, either maxRate or maxRatePerInstance
   * must be set.
   *
   * This cannot be used for internal load balancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRate;

  /**
   * Defines a maximum target for requests per second (RPS) for an endpoint of a NEG. This is
   * multiplied by the number of endpoints in the NEG to implicitly calculate a target maximum rate
   * for the NEG.
   *
   * If the backend's balancingMode is RATE, you must specify either this parameter, maxRate, or
   * maxRatePerInstance.
   *
   * Not available if the backend's balancingMode is CONNECTION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxRatePerEndpoint;

  /**
   * Defines a maximum target for requests per second (RPS) for a single VM in a backend instance
   * group. This is multiplied by the number of instances in the instance group to implicitly
   * calculate a target maximum rate for the whole instance group.
   *
   * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's
   * balancingMode is RATE, you must specify either this parameter, maxRate, or maxRatePerEndpoint.
   *
   * Not available if the backend's balancingMode is CONNECTION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxRatePerInstance;

  /**
   * Defines the maximum average CPU utilization of a backend VM in an instance group. The valid
   * range is [0.0, 1.0]. This is an optional parameter if the backend's balancingMode is
   * UTILIZATION.
   *
   * This parameter can be used in conjunction with maxRate, maxRatePerInstance, maxConnections, or
   * maxConnectionsPerInstance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxUtilization;

  /**
   * Specifies the balancing mode for the backend.
   *
   * When choosing a balancing mode, you need to consider the loadBalancingScheme, and protocol for
   * the backend service, as well as the type of backend (instance group or NEG).
   *
   *   - If the load balancing mode is CONNECTION, then the load is spread based on how many
   * concurrent connections the backend can handle. You can use the CONNECTION balancing mode if the
   * protocol for the backend service is SSL, TCP, or UDP.
   *
   * If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and TCP Proxy load
   * balancers), you must also specify exactly one of the following parameters: maxConnections,
   * maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
   *
   * If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/UDP load
   * balancers), you cannot specify any additional parameters.   - If the load balancing mode is
   * RATE, the load is spread based on the rate of HTTP requests per second (RPS). You can use the
   * RATE balancing mode if the protocol for the backend service is HTTP or HTTPS. You must specify
   * exactly one of the following parameters: maxRate, maxRatePerInstance, or maxRatePerEndpoint.
   * - If the load balancing mode is UTILIZATION, the load is spread based on the CPU utilization of
   * instances in an instance group. You can use the UTILIZATION balancing mode if the
   * loadBalancingScheme of the backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or
   * INTERNAL_MANAGED and the backends are instance groups. There are no restrictions on the backend
   * service protocol.
   * @return value or {@code null} for none
   */
  public java.lang.String getBalancingMode() {
    return balancingMode;
  }

  /**
   * Specifies the balancing mode for the backend.
   *
   * When choosing a balancing mode, you need to consider the loadBalancingScheme, and protocol for
   * the backend service, as well as the type of backend (instance group or NEG).
   *
   *   - If the load balancing mode is CONNECTION, then the load is spread based on how many
   * concurrent connections the backend can handle. You can use the CONNECTION balancing mode if the
   * protocol for the backend service is SSL, TCP, or UDP.
   *
   * If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and TCP Proxy load
   * balancers), you must also specify exactly one of the following parameters: maxConnections,
   * maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
   *
   * If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/UDP load
   * balancers), you cannot specify any additional parameters.   - If the load balancing mode is
   * RATE, the load is spread based on the rate of HTTP requests per second (RPS). You can use the
   * RATE balancing mode if the protocol for the backend service is HTTP or HTTPS. You must specify
   * exactly one of the following parameters: maxRate, maxRatePerInstance, or maxRatePerEndpoint.
   * - If the load balancing mode is UTILIZATION, the load is spread based on the CPU utilization of
   * instances in an instance group. You can use the UTILIZATION balancing mode if the
   * loadBalancingScheme of the backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or
   * INTERNAL_MANAGED and the backends are instance groups. There are no restrictions on the backend
   * service protocol.
   * @param balancingMode balancingMode or {@code null} for none
   */
  public Backend setBalancingMode(java.lang.String balancingMode) {
    this.balancingMode = balancingMode;
    return this;
  }

  /**
   * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or
   * CONNECTION). Default value is 1, which means the group will serve up to 100% of its configured
   * capacity (depending on balancingMode). A setting of 0 means the group is completely drained,
   * offering 0% of its available Capacity. Valid range is [0.0,1.0].
   *
   * This cannot be used for internal load balancing.
   * @return value or {@code null} for none
   */
  public java.lang.Float getCapacityScaler() {
    return capacityScaler;
  }

  /**
   * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or
   * CONNECTION). Default value is 1, which means the group will serve up to 100% of its configured
   * capacity (depending on balancingMode). A setting of 0 means the group is completely drained,
   * offering 0% of its available Capacity. Valid range is [0.0,1.0].
   *
   * This cannot be used for internal load balancing.
   * @param capacityScaler capacityScaler or {@code null} for none
   */
  public Backend setCapacityScaler(java.lang.Float capacityScaler) {
    this.capacityScaler = capacityScaler;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public Backend setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type
   * of backend that a backend service supports depends on the backend service's
   * loadBalancingScheme.
   *
   *   - When the loadBalancingScheme for the backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or
   * INTERNAL_MANAGED, the backend can be either an instance group or a NEG. The backends on the
   * backend service must be either all instance groups or all NEGs. You cannot mix instance group
   * and NEG backends on the same backend service.
   *
   * - When the loadBalancingScheme for the backend service is INTERNAL, the backend must be an
   * instance group in the same region as the backend service. NEGs are not supported.
   *
   * You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the
   * instance group or NEG. Partial URLs are not supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroup() {
    return group;
  }

  /**
   * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type
   * of backend that a backend service supports depends on the backend service's
   * loadBalancingScheme.
   *
   *   - When the loadBalancingScheme for the backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or
   * INTERNAL_MANAGED, the backend can be either an instance group or a NEG. The backends on the
   * backend service must be either all instance groups or all NEGs. You cannot mix instance group
   * and NEG backends on the same backend service.
   *
   * - When the loadBalancingScheme for the backend service is INTERNAL, the backend must be an
   * instance group in the same region as the backend service. NEGs are not supported.
   *
   * You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the
   * instance group or NEG. Partial URLs are not supported.
   * @param group group or {@code null} for none
   */
  public Backend setGroup(java.lang.String group) {
    this.group = group;
    return this;
  }

  /**
   * Defines a maximum target for simultaneous connections for the entire backend (instance group or
   * NEG). If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the
   * backend's balancingMode is CONNECTION, and backend is attached to a backend service whose
   * loadBalancingScheme is EXTERNAL, you must specify either this parameter,
   * maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
   *
   * Not available if the backend's balancingMode is RATE. If the loadBalancingScheme is INTERNAL,
   * then maxConnections is not supported, even though the backend requires a balancing mode of
   * CONNECTION.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxConnections() {
    return maxConnections;
  }

  /**
   * Defines a maximum target for simultaneous connections for the entire backend (instance group or
   * NEG). If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the
   * backend's balancingMode is CONNECTION, and backend is attached to a backend service whose
   * loadBalancingScheme is EXTERNAL, you must specify either this parameter,
   * maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
   *
   * Not available if the backend's balancingMode is RATE. If the loadBalancingScheme is INTERNAL,
   * then maxConnections is not supported, even though the backend requires a balancing mode of
   * CONNECTION.
   * @param maxConnections maxConnections or {@code null} for none
   */
  public Backend setMaxConnections(java.lang.Integer maxConnections) {
    this.maxConnections = maxConnections;
    return this;
  }

  /**
   * Defines a maximum target for simultaneous connections for an endpoint of a NEG. This is
   * multiplied by the number of endpoints in the NEG to implicitly calculate a maximum number of
   * target maximum simultaneous connections for the NEG. If the backend's balancingMode is
   * CONNECTION, and the backend is attached to a backend service whose loadBalancingScheme is
   * EXTERNAL, you must specify either this parameter, maxConnections, or maxConnectionsPerInstance.
   *
   * Not available if the backend's balancingMode is RATE. Internal TCP/UDP load balancing does not
   * support setting maxConnectionsPerEndpoint even though its backends require a balancing mode of
   * CONNECTION.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxConnectionsPerEndpoint() {
    return maxConnectionsPerEndpoint;
  }

  /**
   * Defines a maximum target for simultaneous connections for an endpoint of a NEG. This is
   * multiplied by the number of endpoints in the NEG to implicitly calculate a maximum number of
   * target maximum simultaneous connections for the NEG. If the backend's balancingMode is
   * CONNECTION, and the backend is attached to a backend service whose loadBalancingScheme is
   * EXTERNAL, you must specify either this parameter, maxConnections, or maxConnectionsPerInstance.
   *
   * Not available if the backend's balancingMode is RATE. Internal TCP/UDP load balancing does not
   * support setting maxConnectionsPerEndpoint even though its backends require a balancing mode of
   * CONNECTION.
   * @param maxConnectionsPerEndpoint maxConnectionsPerEndpoint or {@code null} for none
   */
  public Backend setMaxConnectionsPerEndpoint(java.lang.Integer maxConnectionsPerEndpoint) {
    this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
    return this;
  }

  /**
   * Defines a maximum target for simultaneous connections for a single VM in a backend instance
   * group. This is multiplied by the number of instances in the instance group to implicitly
   * calculate a target maximum number of simultaneous connections for the whole instance group. If
   * the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's
   * balancingMode is CONNECTION, and backend is attached to a backend service whose
   * loadBalancingScheme is EXTERNAL, you must specify either this parameter, maxConnections, or
   * maxConnectionsPerEndpoint.
   *
   * Not available if the backend's balancingMode is RATE. Internal TCP/UDP load balancing does not
   * support setting maxConnectionsPerInstance even though its backends require a balancing mode of
   * CONNECTION.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxConnectionsPerInstance() {
    return maxConnectionsPerInstance;
  }

  /**
   * Defines a maximum target for simultaneous connections for a single VM in a backend instance
   * group. This is multiplied by the number of instances in the instance group to implicitly
   * calculate a target maximum number of simultaneous connections for the whole instance group. If
   * the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's
   * balancingMode is CONNECTION, and backend is attached to a backend service whose
   * loadBalancingScheme is EXTERNAL, you must specify either this parameter, maxConnections, or
   * maxConnectionsPerEndpoint.
   *
   * Not available if the backend's balancingMode is RATE. Internal TCP/UDP load balancing does not
   * support setting maxConnectionsPerInstance even though its backends require a balancing mode of
   * CONNECTION.
   * @param maxConnectionsPerInstance maxConnectionsPerInstance or {@code null} for none
   */
  public Backend setMaxConnectionsPerInstance(java.lang.Integer maxConnectionsPerInstance) {
    this.maxConnectionsPerInstance = maxConnectionsPerInstance;
    return this;
  }

  /**
   * The max requests per second (RPS) of the group. Can be used with either RATE or UTILIZATION
   * balancing modes, but required if RATE mode. For RATE mode, either maxRate or maxRatePerInstance
   * must be set.
   *
   * This cannot be used for internal load balancing.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRate() {
    return maxRate;
  }

  /**
   * The max requests per second (RPS) of the group. Can be used with either RATE or UTILIZATION
   * balancing modes, but required if RATE mode. For RATE mode, either maxRate or maxRatePerInstance
   * must be set.
   *
   * This cannot be used for internal load balancing.
   * @param maxRate maxRate or {@code null} for none
   */
  public Backend setMaxRate(java.lang.Integer maxRate) {
    this.maxRate = maxRate;
    return this;
  }

  /**
   * Defines a maximum target for requests per second (RPS) for an endpoint of a NEG. This is
   * multiplied by the number of endpoints in the NEG to implicitly calculate a target maximum rate
   * for the NEG.
   *
   * If the backend's balancingMode is RATE, you must specify either this parameter, maxRate, or
   * maxRatePerInstance.
   *
   * Not available if the backend's balancingMode is CONNECTION.
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxRatePerEndpoint() {
    return maxRatePerEndpoint;
  }

  /**
   * Defines a maximum target for requests per second (RPS) for an endpoint of a NEG. This is
   * multiplied by the number of endpoints in the NEG to implicitly calculate a target maximum rate
   * for the NEG.
   *
   * If the backend's balancingMode is RATE, you must specify either this parameter, maxRate, or
   * maxRatePerInstance.
   *
   * Not available if the backend's balancingMode is CONNECTION.
   * @param maxRatePerEndpoint maxRatePerEndpoint or {@code null} for none
   */
  public Backend setMaxRatePerEndpoint(java.lang.Float maxRatePerEndpoint) {
    this.maxRatePerEndpoint = maxRatePerEndpoint;
    return this;
  }

  /**
   * Defines a maximum target for requests per second (RPS) for a single VM in a backend instance
   * group. This is multiplied by the number of instances in the instance group to implicitly
   * calculate a target maximum rate for the whole instance group.
   *
   * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's
   * balancingMode is RATE, you must specify either this parameter, maxRate, or maxRatePerEndpoint.
   *
   * Not available if the backend's balancingMode is CONNECTION.
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxRatePerInstance() {
    return maxRatePerInstance;
  }

  /**
   * Defines a maximum target for requests per second (RPS) for a single VM in a backend instance
   * group. This is multiplied by the number of instances in the instance group to implicitly
   * calculate a target maximum rate for the whole instance group.
   *
   * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's
   * balancingMode is RATE, you must specify either this parameter, maxRate, or maxRatePerEndpoint.
   *
   * Not available if the backend's balancingMode is CONNECTION.
   * @param maxRatePerInstance maxRatePerInstance or {@code null} for none
   */
  public Backend setMaxRatePerInstance(java.lang.Float maxRatePerInstance) {
    this.maxRatePerInstance = maxRatePerInstance;
    return this;
  }

  /**
   * Defines the maximum average CPU utilization of a backend VM in an instance group. The valid
   * range is [0.0, 1.0]. This is an optional parameter if the backend's balancingMode is
   * UTILIZATION.
   *
   * This parameter can be used in conjunction with maxRate, maxRatePerInstance, maxConnections, or
   * maxConnectionsPerInstance.
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxUtilization() {
    return maxUtilization;
  }

  /**
   * Defines the maximum average CPU utilization of a backend VM in an instance group. The valid
   * range is [0.0, 1.0]. This is an optional parameter if the backend's balancingMode is
   * UTILIZATION.
   *
   * This parameter can be used in conjunction with maxRate, maxRatePerInstance, maxConnections, or
   * maxConnectionsPerInstance.
   * @param maxUtilization maxUtilization or {@code null} for none
   */
  public Backend setMaxUtilization(java.lang.Float maxUtilization) {
    this.maxUtilization = maxUtilization;
    return this;
  }

  @Override
  public Backend set(String fieldName, Object value) {
    return (Backend) super.set(fieldName, value);
  }

  @Override
  public Backend clone() {
    return (Backend) super.clone();
  }

}
