/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * Metadata describing a long running folder operation
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FolderOperation extends com.google.api.client.json.GenericJson {

  /**
   * The resource name of the folder or organization we are either creating the folder under or
   * moving the folder to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationParent;

  /**
   * The display name of the folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The type of this operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operationType;

  /**
   * The resource name of the folder's parent. Only applicable when the operation_type is MOVE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceParent;

  /**
   * The resource name of the folder or organization we are either creating the folder under or
   * moving the folder to.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationParent() {
    return destinationParent;
  }

  /**
   * The resource name of the folder or organization we are either creating the folder under or
   * moving the folder to.
   * @param destinationParent destinationParent or {@code null} for none
   */
  public FolderOperation setDestinationParent(java.lang.String destinationParent) {
    this.destinationParent = destinationParent;
    return this;
  }

  /**
   * The display name of the folder.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The display name of the folder.
   * @param displayName displayName or {@code null} for none
   */
  public FolderOperation setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The type of this operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperationType() {
    return operationType;
  }

  /**
   * The type of this operation.
   * @param operationType operationType or {@code null} for none
   */
  public FolderOperation setOperationType(java.lang.String operationType) {
    this.operationType = operationType;
    return this;
  }

  /**
   * The resource name of the folder's parent. Only applicable when the operation_type is MOVE.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceParent() {
    return sourceParent;
  }

  /**
   * The resource name of the folder's parent. Only applicable when the operation_type is MOVE.
   * @param sourceParent sourceParent or {@code null} for none
   */
  public FolderOperation setSourceParent(java.lang.String sourceParent) {
    this.sourceParent = sourceParent;
    return this;
  }

  @Override
  public FolderOperation set(String fieldName, Object value) {
    return (FolderOperation) super.set(fieldName, value);
  }

  @Override
  public FolderOperation clone() {
    return (FolderOperation) super.clone();
  }

}
