/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * Response from the projects.getAncestry method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetAncestryResponse extends com.google.api.client.json.GenericJson {

  /**
   * Ancestors are ordered from bottom to top of the resource hierarchy. The first ancestor is the
   * project itself, followed by the project's parent, etc..
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Ancestor> ancestor;

  static {
    // hack to force ProGuard to consider Ancestor used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Ancestor.class);
  }

  /**
   * Ancestors are ordered from bottom to top of the resource hierarchy. The first ancestor is the
   * project itself, followed by the project's parent, etc..
   * @return value or {@code null} for none
   */
  public java.util.List<Ancestor> getAncestor() {
    return ancestor;
  }

  /**
   * Ancestors are ordered from bottom to top of the resource hierarchy. The first ancestor is the
   * project itself, followed by the project's parent, etc..
   * @param ancestor ancestor or {@code null} for none
   */
  public GetAncestryResponse setAncestor(java.util.List<Ancestor> ancestor) {
    this.ancestor = ancestor;
    return this;
  }

  @Override
  public GetAncestryResponse set(String fieldName, Object value) {
    return (GetAncestryResponse) super.set(fieldName, value);
  }

  @Override
  public GetAncestryResponse clone() {
    return (GetAncestryResponse) super.clone();
  }

}
