/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudresourcemanager;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequest;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequestInitializer;
import com.google.api.services.cloudresourcemanager.model.ClearOrgPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.Empty;
import com.google.api.services.cloudresourcemanager.model.GetAncestryRequest;
import com.google.api.services.cloudresourcemanager.model.GetAncestryResponse;
import com.google.api.services.cloudresourcemanager.model.GetEffectiveOrgPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.GetOrgPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.Lien;
import com.google.api.services.cloudresourcemanager.model.ListAvailableOrgPolicyConstraintsRequest;
import com.google.api.services.cloudresourcemanager.model.ListAvailableOrgPolicyConstraintsResponse;
import com.google.api.services.cloudresourcemanager.model.ListLiensResponse;
import com.google.api.services.cloudresourcemanager.model.ListOrgPoliciesRequest;
import com.google.api.services.cloudresourcemanager.model.ListOrgPoliciesResponse;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Operation;
import com.google.api.services.cloudresourcemanager.model.OrgPolicy;
import com.google.api.services.cloudresourcemanager.model.Organization;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.cloudresourcemanager.model.SearchOrganizationsRequest;
import com.google.api.services.cloudresourcemanager.model.SearchOrganizationsResponse;
import com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.SetOrgPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse;
import com.google.api.services.cloudresourcemanager.model.UndeleteProjectRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudResourceManager
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudresourcemanager.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudresourcemanager.googleapis.com/";

    public CloudResourceManager(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudResourceManager(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Folders folders() {
        return new Folders();
    }

    public Liens liens() {
        return new Liens();
    }

    public Operations operations() {
        return new Operations();
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.10 of the Cloud Resource Manager API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://cloudresourcemanager.googleapis.com/", CloudResourceManager.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudResourceManager.DEFAULT_BATCH_PATH);
        }

        public CloudResourceManager build() {
            return new CloudResourceManager(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudResourceManagerRequestInitializer(CloudResourceManagerRequestInitializer cloudresourcemanagerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudresourcemanagerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public ClearOrgPolicy clearOrgPolicy(String resource, ClearOrgPolicyRequest content) throws IOException {
            ClearOrgPolicy result = new ClearOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Project content) throws IOException {
            Create result = new Create(content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String projectId) throws IOException {
            Delete result = new Delete(projectId);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId) throws IOException {
            Get result = new Get(projectId);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetAncestry getAncestry(String projectId, GetAncestryRequest content) throws IOException {
            GetAncestry result = new GetAncestry(projectId, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetEffectiveOrgPolicy getEffectiveOrgPolicy(String resource, GetEffectiveOrgPolicyRequest content) throws IOException {
            GetEffectiveOrgPolicy result = new GetEffectiveOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetOrgPolicy getOrgPolicy(String resource, GetOrgPolicyRequest content) throws IOException {
            GetOrgPolicy result = new GetOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints(String resource, ListAvailableOrgPolicyConstraintsRequest content) throws IOException {
            ListAvailableOrgPolicyConstraints result = new ListAvailableOrgPolicyConstraints(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListOrgPolicies listOrgPolicies(String resource, ListOrgPoliciesRequest content) throws IOException {
            ListOrgPolicies result = new ListOrgPolicies(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetOrgPolicy setOrgPolicy(String resource, SetOrgPolicyRequest content) throws IOException {
            SetOrgPolicy result = new SetOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Undelete undelete(String projectId, UndeleteProjectRequest content) throws IOException {
            Undelete result = new Undelete(projectId, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, Project content) throws IOException {
            Update result = new Update(projectId, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1/projects/{projectId}";
            @Key
            private String projectId;

            protected Update(String projectId, Project content) {
                super(CloudResourceManager.this, "PUT", REST_PATH, (Object)content, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Undelete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/projects/{projectId}:undelete";
            @Key
            private String projectId;

            protected Undelete(String projectId, UndeleteProjectRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Undelete set$Xgafv(String $Xgafv) {
                return (Undelete)super.set$Xgafv($Xgafv);
            }

            public Undelete setAccessToken(String accessToken) {
                return (Undelete)super.setAccessToken(accessToken);
            }

            public Undelete setAlt(String alt) {
                return (Undelete)super.setAlt(alt);
            }

            public Undelete setCallback(String callback) {
                return (Undelete)super.setCallback(callback);
            }

            public Undelete setFields(String fields) {
                return (Undelete)super.setFields(fields);
            }

            public Undelete setKey(String key) {
                return (Undelete)super.setKey(key);
            }

            public Undelete setOauthToken(String oauthToken) {
                return (Undelete)super.setOauthToken(oauthToken);
            }

            public Undelete setPrettyPrint(Boolean prettyPrint) {
                return (Undelete)super.setPrettyPrint(prettyPrint);
            }

            public Undelete setQuotaUser(String quotaUser) {
                return (Undelete)super.setQuotaUser(quotaUser);
            }

            public Undelete setUploadType(String uploadType) {
                return (Undelete)super.setUploadType(uploadType);
            }

            public Undelete setUploadProtocol(String uploadProtocol) {
                return (Undelete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Undelete setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Undelete set(String parameterName, Object value) {
                return (Undelete)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends CloudResourceManagerRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1/projects/{resource}:testIamPermissions";
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:setOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetOrgPolicy(String resource, SetOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public SetOrgPolicy set$Xgafv(String $Xgafv) {
                return (SetOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public SetOrgPolicy setAccessToken(String accessToken) {
                return (SetOrgPolicy)super.setAccessToken(accessToken);
            }

            public SetOrgPolicy setAlt(String alt) {
                return (SetOrgPolicy)super.setAlt(alt);
            }

            public SetOrgPolicy setCallback(String callback) {
                return (SetOrgPolicy)super.setCallback(callback);
            }

            public SetOrgPolicy setFields(String fields) {
                return (SetOrgPolicy)super.setFields(fields);
            }

            public SetOrgPolicy setKey(String key) {
                return (SetOrgPolicy)super.setKey(key);
            }

            public SetOrgPolicy setOauthToken(String oauthToken) {
                return (SetOrgPolicy)super.setOauthToken(oauthToken);
            }

            public SetOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetOrgPolicy setQuotaUser(String quotaUser) {
                return (SetOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public SetOrgPolicy setUploadType(String uploadType) {
                return (SetOrgPolicy)super.setUploadType(uploadType);
            }

            public SetOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (SetOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetOrgPolicy set(String parameterName, Object value) {
                return (SetOrgPolicy)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1/projects/{resource}:setIamPolicy";
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class ListOrgPolicies
        extends CloudResourceManagerRequest<ListOrgPoliciesResponse> {
            private static final String REST_PATH = "v1/{+resource}:listOrgPolicies";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListOrgPolicies(String resource, ListOrgPoliciesRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, ListOrgPoliciesResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public ListOrgPolicies set$Xgafv(String $Xgafv) {
                return (ListOrgPolicies)super.set$Xgafv($Xgafv);
            }

            public ListOrgPolicies setAccessToken(String accessToken) {
                return (ListOrgPolicies)super.setAccessToken(accessToken);
            }

            public ListOrgPolicies setAlt(String alt) {
                return (ListOrgPolicies)super.setAlt(alt);
            }

            public ListOrgPolicies setCallback(String callback) {
                return (ListOrgPolicies)super.setCallback(callback);
            }

            public ListOrgPolicies setFields(String fields) {
                return (ListOrgPolicies)super.setFields(fields);
            }

            public ListOrgPolicies setKey(String key) {
                return (ListOrgPolicies)super.setKey(key);
            }

            public ListOrgPolicies setOauthToken(String oauthToken) {
                return (ListOrgPolicies)super.setOauthToken(oauthToken);
            }

            public ListOrgPolicies setPrettyPrint(Boolean prettyPrint) {
                return (ListOrgPolicies)super.setPrettyPrint(prettyPrint);
            }

            public ListOrgPolicies setQuotaUser(String quotaUser) {
                return (ListOrgPolicies)super.setQuotaUser(quotaUser);
            }

            public ListOrgPolicies setUploadType(String uploadType) {
                return (ListOrgPolicies)super.setUploadType(uploadType);
            }

            public ListOrgPolicies setUploadProtocol(String uploadProtocol) {
                return (ListOrgPolicies)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ListOrgPolicies setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ListOrgPolicies set(String parameterName, Object value) {
                return (ListOrgPolicies)super.set(parameterName, value);
            }
        }

        public class ListAvailableOrgPolicyConstraints
        extends CloudResourceManagerRequest<ListAvailableOrgPolicyConstraintsResponse> {
            private static final String REST_PATH = "v1/{+resource}:listAvailableOrgPolicyConstraints";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListAvailableOrgPolicyConstraints(String resource, ListAvailableOrgPolicyConstraintsRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, ListAvailableOrgPolicyConstraintsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public ListAvailableOrgPolicyConstraints set$Xgafv(String $Xgafv) {
                return (ListAvailableOrgPolicyConstraints)super.set$Xgafv($Xgafv);
            }

            public ListAvailableOrgPolicyConstraints setAccessToken(String accessToken) {
                return (ListAvailableOrgPolicyConstraints)super.setAccessToken(accessToken);
            }

            public ListAvailableOrgPolicyConstraints setAlt(String alt) {
                return (ListAvailableOrgPolicyConstraints)super.setAlt(alt);
            }

            public ListAvailableOrgPolicyConstraints setCallback(String callback) {
                return (ListAvailableOrgPolicyConstraints)super.setCallback(callback);
            }

            public ListAvailableOrgPolicyConstraints setFields(String fields) {
                return (ListAvailableOrgPolicyConstraints)super.setFields(fields);
            }

            public ListAvailableOrgPolicyConstraints setKey(String key) {
                return (ListAvailableOrgPolicyConstraints)super.setKey(key);
            }

            public ListAvailableOrgPolicyConstraints setOauthToken(String oauthToken) {
                return (ListAvailableOrgPolicyConstraints)super.setOauthToken(oauthToken);
            }

            public ListAvailableOrgPolicyConstraints setPrettyPrint(Boolean prettyPrint) {
                return (ListAvailableOrgPolicyConstraints)super.setPrettyPrint(prettyPrint);
            }

            public ListAvailableOrgPolicyConstraints setQuotaUser(String quotaUser) {
                return (ListAvailableOrgPolicyConstraints)super.setQuotaUser(quotaUser);
            }

            public ListAvailableOrgPolicyConstraints setUploadType(String uploadType) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadType(uploadType);
            }

            public ListAvailableOrgPolicyConstraints setUploadProtocol(String uploadProtocol) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ListAvailableOrgPolicyConstraints setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ListAvailableOrgPolicyConstraints set(String parameterName, Object value) {
                return (ListAvailableOrgPolicyConstraints)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudResourceManagerRequest<ListProjectsResponse> {
            private static final String REST_PATH = "v1/projects";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(CloudResourceManager.this, "GET", REST_PATH, null, ListProjectsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetOrgPolicy(String resource, GetOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public GetOrgPolicy set$Xgafv(String $Xgafv) {
                return (GetOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public GetOrgPolicy setAccessToken(String accessToken) {
                return (GetOrgPolicy)super.setAccessToken(accessToken);
            }

            public GetOrgPolicy setAlt(String alt) {
                return (GetOrgPolicy)super.setAlt(alt);
            }

            public GetOrgPolicy setCallback(String callback) {
                return (GetOrgPolicy)super.setCallback(callback);
            }

            public GetOrgPolicy setFields(String fields) {
                return (GetOrgPolicy)super.setFields(fields);
            }

            public GetOrgPolicy setKey(String key) {
                return (GetOrgPolicy)super.setKey(key);
            }

            public GetOrgPolicy setOauthToken(String oauthToken) {
                return (GetOrgPolicy)super.setOauthToken(oauthToken);
            }

            public GetOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetOrgPolicy setQuotaUser(String quotaUser) {
                return (GetOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public GetOrgPolicy setUploadType(String uploadType) {
                return (GetOrgPolicy)super.setUploadType(uploadType);
            }

            public GetOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (GetOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetOrgPolicy set(String parameterName, Object value) {
                return (GetOrgPolicy)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1/projects/{resource}:getIamPolicy";
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class GetEffectiveOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getEffectiveOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetEffectiveOrgPolicy(String resource, GetEffectiveOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public GetEffectiveOrgPolicy set$Xgafv(String $Xgafv) {
                return (GetEffectiveOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public GetEffectiveOrgPolicy setAccessToken(String accessToken) {
                return (GetEffectiveOrgPolicy)super.setAccessToken(accessToken);
            }

            public GetEffectiveOrgPolicy setAlt(String alt) {
                return (GetEffectiveOrgPolicy)super.setAlt(alt);
            }

            public GetEffectiveOrgPolicy setCallback(String callback) {
                return (GetEffectiveOrgPolicy)super.setCallback(callback);
            }

            public GetEffectiveOrgPolicy setFields(String fields) {
                return (GetEffectiveOrgPolicy)super.setFields(fields);
            }

            public GetEffectiveOrgPolicy setKey(String key) {
                return (GetEffectiveOrgPolicy)super.setKey(key);
            }

            public GetEffectiveOrgPolicy setOauthToken(String oauthToken) {
                return (GetEffectiveOrgPolicy)super.setOauthToken(oauthToken);
            }

            public GetEffectiveOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetEffectiveOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetEffectiveOrgPolicy setQuotaUser(String quotaUser) {
                return (GetEffectiveOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public GetEffectiveOrgPolicy setUploadType(String uploadType) {
                return (GetEffectiveOrgPolicy)super.setUploadType(uploadType);
            }

            public GetEffectiveOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (GetEffectiveOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetEffectiveOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetEffectiveOrgPolicy set(String parameterName, Object value) {
                return (GetEffectiveOrgPolicy)super.set(parameterName, value);
            }
        }

        public class GetAncestry
        extends CloudResourceManagerRequest<GetAncestryResponse> {
            private static final String REST_PATH = "v1/projects/{projectId}:getAncestry";
            @Key
            private String projectId;

            protected GetAncestry(String projectId, GetAncestryRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, GetAncestryResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public GetAncestry set$Xgafv(String $Xgafv) {
                return (GetAncestry)super.set$Xgafv($Xgafv);
            }

            public GetAncestry setAccessToken(String accessToken) {
                return (GetAncestry)super.setAccessToken(accessToken);
            }

            public GetAncestry setAlt(String alt) {
                return (GetAncestry)super.setAlt(alt);
            }

            public GetAncestry setCallback(String callback) {
                return (GetAncestry)super.setCallback(callback);
            }

            public GetAncestry setFields(String fields) {
                return (GetAncestry)super.setFields(fields);
            }

            public GetAncestry setKey(String key) {
                return (GetAncestry)super.setKey(key);
            }

            public GetAncestry setOauthToken(String oauthToken) {
                return (GetAncestry)super.setOauthToken(oauthToken);
            }

            public GetAncestry setPrettyPrint(Boolean prettyPrint) {
                return (GetAncestry)super.setPrettyPrint(prettyPrint);
            }

            public GetAncestry setQuotaUser(String quotaUser) {
                return (GetAncestry)super.setQuotaUser(quotaUser);
            }

            public GetAncestry setUploadType(String uploadType) {
                return (GetAncestry)super.setUploadType(uploadType);
            }

            public GetAncestry setUploadProtocol(String uploadProtocol) {
                return (GetAncestry)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetAncestry setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public GetAncestry set(String parameterName, Object value) {
                return (GetAncestry)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1/projects/{projectId}";
            @Key
            private String projectId;

            protected Get(String projectId) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/projects/{projectId}";
            @Key
            private String projectId;

            protected Delete(String projectId) {
                super(CloudResourceManager.this, "DELETE", REST_PATH, null, Empty.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudResourceManagerRequest<Operation> {
            private static final String REST_PATH = "v1/projects";

            protected Create(Project content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class ClearOrgPolicy
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/{+resource}:clearOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ClearOrgPolicy(String resource, ClearOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public ClearOrgPolicy set$Xgafv(String $Xgafv) {
                return (ClearOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public ClearOrgPolicy setAccessToken(String accessToken) {
                return (ClearOrgPolicy)super.setAccessToken(accessToken);
            }

            public ClearOrgPolicy setAlt(String alt) {
                return (ClearOrgPolicy)super.setAlt(alt);
            }

            public ClearOrgPolicy setCallback(String callback) {
                return (ClearOrgPolicy)super.setCallback(callback);
            }

            public ClearOrgPolicy setFields(String fields) {
                return (ClearOrgPolicy)super.setFields(fields);
            }

            public ClearOrgPolicy setKey(String key) {
                return (ClearOrgPolicy)super.setKey(key);
            }

            public ClearOrgPolicy setOauthToken(String oauthToken) {
                return (ClearOrgPolicy)super.setOauthToken(oauthToken);
            }

            public ClearOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (ClearOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public ClearOrgPolicy setQuotaUser(String quotaUser) {
                return (ClearOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public ClearOrgPolicy setUploadType(String uploadType) {
                return (ClearOrgPolicy)super.setUploadType(uploadType);
            }

            public ClearOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (ClearOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ClearOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ClearOrgPolicy set(String parameterName, Object value) {
                return (ClearOrgPolicy)super.set(parameterName, value);
            }
        }
    }

    public class Organizations {
        public ClearOrgPolicy clearOrgPolicy(String resource, ClearOrgPolicyRequest content) throws IOException {
            ClearOrgPolicy result = new ClearOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetEffectiveOrgPolicy getEffectiveOrgPolicy(String resource, GetEffectiveOrgPolicyRequest content) throws IOException {
            GetEffectiveOrgPolicy result = new GetEffectiveOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetOrgPolicy getOrgPolicy(String resource, GetOrgPolicyRequest content) throws IOException {
            GetOrgPolicy result = new GetOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints(String resource, ListAvailableOrgPolicyConstraintsRequest content) throws IOException {
            ListAvailableOrgPolicyConstraints result = new ListAvailableOrgPolicyConstraints(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListOrgPolicies listOrgPolicies(String resource, ListOrgPoliciesRequest content) throws IOException {
            ListOrgPolicies result = new ListOrgPolicies(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search(SearchOrganizationsRequest content) throws IOException {
            Search result = new Search(content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetOrgPolicy setOrgPolicy(String resource, SetOrgPolicyRequest content) throws IOException {
            SetOrgPolicy result = new SetOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends CloudResourceManagerRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:setOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetOrgPolicy(String resource, SetOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public SetOrgPolicy set$Xgafv(String $Xgafv) {
                return (SetOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public SetOrgPolicy setAccessToken(String accessToken) {
                return (SetOrgPolicy)super.setAccessToken(accessToken);
            }

            public SetOrgPolicy setAlt(String alt) {
                return (SetOrgPolicy)super.setAlt(alt);
            }

            public SetOrgPolicy setCallback(String callback) {
                return (SetOrgPolicy)super.setCallback(callback);
            }

            public SetOrgPolicy setFields(String fields) {
                return (SetOrgPolicy)super.setFields(fields);
            }

            public SetOrgPolicy setKey(String key) {
                return (SetOrgPolicy)super.setKey(key);
            }

            public SetOrgPolicy setOauthToken(String oauthToken) {
                return (SetOrgPolicy)super.setOauthToken(oauthToken);
            }

            public SetOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetOrgPolicy setQuotaUser(String quotaUser) {
                return (SetOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public SetOrgPolicy setUploadType(String uploadType) {
                return (SetOrgPolicy)super.setUploadType(uploadType);
            }

            public SetOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (SetOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetOrgPolicy set(String parameterName, Object value) {
                return (SetOrgPolicy)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Search
        extends CloudResourceManagerRequest<SearchOrganizationsResponse> {
            private static final String REST_PATH = "v1/organizations:search";

            protected Search(SearchOrganizationsRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, SearchOrganizationsResponse.class);
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class ListOrgPolicies
        extends CloudResourceManagerRequest<ListOrgPoliciesResponse> {
            private static final String REST_PATH = "v1/{+resource}:listOrgPolicies";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListOrgPolicies(String resource, ListOrgPoliciesRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, ListOrgPoliciesResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public ListOrgPolicies set$Xgafv(String $Xgafv) {
                return (ListOrgPolicies)super.set$Xgafv($Xgafv);
            }

            public ListOrgPolicies setAccessToken(String accessToken) {
                return (ListOrgPolicies)super.setAccessToken(accessToken);
            }

            public ListOrgPolicies setAlt(String alt) {
                return (ListOrgPolicies)super.setAlt(alt);
            }

            public ListOrgPolicies setCallback(String callback) {
                return (ListOrgPolicies)super.setCallback(callback);
            }

            public ListOrgPolicies setFields(String fields) {
                return (ListOrgPolicies)super.setFields(fields);
            }

            public ListOrgPolicies setKey(String key) {
                return (ListOrgPolicies)super.setKey(key);
            }

            public ListOrgPolicies setOauthToken(String oauthToken) {
                return (ListOrgPolicies)super.setOauthToken(oauthToken);
            }

            public ListOrgPolicies setPrettyPrint(Boolean prettyPrint) {
                return (ListOrgPolicies)super.setPrettyPrint(prettyPrint);
            }

            public ListOrgPolicies setQuotaUser(String quotaUser) {
                return (ListOrgPolicies)super.setQuotaUser(quotaUser);
            }

            public ListOrgPolicies setUploadType(String uploadType) {
                return (ListOrgPolicies)super.setUploadType(uploadType);
            }

            public ListOrgPolicies setUploadProtocol(String uploadProtocol) {
                return (ListOrgPolicies)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ListOrgPolicies setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ListOrgPolicies set(String parameterName, Object value) {
                return (ListOrgPolicies)super.set(parameterName, value);
            }
        }

        public class ListAvailableOrgPolicyConstraints
        extends CloudResourceManagerRequest<ListAvailableOrgPolicyConstraintsResponse> {
            private static final String REST_PATH = "v1/{+resource}:listAvailableOrgPolicyConstraints";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListAvailableOrgPolicyConstraints(String resource, ListAvailableOrgPolicyConstraintsRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, ListAvailableOrgPolicyConstraintsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public ListAvailableOrgPolicyConstraints set$Xgafv(String $Xgafv) {
                return (ListAvailableOrgPolicyConstraints)super.set$Xgafv($Xgafv);
            }

            public ListAvailableOrgPolicyConstraints setAccessToken(String accessToken) {
                return (ListAvailableOrgPolicyConstraints)super.setAccessToken(accessToken);
            }

            public ListAvailableOrgPolicyConstraints setAlt(String alt) {
                return (ListAvailableOrgPolicyConstraints)super.setAlt(alt);
            }

            public ListAvailableOrgPolicyConstraints setCallback(String callback) {
                return (ListAvailableOrgPolicyConstraints)super.setCallback(callback);
            }

            public ListAvailableOrgPolicyConstraints setFields(String fields) {
                return (ListAvailableOrgPolicyConstraints)super.setFields(fields);
            }

            public ListAvailableOrgPolicyConstraints setKey(String key) {
                return (ListAvailableOrgPolicyConstraints)super.setKey(key);
            }

            public ListAvailableOrgPolicyConstraints setOauthToken(String oauthToken) {
                return (ListAvailableOrgPolicyConstraints)super.setOauthToken(oauthToken);
            }

            public ListAvailableOrgPolicyConstraints setPrettyPrint(Boolean prettyPrint) {
                return (ListAvailableOrgPolicyConstraints)super.setPrettyPrint(prettyPrint);
            }

            public ListAvailableOrgPolicyConstraints setQuotaUser(String quotaUser) {
                return (ListAvailableOrgPolicyConstraints)super.setQuotaUser(quotaUser);
            }

            public ListAvailableOrgPolicyConstraints setUploadType(String uploadType) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadType(uploadType);
            }

            public ListAvailableOrgPolicyConstraints setUploadProtocol(String uploadProtocol) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ListAvailableOrgPolicyConstraints setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ListAvailableOrgPolicyConstraints set(String parameterName, Object value) {
                return (ListAvailableOrgPolicyConstraints)super.set(parameterName, value);
            }
        }

        public class GetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetOrgPolicy(String resource, GetOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public GetOrgPolicy set$Xgafv(String $Xgafv) {
                return (GetOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public GetOrgPolicy setAccessToken(String accessToken) {
                return (GetOrgPolicy)super.setAccessToken(accessToken);
            }

            public GetOrgPolicy setAlt(String alt) {
                return (GetOrgPolicy)super.setAlt(alt);
            }

            public GetOrgPolicy setCallback(String callback) {
                return (GetOrgPolicy)super.setCallback(callback);
            }

            public GetOrgPolicy setFields(String fields) {
                return (GetOrgPolicy)super.setFields(fields);
            }

            public GetOrgPolicy setKey(String key) {
                return (GetOrgPolicy)super.setKey(key);
            }

            public GetOrgPolicy setOauthToken(String oauthToken) {
                return (GetOrgPolicy)super.setOauthToken(oauthToken);
            }

            public GetOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetOrgPolicy setQuotaUser(String quotaUser) {
                return (GetOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public GetOrgPolicy setUploadType(String uploadType) {
                return (GetOrgPolicy)super.setUploadType(uploadType);
            }

            public GetOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (GetOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetOrgPolicy set(String parameterName, Object value) {
                return (GetOrgPolicy)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class GetEffectiveOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getEffectiveOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetEffectiveOrgPolicy(String resource, GetEffectiveOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public GetEffectiveOrgPolicy set$Xgafv(String $Xgafv) {
                return (GetEffectiveOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public GetEffectiveOrgPolicy setAccessToken(String accessToken) {
                return (GetEffectiveOrgPolicy)super.setAccessToken(accessToken);
            }

            public GetEffectiveOrgPolicy setAlt(String alt) {
                return (GetEffectiveOrgPolicy)super.setAlt(alt);
            }

            public GetEffectiveOrgPolicy setCallback(String callback) {
                return (GetEffectiveOrgPolicy)super.setCallback(callback);
            }

            public GetEffectiveOrgPolicy setFields(String fields) {
                return (GetEffectiveOrgPolicy)super.setFields(fields);
            }

            public GetEffectiveOrgPolicy setKey(String key) {
                return (GetEffectiveOrgPolicy)super.setKey(key);
            }

            public GetEffectiveOrgPolicy setOauthToken(String oauthToken) {
                return (GetEffectiveOrgPolicy)super.setOauthToken(oauthToken);
            }

            public GetEffectiveOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetEffectiveOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetEffectiveOrgPolicy setQuotaUser(String quotaUser) {
                return (GetEffectiveOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public GetEffectiveOrgPolicy setUploadType(String uploadType) {
                return (GetEffectiveOrgPolicy)super.setUploadType(uploadType);
            }

            public GetEffectiveOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (GetEffectiveOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetEffectiveOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetEffectiveOrgPolicy set(String parameterName, Object value) {
                return (GetEffectiveOrgPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudResourceManagerRequest<Organization> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Organization.class);
                this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class ClearOrgPolicy
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/{+resource}:clearOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ClearOrgPolicy(String resource, ClearOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public ClearOrgPolicy set$Xgafv(String $Xgafv) {
                return (ClearOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public ClearOrgPolicy setAccessToken(String accessToken) {
                return (ClearOrgPolicy)super.setAccessToken(accessToken);
            }

            public ClearOrgPolicy setAlt(String alt) {
                return (ClearOrgPolicy)super.setAlt(alt);
            }

            public ClearOrgPolicy setCallback(String callback) {
                return (ClearOrgPolicy)super.setCallback(callback);
            }

            public ClearOrgPolicy setFields(String fields) {
                return (ClearOrgPolicy)super.setFields(fields);
            }

            public ClearOrgPolicy setKey(String key) {
                return (ClearOrgPolicy)super.setKey(key);
            }

            public ClearOrgPolicy setOauthToken(String oauthToken) {
                return (ClearOrgPolicy)super.setOauthToken(oauthToken);
            }

            public ClearOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (ClearOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public ClearOrgPolicy setQuotaUser(String quotaUser) {
                return (ClearOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public ClearOrgPolicy setUploadType(String uploadType) {
                return (ClearOrgPolicy)super.setUploadType(uploadType);
            }

            public ClearOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (ClearOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ClearOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ClearOrgPolicy set(String parameterName, Object value) {
                return (ClearOrgPolicy)super.set(parameterName, value);
            }
        }
    }

    public class Operations {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends CloudResourceManagerRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Liens {
        public Create create(Lien content) throws IOException {
            Create result = new Create(content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends CloudResourceManagerRequest<ListLiensResponse> {
            private static final String REST_PATH = "v1/liens";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String parent;

            protected List() {
                super(CloudResourceManager.this, "GET", REST_PATH, null, ListLiensResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                this.parent = parent;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudResourceManagerRequest<Lien> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Lien.class);
                this.NAME_PATTERN = Pattern.compile("^liens/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^liens/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^liens/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(CloudResourceManager.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^liens/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^liens/.*$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^liens/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudResourceManagerRequest<Lien> {
            private static final String REST_PATH = "v1/liens";

            protected Create(Lien content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Lien.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Folders {
        public ClearOrgPolicy clearOrgPolicy(String resource, ClearOrgPolicyRequest content) throws IOException {
            ClearOrgPolicy result = new ClearOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetEffectiveOrgPolicy getEffectiveOrgPolicy(String resource, GetEffectiveOrgPolicyRequest content) throws IOException {
            GetEffectiveOrgPolicy result = new GetEffectiveOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetOrgPolicy getOrgPolicy(String resource, GetOrgPolicyRequest content) throws IOException {
            GetOrgPolicy result = new GetOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints(String resource, ListAvailableOrgPolicyConstraintsRequest content) throws IOException {
            ListAvailableOrgPolicyConstraints result = new ListAvailableOrgPolicyConstraints(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListOrgPolicies listOrgPolicies(String resource, ListOrgPoliciesRequest content) throws IOException {
            ListOrgPolicies result = new ListOrgPolicies(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetOrgPolicy setOrgPolicy(String resource, SetOrgPolicyRequest content) throws IOException {
            SetOrgPolicy result = new SetOrgPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class SetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:setOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetOrgPolicy(String resource, SetOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public SetOrgPolicy set$Xgafv(String $Xgafv) {
                return (SetOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public SetOrgPolicy setAccessToken(String accessToken) {
                return (SetOrgPolicy)super.setAccessToken(accessToken);
            }

            public SetOrgPolicy setAlt(String alt) {
                return (SetOrgPolicy)super.setAlt(alt);
            }

            public SetOrgPolicy setCallback(String callback) {
                return (SetOrgPolicy)super.setCallback(callback);
            }

            public SetOrgPolicy setFields(String fields) {
                return (SetOrgPolicy)super.setFields(fields);
            }

            public SetOrgPolicy setKey(String key) {
                return (SetOrgPolicy)super.setKey(key);
            }

            public SetOrgPolicy setOauthToken(String oauthToken) {
                return (SetOrgPolicy)super.setOauthToken(oauthToken);
            }

            public SetOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetOrgPolicy setQuotaUser(String quotaUser) {
                return (SetOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public SetOrgPolicy setUploadType(String uploadType) {
                return (SetOrgPolicy)super.setUploadType(uploadType);
            }

            public SetOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (SetOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetOrgPolicy set(String parameterName, Object value) {
                return (SetOrgPolicy)super.set(parameterName, value);
            }
        }

        public class ListOrgPolicies
        extends CloudResourceManagerRequest<ListOrgPoliciesResponse> {
            private static final String REST_PATH = "v1/{+resource}:listOrgPolicies";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListOrgPolicies(String resource, ListOrgPoliciesRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, ListOrgPoliciesResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public ListOrgPolicies set$Xgafv(String $Xgafv) {
                return (ListOrgPolicies)super.set$Xgafv($Xgafv);
            }

            public ListOrgPolicies setAccessToken(String accessToken) {
                return (ListOrgPolicies)super.setAccessToken(accessToken);
            }

            public ListOrgPolicies setAlt(String alt) {
                return (ListOrgPolicies)super.setAlt(alt);
            }

            public ListOrgPolicies setCallback(String callback) {
                return (ListOrgPolicies)super.setCallback(callback);
            }

            public ListOrgPolicies setFields(String fields) {
                return (ListOrgPolicies)super.setFields(fields);
            }

            public ListOrgPolicies setKey(String key) {
                return (ListOrgPolicies)super.setKey(key);
            }

            public ListOrgPolicies setOauthToken(String oauthToken) {
                return (ListOrgPolicies)super.setOauthToken(oauthToken);
            }

            public ListOrgPolicies setPrettyPrint(Boolean prettyPrint) {
                return (ListOrgPolicies)super.setPrettyPrint(prettyPrint);
            }

            public ListOrgPolicies setQuotaUser(String quotaUser) {
                return (ListOrgPolicies)super.setQuotaUser(quotaUser);
            }

            public ListOrgPolicies setUploadType(String uploadType) {
                return (ListOrgPolicies)super.setUploadType(uploadType);
            }

            public ListOrgPolicies setUploadProtocol(String uploadProtocol) {
                return (ListOrgPolicies)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ListOrgPolicies setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ListOrgPolicies set(String parameterName, Object value) {
                return (ListOrgPolicies)super.set(parameterName, value);
            }
        }

        public class ListAvailableOrgPolicyConstraints
        extends CloudResourceManagerRequest<ListAvailableOrgPolicyConstraintsResponse> {
            private static final String REST_PATH = "v1/{+resource}:listAvailableOrgPolicyConstraints";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListAvailableOrgPolicyConstraints(String resource, ListAvailableOrgPolicyConstraintsRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, ListAvailableOrgPolicyConstraintsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public ListAvailableOrgPolicyConstraints set$Xgafv(String $Xgafv) {
                return (ListAvailableOrgPolicyConstraints)super.set$Xgafv($Xgafv);
            }

            public ListAvailableOrgPolicyConstraints setAccessToken(String accessToken) {
                return (ListAvailableOrgPolicyConstraints)super.setAccessToken(accessToken);
            }

            public ListAvailableOrgPolicyConstraints setAlt(String alt) {
                return (ListAvailableOrgPolicyConstraints)super.setAlt(alt);
            }

            public ListAvailableOrgPolicyConstraints setCallback(String callback) {
                return (ListAvailableOrgPolicyConstraints)super.setCallback(callback);
            }

            public ListAvailableOrgPolicyConstraints setFields(String fields) {
                return (ListAvailableOrgPolicyConstraints)super.setFields(fields);
            }

            public ListAvailableOrgPolicyConstraints setKey(String key) {
                return (ListAvailableOrgPolicyConstraints)super.setKey(key);
            }

            public ListAvailableOrgPolicyConstraints setOauthToken(String oauthToken) {
                return (ListAvailableOrgPolicyConstraints)super.setOauthToken(oauthToken);
            }

            public ListAvailableOrgPolicyConstraints setPrettyPrint(Boolean prettyPrint) {
                return (ListAvailableOrgPolicyConstraints)super.setPrettyPrint(prettyPrint);
            }

            public ListAvailableOrgPolicyConstraints setQuotaUser(String quotaUser) {
                return (ListAvailableOrgPolicyConstraints)super.setQuotaUser(quotaUser);
            }

            public ListAvailableOrgPolicyConstraints setUploadType(String uploadType) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadType(uploadType);
            }

            public ListAvailableOrgPolicyConstraints setUploadProtocol(String uploadProtocol) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ListAvailableOrgPolicyConstraints setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ListAvailableOrgPolicyConstraints set(String parameterName, Object value) {
                return (ListAvailableOrgPolicyConstraints)super.set(parameterName, value);
            }
        }

        public class GetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetOrgPolicy(String resource, GetOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public GetOrgPolicy set$Xgafv(String $Xgafv) {
                return (GetOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public GetOrgPolicy setAccessToken(String accessToken) {
                return (GetOrgPolicy)super.setAccessToken(accessToken);
            }

            public GetOrgPolicy setAlt(String alt) {
                return (GetOrgPolicy)super.setAlt(alt);
            }

            public GetOrgPolicy setCallback(String callback) {
                return (GetOrgPolicy)super.setCallback(callback);
            }

            public GetOrgPolicy setFields(String fields) {
                return (GetOrgPolicy)super.setFields(fields);
            }

            public GetOrgPolicy setKey(String key) {
                return (GetOrgPolicy)super.setKey(key);
            }

            public GetOrgPolicy setOauthToken(String oauthToken) {
                return (GetOrgPolicy)super.setOauthToken(oauthToken);
            }

            public GetOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetOrgPolicy setQuotaUser(String quotaUser) {
                return (GetOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public GetOrgPolicy setUploadType(String uploadType) {
                return (GetOrgPolicy)super.setUploadType(uploadType);
            }

            public GetOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (GetOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetOrgPolicy set(String parameterName, Object value) {
                return (GetOrgPolicy)super.set(parameterName, value);
            }
        }

        public class GetEffectiveOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getEffectiveOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetEffectiveOrgPolicy(String resource, GetEffectiveOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public GetEffectiveOrgPolicy set$Xgafv(String $Xgafv) {
                return (GetEffectiveOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public GetEffectiveOrgPolicy setAccessToken(String accessToken) {
                return (GetEffectiveOrgPolicy)super.setAccessToken(accessToken);
            }

            public GetEffectiveOrgPolicy setAlt(String alt) {
                return (GetEffectiveOrgPolicy)super.setAlt(alt);
            }

            public GetEffectiveOrgPolicy setCallback(String callback) {
                return (GetEffectiveOrgPolicy)super.setCallback(callback);
            }

            public GetEffectiveOrgPolicy setFields(String fields) {
                return (GetEffectiveOrgPolicy)super.setFields(fields);
            }

            public GetEffectiveOrgPolicy setKey(String key) {
                return (GetEffectiveOrgPolicy)super.setKey(key);
            }

            public GetEffectiveOrgPolicy setOauthToken(String oauthToken) {
                return (GetEffectiveOrgPolicy)super.setOauthToken(oauthToken);
            }

            public GetEffectiveOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetEffectiveOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetEffectiveOrgPolicy setQuotaUser(String quotaUser) {
                return (GetEffectiveOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public GetEffectiveOrgPolicy setUploadType(String uploadType) {
                return (GetEffectiveOrgPolicy)super.setUploadType(uploadType);
            }

            public GetEffectiveOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (GetEffectiveOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetEffectiveOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetEffectiveOrgPolicy set(String parameterName, Object value) {
                return (GetEffectiveOrgPolicy)super.set(parameterName, value);
            }
        }

        public class ClearOrgPolicy
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/{+resource}:clearOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ClearOrgPolicy(String resource, ClearOrgPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public ClearOrgPolicy set$Xgafv(String $Xgafv) {
                return (ClearOrgPolicy)super.set$Xgafv($Xgafv);
            }

            public ClearOrgPolicy setAccessToken(String accessToken) {
                return (ClearOrgPolicy)super.setAccessToken(accessToken);
            }

            public ClearOrgPolicy setAlt(String alt) {
                return (ClearOrgPolicy)super.setAlt(alt);
            }

            public ClearOrgPolicy setCallback(String callback) {
                return (ClearOrgPolicy)super.setCallback(callback);
            }

            public ClearOrgPolicy setFields(String fields) {
                return (ClearOrgPolicy)super.setFields(fields);
            }

            public ClearOrgPolicy setKey(String key) {
                return (ClearOrgPolicy)super.setKey(key);
            }

            public ClearOrgPolicy setOauthToken(String oauthToken) {
                return (ClearOrgPolicy)super.setOauthToken(oauthToken);
            }

            public ClearOrgPolicy setPrettyPrint(Boolean prettyPrint) {
                return (ClearOrgPolicy)super.setPrettyPrint(prettyPrint);
            }

            public ClearOrgPolicy setQuotaUser(String quotaUser) {
                return (ClearOrgPolicy)super.setQuotaUser(quotaUser);
            }

            public ClearOrgPolicy setUploadType(String uploadType) {
                return (ClearOrgPolicy)super.setUploadType(uploadType);
            }

            public ClearOrgPolicy setUploadProtocol(String uploadProtocol) {
                return (ClearOrgPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public ClearOrgPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public ClearOrgPolicy set(String parameterName, Object value) {
                return (ClearOrgPolicy)super.set(parameterName, value);
            }
        }
    }
}

