/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * A Lien represents an encumbrance on the actions that can be performed on a resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Lien extends com.google.api.client.json.GenericJson {

  /**
   * The creation time of this Lien.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * A system-generated unique identifier for this Lien. Example: `liens/1234abcd`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A stable, user-visible/meaningful string identifying the origin of the Lien, intended to be
   * inspected programmatically. Maximum length of 200 characters. Example: 'compute.googleapis.com'
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String origin;

  /**
   * A reference to the resource this Lien is attached to. The server will validate the parent
   * against those for which Liens are supported. Example: `projects/1234`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parent;

  /**
   * Concise user-visible strings indicating why an action cannot be performed on a resource.
   * Maximum length of 200 characters. Example: 'Holds production API key'
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The types of operations which should be blocked as a result of this Lien. Each value should
   * correspond to an IAM permission. The server will validate the permissions against those for
   * which Liens are supported. An empty list is meaningless and will be rejected. Example:
   * ['resourcemanager.projects.delete']
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> restrictions;

  /**
   * The creation time of this Lien.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * The creation time of this Lien.
   * @param createTime createTime or {@code null} for none
   */
  public Lien setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * A system-generated unique identifier for this Lien. Example: `liens/1234abcd`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A system-generated unique identifier for this Lien. Example: `liens/1234abcd`
   * @param name name or {@code null} for none
   */
  public Lien setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A stable, user-visible/meaningful string identifying the origin of the Lien, intended to be
   * inspected programmatically. Maximum length of 200 characters. Example: 'compute.googleapis.com'
   * @return value or {@code null} for none
   */
  public java.lang.String getOrigin() {
    return origin;
  }

  /**
   * A stable, user-visible/meaningful string identifying the origin of the Lien, intended to be
   * inspected programmatically. Maximum length of 200 characters. Example: 'compute.googleapis.com'
   * @param origin origin or {@code null} for none
   */
  public Lien setOrigin(java.lang.String origin) {
    this.origin = origin;
    return this;
  }

  /**
   * A reference to the resource this Lien is attached to. The server will validate the parent
   * against those for which Liens are supported. Example: `projects/1234`
   * @return value or {@code null} for none
   */
  public java.lang.String getParent() {
    return parent;
  }

  /**
   * A reference to the resource this Lien is attached to. The server will validate the parent
   * against those for which Liens are supported. Example: `projects/1234`
   * @param parent parent or {@code null} for none
   */
  public Lien setParent(java.lang.String parent) {
    this.parent = parent;
    return this;
  }

  /**
   * Concise user-visible strings indicating why an action cannot be performed on a resource.
   * Maximum length of 200 characters. Example: 'Holds production API key'
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * Concise user-visible strings indicating why an action cannot be performed on a resource.
   * Maximum length of 200 characters. Example: 'Holds production API key'
   * @param reason reason or {@code null} for none
   */
  public Lien setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The types of operations which should be blocked as a result of this Lien. Each value should
   * correspond to an IAM permission. The server will validate the permissions against those for
   * which Liens are supported. An empty list is meaningless and will be rejected. Example:
   * ['resourcemanager.projects.delete']
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRestrictions() {
    return restrictions;
  }

  /**
   * The types of operations which should be blocked as a result of this Lien. Each value should
   * correspond to an IAM permission. The server will validate the permissions against those for
   * which Liens are supported. An empty list is meaningless and will be rejected. Example:
   * ['resourcemanager.projects.delete']
   * @param restrictions restrictions or {@code null} for none
   */
  public Lien setRestrictions(java.util.List<java.lang.String> restrictions) {
    this.restrictions = restrictions;
    return this;
  }

  @Override
  public Lien set(String fieldName, Object value) {
    return (Lien) super.set(fieldName, value);
  }

  @Override
  public Lien clone() {
    return (Lien) super.clone();
  }

}
