/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * The response returned from the ListOrgPolicies method. It will be empty if no `Policies` are set
 * on the resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListOrgPoliciesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Page token used to retrieve the next page. This is currently not used, but the server may at
   * any point start supplying a valid token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The `Policies` that are set on the resource. It will be empty if no `Policies` are set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrgPolicy> policies;

  /**
   * Page token used to retrieve the next page. This is currently not used, but the server may at
   * any point start supplying a valid token.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Page token used to retrieve the next page. This is currently not used, but the server may at
   * any point start supplying a valid token.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListOrgPoliciesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The `Policies` that are set on the resource. It will be empty if no `Policies` are set.
   * @return value or {@code null} for none
   */
  public java.util.List<OrgPolicy> getPolicies() {
    return policies;
  }

  /**
   * The `Policies` that are set on the resource. It will be empty if no `Policies` are set.
   * @param policies policies or {@code null} for none
   */
  public ListOrgPoliciesResponse setPolicies(java.util.List<OrgPolicy> policies) {
    this.policies = policies;
    return this;
  }

  @Override
  public ListOrgPoliciesResponse set(String fieldName, Object value) {
    return (ListOrgPoliciesResponse) super.set(fieldName, value);
  }

  @Override
  public ListOrgPoliciesResponse clone() {
    return (ListOrgPoliciesResponse) super.clone();
  }

}
