# Cloud Resource Manager API Client Library for Java

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

This page contains information about getting started with the Cloud Resource Manager API
using the Google API Client Library for Java. In addition, you may be interested
in the following documentation:

* Browse the [Javadoc reference for the Cloud Resource Manager API][javadoc]
* Read the [Developer's Guide for the Google API Client Library for Java][google-api-client].
* Interact with this API in your browser using the [APIs Explorer for the Cloud Resource Manager API][api-explorer]

## Installation

### Maven

Add the following lines to your `pom.xml` file:

```xml
<project>
  <dependencies>
    <dependency>
      <groupId>com.google.apis</groupId>
      <artifactId>google-api-services-cloudresourcemanager</artifactId>
      <version>v1-rev20200311-1.30.9</version>
    </dependency>
  </dependencies>
</project>
```

### Gradle

```gradle
repositories {
  mavenCentral()
}
dependencies {
  compile 'com.google.apis:google-api-services-cloudresourcemanager:v1-rev20200311-1.30.9'
}
```

[javadoc]: https://googleapis.dev/java/google-api-services-cloudresourcemanager/latest/index.html
[google-api-client]: https://github.com/googleapis/google-api-java-client/
[api-explorer]: https://developers.google.com/apis-explorer/#p/cloudresourcemanager/v1/
