/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.bigquery;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.bigquery.BigqueryRequest;
import com.google.api.services.bigquery.BigqueryRequestInitializer;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.GetServiceAccountResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobCancelResponse;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.ListModelsResponse;
import com.google.api.services.bigquery.model.Model;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableList;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bigquery
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "bigquery/v2/";
    public static final String DEFAULT_BATCH_PATH = "batch/bigquery/v2";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/bigquery/v2/";

    public Bigquery(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Bigquery(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Datasets datasets() {
        return new Datasets();
    }

    public Jobs jobs() {
        return new Jobs();
    }

    public Models models() {
        return new Models();
    }

    public Projects projects() {
        return new Projects();
    }

    public Tabledata tabledata() {
        return new Tabledata();
    }

    public Tables tables() {
        return new Tables();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the BigQuery API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Bigquery.DEFAULT_ROOT_URL, Bigquery.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Bigquery.DEFAULT_BATCH_PATH);
        }

        public Bigquery build() {
            return new Bigquery(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setBigqueryRequestInitializer(BigqueryRequestInitializer bigqueryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)bigqueryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Tables {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Table table) throws IOException {
            Insert insert = new Insert(string, string2, table);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, Table table) throws IOException {
            Patch patch = new Patch(string, string2, string3, table);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, String string3, Table table) throws IOException {
            Update update = new Update(string, string2, string3, table);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Update(String string, String string2, String string3, Table table) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)table, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Update setTableId(String string) {
                this.tableId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Patch(String string, String string2, String string3, Table table) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)table, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Patch setTableId(String string) {
                this.tableId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<TableList> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, TableList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Insert(String string, String string2, Table table) {
                super(Bigquery.this, "POST", REST_PATH, (Object)table, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Insert setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private String selectedFields;

            protected Get(String string, String string2, String string3) {
                super(Bigquery.this, "GET", REST_PATH, null, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Get setTableId(String string) {
                this.tableId = string;
                return this;
            }

            public String getSelectedFields() {
                return this.selectedFields;
            }

            public Get setSelectedFields(String string) {
                this.selectedFields = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Delete(String string, String string2, String string3) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Delete setTableId(String string) {
                this.tableId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Tabledata {
        public InsertAll insertAll(String string, String string2, String string3, TableDataInsertAllRequest tableDataInsertAllRequest) throws IOException {
            InsertAll insertAll = new InsertAll(string, string2, string3, tableDataInsertAllRequest);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insertAll);
            return insertAll;
        }

        public List list(String string, String string2, String string3) throws IOException {
            List list = new List(string, string2, string3);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<TableDataList> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/data";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private String selectedFields;
            @Key
            private BigInteger startIndex;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2, String string3) {
                super(Bigquery.this, "GET", REST_PATH, null, TableDataList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public List setTableId(String string) {
                this.tableId = string;
                return this;
            }

            public String getSelectedFields() {
                return this.selectedFields;
            }

            public List setSelectedFields(String string) {
                this.selectedFields = string;
                return this;
            }

            public BigInteger getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(BigInteger bigInteger) {
                this.startIndex = bigInteger;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InsertAll
        extends BigqueryRequest<TableDataInsertAllResponse> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/insertAll";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected InsertAll(String string, String string2, String string3, TableDataInsertAllRequest tableDataInsertAllRequest) {
                super(Bigquery.this, "POST", REST_PATH, (Object)tableDataInsertAllRequest, TableDataInsertAllResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public InsertAll setAlt(String string) {
                return (InsertAll)super.setAlt(string);
            }

            public InsertAll setFields(String string) {
                return (InsertAll)super.setFields(string);
            }

            public InsertAll setKey(String string) {
                return (InsertAll)super.setKey(string);
            }

            public InsertAll setOauthToken(String string) {
                return (InsertAll)super.setOauthToken(string);
            }

            public InsertAll setPrettyPrint(Boolean bl) {
                return (InsertAll)super.setPrettyPrint(bl);
            }

            public InsertAll setQuotaUser(String string) {
                return (InsertAll)super.setQuotaUser(string);
            }

            public InsertAll setUserIp(String string) {
                return (InsertAll)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public InsertAll setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public InsertAll setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public InsertAll setTableId(String string) {
                this.tableId = string;
                return this;
            }

            @Override
            public InsertAll set(String string, Object object) {
                return (InsertAll)super.set(string, object);
            }
        }
    }

    public class Projects {
        public GetServiceAccount getServiceAccount(String string) throws IOException {
            GetServiceAccount getServiceAccount = new GetServiceAccount(string);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)getServiceAccount);
            return getServiceAccount;
        }

        public List list() throws IOException {
            List list = new List();
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<ProjectList> {
            private static final String REST_PATH = "projects";
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List() {
                super(Bigquery.this, "GET", REST_PATH, null, ProjectList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetServiceAccount
        extends BigqueryRequest<GetServiceAccountResponse> {
            private static final String REST_PATH = "projects/{projectId}/serviceAccount";
            @Key
            private String projectId;

            protected GetServiceAccount(String string) {
                super(Bigquery.this, "GET", REST_PATH, null, GetServiceAccountResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetServiceAccount setAlt(String string) {
                return (GetServiceAccount)super.setAlt(string);
            }

            public GetServiceAccount setFields(String string) {
                return (GetServiceAccount)super.setFields(string);
            }

            public GetServiceAccount setKey(String string) {
                return (GetServiceAccount)super.setKey(string);
            }

            public GetServiceAccount setOauthToken(String string) {
                return (GetServiceAccount)super.setOauthToken(string);
            }

            public GetServiceAccount setPrettyPrint(Boolean bl) {
                return (GetServiceAccount)super.setPrettyPrint(bl);
            }

            public GetServiceAccount setQuotaUser(String string) {
                return (GetServiceAccount)super.setQuotaUser(string);
            }

            public GetServiceAccount setUserIp(String string) {
                return (GetServiceAccount)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetServiceAccount setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public GetServiceAccount set(String string, Object object) {
                return (GetServiceAccount)super.set(string, object);
            }
        }
    }

    public class Models {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, Model model) throws IOException {
            Patch patch = new Patch(string, string2, string3, model);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends BigqueryRequest<Model> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Patch(String string, String string2, String string3, Model model) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)model, Model.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(string).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = string;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Patch setModelId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(string).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<ListModelsResponse> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, ListModelsResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(string).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest<Model> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Get(String string, String string2, String string3) {
                super(Bigquery.this, "GET", REST_PATH, null, Model.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(string).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = string;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Get setModelId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(string).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Delete(String string, String string2, String string3) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(string).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = string;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Delete setModelId(String string) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(string).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Jobs {
        public Cancel cancel(String string, String string2) throws IOException {
            Cancel cancel = new Cancel(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)cancel);
            return cancel;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetQueryResults getQueryResults(String string, String string2) throws IOException {
            GetQueryResults getQueryResults = new GetQueryResults(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)getQueryResults);
            return getQueryResults;
        }

        public Insert insert(String string, Job job) throws IOException {
            Insert insert = new Insert(string, job);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(String string, Job job, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string, job, abstractInputStreamContent);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Query query(String string, QueryRequest queryRequest) throws IOException {
            Query query = new Query(string, queryRequest);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)query);
            return query;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Query
        extends BigqueryRequest<QueryResponse> {
            private static final String REST_PATH = "projects/{projectId}/queries";
            @Key
            private String projectId;

            protected Query(String string, QueryRequest queryRequest) {
                super(Bigquery.this, "POST", REST_PATH, (Object)queryRequest, QueryResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Query setAlt(String string) {
                return (Query)super.setAlt(string);
            }

            public Query setFields(String string) {
                return (Query)super.setFields(string);
            }

            public Query setKey(String string) {
                return (Query)super.setKey(string);
            }

            public Query setOauthToken(String string) {
                return (Query)super.setOauthToken(string);
            }

            public Query setPrettyPrint(Boolean bl) {
                return (Query)super.setPrettyPrint(bl);
            }

            public Query setQuotaUser(String string) {
                return (Query)super.setQuotaUser(string);
            }

            public Query setUserIp(String string) {
                return (Query)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Query setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Query set(String string, Object object) {
                return (Query)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<JobList> {
            private static final String REST_PATH = "projects/{projectId}/jobs";
            @Key
            private String projectId;
            @Key
            private String projection;
            @Key
            private BigInteger minCreationTime;
            @Key
            private String pageToken;
            @Key
            private Boolean allUsers;
            @Key
            private BigInteger maxCreationTime;
            @Key
            private Long maxResults;
            @Key
            private java.util.List<String> stateFilter;

            protected List(String string) {
                super(Bigquery.this, "GET", REST_PATH, null, JobList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public BigInteger getMinCreationTime() {
                return this.minCreationTime;
            }

            public List setMinCreationTime(BigInteger bigInteger) {
                this.minCreationTime = bigInteger;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getAllUsers() {
                return this.allUsers;
            }

            public List setAllUsers(Boolean bl) {
                this.allUsers = bl;
                return this;
            }

            public BigInteger getMaxCreationTime() {
                return this.maxCreationTime;
            }

            public List setMaxCreationTime(BigInteger bigInteger) {
                this.maxCreationTime = bigInteger;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public java.util.List<String> getStateFilter() {
                return this.stateFilter;
            }

            public List setStateFilter(java.util.List<String> list) {
                this.stateFilter = list;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest<Job> {
            private static final String REST_PATH = "projects/{projectId}/jobs";
            @Key
            private String projectId;

            protected Insert(String string, Job job) {
                super(Bigquery.this, "POST", REST_PATH, (Object)job, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            protected Insert(String string, Job job, AbstractInputStreamContent abstractInputStreamContent) {
                super(Bigquery.this, "POST", "/upload/" + Bigquery.this.getServicePath() + REST_PATH, (Object)job, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetQueryResults
        extends BigqueryRequest<GetQueryResultsResponse> {
            private static final String REST_PATH = "projects/{projectId}/queries/{jobId}";
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private BigInteger startIndex;
            @Key
            private String location;
            @Key
            private String pageToken;
            @Key
            private Long timeoutMs;
            @Key
            private Long maxResults;

            protected GetQueryResults(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, GetQueryResultsResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetQueryResults setAlt(String string) {
                return (GetQueryResults)super.setAlt(string);
            }

            public GetQueryResults setFields(String string) {
                return (GetQueryResults)super.setFields(string);
            }

            public GetQueryResults setKey(String string) {
                return (GetQueryResults)super.setKey(string);
            }

            public GetQueryResults setOauthToken(String string) {
                return (GetQueryResults)super.setOauthToken(string);
            }

            public GetQueryResults setPrettyPrint(Boolean bl) {
                return (GetQueryResults)super.setPrettyPrint(bl);
            }

            public GetQueryResults setQuotaUser(String string) {
                return (GetQueryResults)super.setQuotaUser(string);
            }

            public GetQueryResults setUserIp(String string) {
                return (GetQueryResults)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetQueryResults setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public GetQueryResults setJobId(String string) {
                this.jobId = string;
                return this;
            }

            public BigInteger getStartIndex() {
                return this.startIndex;
            }

            public GetQueryResults setStartIndex(BigInteger bigInteger) {
                this.startIndex = bigInteger;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public GetQueryResults setLocation(String string) {
                this.location = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public GetQueryResults setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getTimeoutMs() {
                return this.timeoutMs;
            }

            public GetQueryResults setTimeoutMs(Long l) {
                this.timeoutMs = l;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public GetQueryResults setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public GetQueryResults set(String string, Object object) {
                return (GetQueryResults)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest<Job> {
            private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}";
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private String location;

            protected Get(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Get setJobId(String string) {
                this.jobId = string;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public Get setLocation(String string) {
                this.location = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Cancel
        extends BigqueryRequest<JobCancelResponse> {
            private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}/cancel";
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private String location;

            protected Cancel(String string, String string2) {
                super(Bigquery.this, "POST", REST_PATH, null, JobCancelResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
            }

            public Cancel setAlt(String string) {
                return (Cancel)super.setAlt(string);
            }

            public Cancel setFields(String string) {
                return (Cancel)super.setFields(string);
            }

            public Cancel setKey(String string) {
                return (Cancel)super.setKey(string);
            }

            public Cancel setOauthToken(String string) {
                return (Cancel)super.setOauthToken(string);
            }

            public Cancel setPrettyPrint(Boolean bl) {
                return (Cancel)super.setPrettyPrint(bl);
            }

            public Cancel setQuotaUser(String string) {
                return (Cancel)super.setQuotaUser(string);
            }

            public Cancel setUserIp(String string) {
                return (Cancel)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Cancel setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Cancel setJobId(String string) {
                this.jobId = string;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public Cancel setLocation(String string) {
                this.location = string;
                return this;
            }

            @Override
            public Cancel set(String string, Object object) {
                return (Cancel)super.set(string, object);
            }
        }
    }

    public class Datasets {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Dataset dataset) throws IOException {
            Insert insert = new Insert(string, dataset);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Dataset dataset) throws IOException {
            Patch patch = new Patch(string, string2, dataset);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Dataset dataset) throws IOException {
            Update update = new Update(string, string2, dataset);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Update(String string, String string2, Dataset dataset) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)dataset, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Patch(String string, String string2, Dataset dataset) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)dataset, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<DatasetList> {
            private static final String REST_PATH = "projects/{projectId}/datasets";
            @Key
            private String projectId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;
            @Key
            private Boolean all;
            @Key
            private String filter;

            protected List(String string) {
                super(Bigquery.this, "GET", REST_PATH, null, DatasetList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public Boolean getAll() {
                return this.all;
            }

            public List setAll(Boolean bl) {
                this.all = bl;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets";
            @Key
            private String projectId;

            protected Insert(String string, Dataset dataset) {
                super(Bigquery.this, "POST", REST_PATH, (Object)dataset, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Get(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Boolean deleteContents;

            protected Delete(String string, String string2) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public Boolean getDeleteContents() {
                return this.deleteContents;
            }

            public Delete setDeleteContents(Boolean bl) {
                this.deleteContents = bl;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

