/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Options related to script execution.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ScriptOptions extends com.google.api.client.json.GenericJson {

  /**
   * Determines which statement in the script represents the "key result", used to populate the
   * schema and query results of the script job. Default is LAST.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keyResultStatement;

  /**
   * Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long statementByteBudget;

  /**
   * Timeout period for each statement in a script.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long statementTimeoutMs;

  /**
   * Determines which statement in the script represents the "key result", used to populate the
   * schema and query results of the script job. Default is LAST.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeyResultStatement() {
    return keyResultStatement;
  }

  /**
   * Determines which statement in the script represents the "key result", used to populate the
   * schema and query results of the script job. Default is LAST.
   * @param keyResultStatement keyResultStatement or {@code null} for none
   */
  public ScriptOptions setKeyResultStatement(java.lang.String keyResultStatement) {
    this.keyResultStatement = keyResultStatement;
    return this;
  }

  /**
   * Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStatementByteBudget() {
    return statementByteBudget;
  }

  /**
   * Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
   * @param statementByteBudget statementByteBudget or {@code null} for none
   */
  public ScriptOptions setStatementByteBudget(java.lang.Long statementByteBudget) {
    this.statementByteBudget = statementByteBudget;
    return this;
  }

  /**
   * Timeout period for each statement in a script.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStatementTimeoutMs() {
    return statementTimeoutMs;
  }

  /**
   * Timeout period for each statement in a script.
   * @param statementTimeoutMs statementTimeoutMs or {@code null} for none
   */
  public ScriptOptions setStatementTimeoutMs(java.lang.Long statementTimeoutMs) {
    this.statementTimeoutMs = statementTimeoutMs;
    return this;
  }

  @Override
  public ScriptOptions set(String fieldName, Object value) {
    return (ScriptOptions) super.set(fieldName, value);
  }

  @Override
  public ScriptOptions clone() {
    return (ScriptOptions) super.clone();
  }

}
