/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Statistics for index pruning.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IndexPruningStats extends com.google.api.client.json.GenericJson {

  /**
   * The base table reference.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference baseTable;

  /**
   * The index id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String indexId;

  /**
   * The number of parallel inputs after index pruning.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long postIndexPruningParallelInputCount;

  /**
   * The number of parallel inputs before index pruning.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long preIndexPruningParallelInputCount;

  /**
   * The base table reference.
   * @return value or {@code null} for none
   */
  public TableReference getBaseTable() {
    return baseTable;
  }

  /**
   * The base table reference.
   * @param baseTable baseTable or {@code null} for none
   */
  public IndexPruningStats setBaseTable(TableReference baseTable) {
    this.baseTable = baseTable;
    return this;
  }

  /**
   * The index id.
   * @return value or {@code null} for none
   */
  public java.lang.String getIndexId() {
    return indexId;
  }

  /**
   * The index id.
   * @param indexId indexId or {@code null} for none
   */
  public IndexPruningStats setIndexId(java.lang.String indexId) {
    this.indexId = indexId;
    return this;
  }

  /**
   * The number of parallel inputs after index pruning.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPostIndexPruningParallelInputCount() {
    return postIndexPruningParallelInputCount;
  }

  /**
   * The number of parallel inputs after index pruning.
   * @param postIndexPruningParallelInputCount postIndexPruningParallelInputCount or {@code null} for none
   */
  public IndexPruningStats setPostIndexPruningParallelInputCount(java.lang.Long postIndexPruningParallelInputCount) {
    this.postIndexPruningParallelInputCount = postIndexPruningParallelInputCount;
    return this;
  }

  /**
   * The number of parallel inputs before index pruning.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPreIndexPruningParallelInputCount() {
    return preIndexPruningParallelInputCount;
  }

  /**
   * The number of parallel inputs before index pruning.
   * @param preIndexPruningParallelInputCount preIndexPruningParallelInputCount or {@code null} for none
   */
  public IndexPruningStats setPreIndexPruningParallelInputCount(java.lang.Long preIndexPruningParallelInputCount) {
    this.preIndexPruningParallelInputCount = preIndexPruningParallelInputCount;
    return this;
  }

  @Override
  public IndexPruningStats set(String fieldName, Object value) {
    return (IndexPruningStats) super.set(fieldName, value);
  }

  @Override
  public IndexPruningStats clone() {
    return (IndexPruningStats) super.clone();
  }

}
