/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Represents privacy policy associated with "join restrictions". Join restriction gives data
 * providers the ability to enforce joins on the 'join_allowed_columns' when data is queried from a
 * privacy protected view.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JoinRestrictionPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The only columns that joins are allowed on. This field is must be specified for
   * join_conditions JOIN_ANY and JOIN_ALL and it cannot be set for JOIN_BLOCKED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> joinAllowedColumns;

  /**
   * Optional. Specifies if a join is required or not on queries for the view. Default is
   * JOIN_CONDITION_UNSPECIFIED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String joinCondition;

  /**
   * Optional. The only columns that joins are allowed on. This field is must be specified for
   * join_conditions JOIN_ANY and JOIN_ALL and it cannot be set for JOIN_BLOCKED.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getJoinAllowedColumns() {
    return joinAllowedColumns;
  }

  /**
   * Optional. The only columns that joins are allowed on. This field is must be specified for
   * join_conditions JOIN_ANY and JOIN_ALL and it cannot be set for JOIN_BLOCKED.
   * @param joinAllowedColumns joinAllowedColumns or {@code null} for none
   */
  public JoinRestrictionPolicy setJoinAllowedColumns(java.util.List<java.lang.String> joinAllowedColumns) {
    this.joinAllowedColumns = joinAllowedColumns;
    return this;
  }

  /**
   * Optional. Specifies if a join is required or not on queries for the view. Default is
   * JOIN_CONDITION_UNSPECIFIED.
   * @return value or {@code null} for none
   */
  public java.lang.String getJoinCondition() {
    return joinCondition;
  }

  /**
   * Optional. Specifies if a join is required or not on queries for the view. Default is
   * JOIN_CONDITION_UNSPECIFIED.
   * @param joinCondition joinCondition or {@code null} for none
   */
  public JoinRestrictionPolicy setJoinCondition(java.lang.String joinCondition) {
    this.joinCondition = joinCondition;
    return this;
  }

  @Override
  public JoinRestrictionPolicy set(String fieldName, Object value) {
    return (JoinRestrictionPolicy) super.set(fieldName, value);
  }

  @Override
  public JoinRestrictionPolicy clone() {
    return (JoinRestrictionPolicy) super.clone();
  }

}
