/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Serializer and deserializer information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SerDeInfo extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Name of the SerDe. The maximum length is 256 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. Key-value pairs that define the initialization parameters for the serialization
   * library. Maximum size 10 Kib.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> parameters;

  /**
   * Required. Specifies a fully-qualified class name of the serialization library that is
   * responsible for the translation of data between table representation and the underlying low-
   * level input and output format structures. The maximum length is 256 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serializationLibrary;

  /**
   * Optional. Name of the SerDe. The maximum length is 256 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Optional. Name of the SerDe. The maximum length is 256 characters.
   * @param name name or {@code null} for none
   */
  public SerDeInfo setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. Key-value pairs that define the initialization parameters for the serialization
   * library. Maximum size 10 Kib.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getParameters() {
    return parameters;
  }

  /**
   * Optional. Key-value pairs that define the initialization parameters for the serialization
   * library. Maximum size 10 Kib.
   * @param parameters parameters or {@code null} for none
   */
  public SerDeInfo setParameters(java.util.Map<String, java.lang.String> parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * Required. Specifies a fully-qualified class name of the serialization library that is
   * responsible for the translation of data between table representation and the underlying low-
   * level input and output format structures. The maximum length is 256 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getSerializationLibrary() {
    return serializationLibrary;
  }

  /**
   * Required. Specifies a fully-qualified class name of the serialization library that is
   * responsible for the translation of data between table representation and the underlying low-
   * level input and output format structures. The maximum length is 256 characters.
   * @param serializationLibrary serializationLibrary or {@code null} for none
   */
  public SerDeInfo setSerializationLibrary(java.lang.String serializationLibrary) {
    this.serializationLibrary = serializationLibrary;
    return this;
  }

  @Override
  public SerDeInfo set(String fieldName, Object value) {
    return (SerDeInfo) super.set(fieldName, value);
  }

  @Override
  public SerDeInfo clone() {
    return (SerDeInfo) super.clone();
  }

}
