/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Request format for undeleting a dataset.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UndeleteDatasetRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The exact time when the dataset was deleted. If not specified, it will undelete the
   * most recently deleted version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String deletionTime;

  /**
   * Optional. The exact time when the dataset was deleted. If not specified, it will undelete the
   * most recently deleted version.
   * @return value or {@code null} for none
   */
  public String getDeletionTime() {
    return deletionTime;
  }

  /**
   * Optional. The exact time when the dataset was deleted. If not specified, it will undelete the
   * most recently deleted version.
   * @param deletionTime deletionTime or {@code null} for none
   */
  public UndeleteDatasetRequest setDeletionTime(String deletionTime) {
    this.deletionTime = deletionTime;
    return this;
  }

  @Override
  public UndeleteDatasetRequest set(String fieldName, Object value) {
    return (UndeleteDatasetRequest) super.set(fieldName, value);
  }

  @Override
  public UndeleteDatasetRequest clone() {
    return (UndeleteDatasetRequest) super.clone();
  }

}
