/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for SparkStatistics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SparkStatistics extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only] Endpoints generated for the Spark job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> endpoints;

  /**
   * [Output-only] Logging info is used to generate a link to Cloud Logging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SparkLoggingInfo loggingInfo;

  /**
   * [Output-only] Spark job id if a Spark job is created successfully.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sparkJobId;

  /**
   * [Output-only] Location where the Spark job is executed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sparkJobLocation;

  /**
   * [Output-only] Endpoints generated for the Spark job.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getEndpoints() {
    return endpoints;
  }

  /**
   * [Output-only] Endpoints generated for the Spark job.
   * @param endpoints endpoints or {@code null} for none
   */
  public SparkStatistics setEndpoints(java.util.Map<String, java.lang.String> endpoints) {
    this.endpoints = endpoints;
    return this;
  }

  /**
   * [Output-only] Logging info is used to generate a link to Cloud Logging.
   * @return value or {@code null} for none
   */
  public SparkLoggingInfo getLoggingInfo() {
    return loggingInfo;
  }

  /**
   * [Output-only] Logging info is used to generate a link to Cloud Logging.
   * @param loggingInfo loggingInfo or {@code null} for none
   */
  public SparkStatistics setLoggingInfo(SparkLoggingInfo loggingInfo) {
    this.loggingInfo = loggingInfo;
    return this;
  }

  /**
   * [Output-only] Spark job id if a Spark job is created successfully.
   * @return value or {@code null} for none
   */
  public java.lang.String getSparkJobId() {
    return sparkJobId;
  }

  /**
   * [Output-only] Spark job id if a Spark job is created successfully.
   * @param sparkJobId sparkJobId or {@code null} for none
   */
  public SparkStatistics setSparkJobId(java.lang.String sparkJobId) {
    this.sparkJobId = sparkJobId;
    return this;
  }

  /**
   * [Output-only] Location where the Spark job is executed.
   * @return value or {@code null} for none
   */
  public java.lang.String getSparkJobLocation() {
    return sparkJobLocation;
  }

  /**
   * [Output-only] Location where the Spark job is executed.
   * @param sparkJobLocation sparkJobLocation or {@code null} for none
   */
  public SparkStatistics setSparkJobLocation(java.lang.String sparkJobLocation) {
    this.sparkJobLocation = sparkJobLocation;
    return this;
  }

  @Override
  public SparkStatistics set(String fieldName, Object value) {
    return (SparkStatistics) super.set(fieldName, value);
  }

  @Override
  public SparkStatistics clone() {
    return (SparkStatistics) super.clone();
  }

}
