/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for BigLakeConfiguration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BigLakeConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * [Required] Required and immutable. Credential reference for accessing external storage system.
   * Normalized as project_id.location_id.connection_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connectionId;

  /**
   * [Required] Required and immutable. Open source file format that the table data is stored in.
   * Currently only PARQUET is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileFormat;

  /**
   * [Required] Required and immutable. Fully qualified location prefix of the external folder where
   * data is stored. Normalized to standard format: "gs:/". Starts with "gs://" rather than
   * "/bigstore/". Ends with "/". Does not contain "*". See also BigLakeStorageMetadata on how it is
   * used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storageUri;

  /**
   * [Required] Required and immutable. Open source file format that the table data is stored in.
   * Currently only PARQUET is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tableFormat;

  /**
   * [Required] Required and immutable. Credential reference for accessing external storage system.
   * Normalized as project_id.location_id.connection_id.
   * @return value or {@code null} for none
   */
  public java.lang.String getConnectionId() {
    return connectionId;
  }

  /**
   * [Required] Required and immutable. Credential reference for accessing external storage system.
   * Normalized as project_id.location_id.connection_id.
   * @param connectionId connectionId or {@code null} for none
   */
  public BigLakeConfiguration setConnectionId(java.lang.String connectionId) {
    this.connectionId = connectionId;
    return this;
  }

  /**
   * [Required] Required and immutable. Open source file format that the table data is stored in.
   * Currently only PARQUET is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileFormat() {
    return fileFormat;
  }

  /**
   * [Required] Required and immutable. Open source file format that the table data is stored in.
   * Currently only PARQUET is supported.
   * @param fileFormat fileFormat or {@code null} for none
   */
  public BigLakeConfiguration setFileFormat(java.lang.String fileFormat) {
    this.fileFormat = fileFormat;
    return this;
  }

  /**
   * [Required] Required and immutable. Fully qualified location prefix of the external folder where
   * data is stored. Normalized to standard format: "gs:/". Starts with "gs://" rather than
   * "/bigstore/". Ends with "/". Does not contain "*". See also BigLakeStorageMetadata on how it is
   * used.
   * @return value or {@code null} for none
   */
  public java.lang.String getStorageUri() {
    return storageUri;
  }

  /**
   * [Required] Required and immutable. Fully qualified location prefix of the external folder where
   * data is stored. Normalized to standard format: "gs:/". Starts with "gs://" rather than
   * "/bigstore/". Ends with "/". Does not contain "*". See also BigLakeStorageMetadata on how it is
   * used.
   * @param storageUri storageUri or {@code null} for none
   */
  public BigLakeConfiguration setStorageUri(java.lang.String storageUri) {
    this.storageUri = storageUri;
    return this;
  }

  /**
   * [Required] Required and immutable. Open source file format that the table data is stored in.
   * Currently only PARQUET is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getTableFormat() {
    return tableFormat;
  }

  /**
   * [Required] Required and immutable. Open source file format that the table data is stored in.
   * Currently only PARQUET is supported.
   * @param tableFormat tableFormat or {@code null} for none
   */
  public BigLakeConfiguration setTableFormat(java.lang.String tableFormat) {
    this.tableFormat = tableFormat;
    return this;
  }

  @Override
  public BigLakeConfiguration set(String fieldName, Object value) {
    return (BigLakeConfiguration) super.set(fieldName, value);
  }

  @Override
  public BigLakeConfiguration clone() {
    return (BigLakeConfiguration) super.clone();
  }

}
