/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Range of a double hyperparameter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DoubleRange extends com.google.api.client.json.GenericJson {

  /**
   * Max value of the double parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double max;

  /**
   * Min value of the double parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double min;

  /**
   * Max value of the double parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMax() {
    return max;
  }

  /**
   * Max value of the double parameter.
   * @param max max or {@code null} for none
   */
  public DoubleRange setMax(java.lang.Double max) {
    this.max = max;
    return this;
  }

  /**
   * Min value of the double parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMin() {
    return min;
  }

  /**
   * Min value of the double parameter.
   * @param min min or {@code null} for none
   */
  public DoubleRange setMin(java.lang.Double min) {
    this.min = min;
    return this;
  }

  @Override
  public DoubleRange set(String fieldName, Object value) {
    return (DoubleRange) super.set(fieldName, value);
  }

  @Override
  public DoubleRange clone() {
    return (DoubleRange) super.clone();
  }

}
