/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.bigquery;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.bigquery.BigqueryRequest;
import com.google.api.services.bigquery.BigqueryRequestInitializer;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.GetIamPolicyRequest;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.GetServiceAccountResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobCancelResponse;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.ListModelsResponse;
import com.google.api.services.bigquery.model.ListRoutinesResponse;
import com.google.api.services.bigquery.model.ListRowAccessPoliciesResponse;
import com.google.api.services.bigquery.model.Model;
import com.google.api.services.bigquery.model.Policy;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Routine;
import com.google.api.services.bigquery.model.SetIamPolicyRequest;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TestIamPermissionsRequest;
import com.google.api.services.bigquery.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Pattern;

public class Bigquery
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://bigquery.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://bigquery.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "bigquery/v2/";
    public static final String DEFAULT_BATCH_PATH = "batch/bigquery/v2";
    public static final String DEFAULT_BASE_URL = "https://bigquery.googleapis.com/bigquery/v2/";

    public Bigquery(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Bigquery(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Datasets datasets() {
        return new Datasets();
    }

    public Jobs jobs() {
        return new Jobs();
    }

    public Models models() {
        return new Models();
    }

    public Projects projects() {
        return new Projects();
    }

    public Routines routines() {
        return new Routines();
    }

    public RowAccessPolicies rowAccessPolicies() {
        return new RowAccessPolicies();
    }

    public Tabledata tabledata() {
        return new Tabledata();
    }

    public Tables tables() {
        return new Tables();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the BigQuery API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Bigquery.DEFAULT_MTLS_ROOT_URL;
            }
            return Bigquery.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Bigquery.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Bigquery.DEFAULT_BATCH_PATH);
        }

        public Bigquery build() {
            return new Bigquery(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setBigqueryRequestInitializer(BigqueryRequestInitializer bigqueryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)bigqueryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Tables {
        public Delete delete(String projectId, String datasetId, String tableId) throws IOException {
            Delete result = new Delete(projectId, datasetId, tableId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId, String tableId) throws IOException {
            Get result = new Get(projectId, datasetId, tableId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, String datasetId, Table content) throws IOException {
            Insert result = new Insert(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId) throws IOException {
            List result = new List(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String projectId, String datasetId, String tableId, Table content) throws IOException {
            Patch result = new Patch(projectId, datasetId, tableId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, String datasetId, String tableId, Table content) throws IOException {
            Update result = new Update(projectId, datasetId, tableId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Update(String projectId, String datasetId, String tableId, Table content) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)content, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Update setTableId(String tableId) {
                this.tableId = tableId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends BigqueryRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUserIp(String userIp) {
                return (SetIamPolicy)super.setUserIp(userIp);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Patch
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Patch(String projectId, String datasetId, String tableId, Table content) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)content, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Patch setTableId(String tableId) {
                this.tableId = tableId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<TableList> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String projectId, String datasetId) {
                super(Bigquery.this, "GET", REST_PATH, null, TableList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Insert(String projectId, String datasetId, Table content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Insert setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUserIp(String userIp) {
                return (GetIamPolicy)super.setUserIp(userIp);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private String selectedFields;

            protected Get(String projectId, String datasetId, String tableId) {
                super(Bigquery.this, "GET", REST_PATH, null, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Get setTableId(String tableId) {
                this.tableId = tableId;
                return this;
            }

            public String getSelectedFields() {
                return this.selectedFields;
            }

            public Get setSelectedFields(String selectedFields) {
                this.selectedFields = selectedFields;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Delete(String projectId, String datasetId, String tableId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Delete setTableId(String tableId) {
                this.tableId = tableId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Tabledata {
        public InsertAll insertAll(String projectId, String datasetId, String tableId, TableDataInsertAllRequest content) throws IOException {
            InsertAll result = new InsertAll(projectId, datasetId, tableId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId, String tableId) throws IOException {
            List result = new List(projectId, datasetId, tableId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends BigqueryRequest<TableDataList> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/data";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String selectedFields;
            @Key
            private BigInteger startIndex;

            protected List(String projectId, String datasetId, String tableId) {
                super(Bigquery.this, "GET", REST_PATH, null, TableDataList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public List setTableId(String tableId) {
                this.tableId = tableId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSelectedFields() {
                return this.selectedFields;
            }

            public List setSelectedFields(String selectedFields) {
                this.selectedFields = selectedFields;
                return this;
            }

            public BigInteger getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(BigInteger startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class InsertAll
        extends BigqueryRequest<TableDataInsertAllResponse> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/insertAll";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected InsertAll(String projectId, String datasetId, String tableId, TableDataInsertAllRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, TableDataInsertAllResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
            }

            public InsertAll setAlt(String alt) {
                return (InsertAll)super.setAlt(alt);
            }

            public InsertAll setFields(String fields) {
                return (InsertAll)super.setFields(fields);
            }

            public InsertAll setKey(String key) {
                return (InsertAll)super.setKey(key);
            }

            public InsertAll setOauthToken(String oauthToken) {
                return (InsertAll)super.setOauthToken(oauthToken);
            }

            public InsertAll setPrettyPrint(Boolean prettyPrint) {
                return (InsertAll)super.setPrettyPrint(prettyPrint);
            }

            public InsertAll setQuotaUser(String quotaUser) {
                return (InsertAll)super.setQuotaUser(quotaUser);
            }

            public InsertAll setUserIp(String userIp) {
                return (InsertAll)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public InsertAll setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public InsertAll setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public InsertAll setTableId(String tableId) {
                this.tableId = tableId;
                return this;
            }

            @Override
            public InsertAll set(String parameterName, Object value) {
                return (InsertAll)super.set(parameterName, value);
            }
        }
    }

    public class RowAccessPolicies {
        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId, String tableId) throws IOException {
            List result = new List(projectId, datasetId, tableId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends BigqueryRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUserIp(String userIp) {
                return (SetIamPolicy)super.setUserIp(userIp);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<ListRowAccessPoliciesResponse> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern TABLE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String projectId, String datasetId, String tableId) {
                super(Bigquery.this, "GET", REST_PATH, null, ListRowAccessPoliciesResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.TABLE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.tableId = (String)Preconditions.checkNotNull((Object)tableId, (Object)"Required parameter tableId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public List setTableId(String tableId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TABLE_ID_PATTERN.matcher(tableId).matches(), (Object)"Parameter tableId must conform to the pattern ^[^/]+$");
                }
                this.tableId = tableId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends BigqueryRequest<Policy> {
            private static final String REST_PATH = "{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUserIp(String userIp) {
                return (GetIamPolicy)super.setUserIp(userIp);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }
    }

    public class Routines {
        public Delete delete(String projectId, String datasetId, String routineId) throws IOException {
            Delete result = new Delete(projectId, datasetId, routineId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId, String routineId) throws IOException {
            Get result = new Get(projectId, datasetId, routineId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, String datasetId, Routine content) throws IOException {
            Insert result = new Insert(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId) throws IOException {
            List result = new List(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, String datasetId, String routineId, Routine content) throws IOException {
            Update result = new Update(projectId, datasetId, routineId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BigqueryRequest<Routine> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern ROUTINE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String routineId;

            protected Update(String projectId, String datasetId, String routineId, Routine content) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)content, Routine.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.ROUTINE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.routineId = (String)Preconditions.checkNotNull((Object)routineId, (Object)"Required parameter routineId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getRoutineId() {
                return this.routineId;
            }

            public Update setRoutineId(String routineId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
                this.routineId = routineId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<ListRoutinesResponse> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String readMask;

            protected List(String projectId, String datasetId) {
                super(Bigquery.this, "GET", REST_PATH, null, ListRoutinesResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public List setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<Routine> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Insert(String projectId, String datasetId, Routine content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Routine.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Insert setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Routine> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern ROUTINE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String routineId;
            @Key
            private String readMask;

            protected Get(String projectId, String datasetId, String routineId) {
                super(Bigquery.this, "GET", REST_PATH, null, Routine.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.ROUTINE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.routineId = (String)Preconditions.checkNotNull((Object)routineId, (Object)"Required parameter routineId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getRoutineId() {
                return this.routineId;
            }

            public Get setRoutineId(String routineId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
                this.routineId = routineId;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public Get setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern ROUTINE_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String routineId;

            protected Delete(String projectId, String datasetId, String routineId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.ROUTINE_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.routineId = (String)Preconditions.checkNotNull((Object)routineId, (Object)"Required parameter routineId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getRoutineId() {
                return this.routineId;
            }

            public Delete setRoutineId(String routineId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTINE_ID_PATTERN.matcher(routineId).matches(), (Object)"Parameter routineId must conform to the pattern ^[^/]+$");
                }
                this.routineId = routineId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public GetServiceAccount getServiceAccount(String projectId) throws IOException {
            GetServiceAccount result = new GetServiceAccount(projectId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends BigqueryRequest<ProjectList> {
            private static final String REST_PATH = "projects";
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List() {
                super(Bigquery.this, "GET", REST_PATH, null, ProjectList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetServiceAccount
        extends BigqueryRequest<GetServiceAccountResponse> {
            private static final String REST_PATH = "projects/{projectId}/serviceAccount";
            @Key
            private String projectId;

            protected GetServiceAccount(String projectId) {
                super(Bigquery.this, "GET", REST_PATH, null, GetServiceAccountResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetServiceAccount setAlt(String alt) {
                return (GetServiceAccount)super.setAlt(alt);
            }

            public GetServiceAccount setFields(String fields) {
                return (GetServiceAccount)super.setFields(fields);
            }

            public GetServiceAccount setKey(String key) {
                return (GetServiceAccount)super.setKey(key);
            }

            public GetServiceAccount setOauthToken(String oauthToken) {
                return (GetServiceAccount)super.setOauthToken(oauthToken);
            }

            public GetServiceAccount setPrettyPrint(Boolean prettyPrint) {
                return (GetServiceAccount)super.setPrettyPrint(prettyPrint);
            }

            public GetServiceAccount setQuotaUser(String quotaUser) {
                return (GetServiceAccount)super.setQuotaUser(quotaUser);
            }

            public GetServiceAccount setUserIp(String userIp) {
                return (GetServiceAccount)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetServiceAccount setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public GetServiceAccount set(String parameterName, Object value) {
                return (GetServiceAccount)super.set(parameterName, value);
            }
        }
    }

    public class Models {
        public Delete delete(String projectId, String datasetId, String modelId) throws IOException {
            Delete result = new Delete(projectId, datasetId, modelId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId, String modelId) throws IOException {
            Get result = new Get(projectId, datasetId, modelId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId, String datasetId) throws IOException {
            List result = new List(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String projectId, String datasetId, String modelId, Model content) throws IOException {
            Patch result = new Patch(projectId, datasetId, modelId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends BigqueryRequest<Model> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Patch(String projectId, String datasetId, String modelId, Model content) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)content, Model.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)modelId, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Patch setModelId(String modelId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = modelId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<ListModelsResponse> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String projectId, String datasetId) {
                super(Bigquery.this, "GET", REST_PATH, null, ListModelsResponse.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Model> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Get(String projectId, String datasetId, String modelId) {
                super(Bigquery.this, "GET", REST_PATH, null, Model.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)modelId, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Get setModelId(String modelId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = modelId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";
            private final Pattern PROJECT_ID_PATTERN;
            private final Pattern DATASET_ID_PATTERN;
            private final Pattern MODEL_ID_PATTERN;
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String modelId;

            protected Delete(String projectId, String datasetId, String modelId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.DATASET_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.MODEL_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.modelId = (String)Preconditions.checkNotNull((Object)modelId, (Object)"Required parameter modelId must be specified.");
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)"Parameter projectId must conform to the pattern ^[^/]+$");
                }
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATASET_ID_PATTERN.matcher(datasetId).matches(), (Object)"Parameter datasetId must conform to the pattern ^[^/]+$");
                }
                this.datasetId = datasetId;
                return this;
            }

            public String getModelId() {
                return this.modelId;
            }

            public Delete setModelId(String modelId) {
                if (!Bigquery.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MODEL_ID_PATTERN.matcher(modelId).matches(), (Object)"Parameter modelId must conform to the pattern ^[^/]+$");
                }
                this.modelId = modelId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Jobs {
        public Cancel cancel(String projectId, String jobId) throws IOException {
            Cancel result = new Cancel(projectId, jobId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String jobId) throws IOException {
            Get result = new Get(projectId, jobId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetQueryResults getQueryResults(String projectId, String jobId) throws IOException {
            GetQueryResults result = new GetQueryResults(projectId, jobId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, Job content) throws IOException {
            Insert result = new Insert(projectId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, Job content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(projectId, content, mediaContent);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId) throws IOException {
            List result = new List(projectId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Query query(String projectId, QueryRequest content) throws IOException {
            Query result = new Query(projectId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Query
        extends BigqueryRequest<QueryResponse> {
            private static final String REST_PATH = "projects/{projectId}/queries";
            @Key
            private String projectId;

            protected Query(String projectId, QueryRequest content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, QueryResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Query setAlt(String alt) {
                return (Query)super.setAlt(alt);
            }

            public Query setFields(String fields) {
                return (Query)super.setFields(fields);
            }

            public Query setKey(String key) {
                return (Query)super.setKey(key);
            }

            public Query setOauthToken(String oauthToken) {
                return (Query)super.setOauthToken(oauthToken);
            }

            public Query setPrettyPrint(Boolean prettyPrint) {
                return (Query)super.setPrettyPrint(prettyPrint);
            }

            public Query setQuotaUser(String quotaUser) {
                return (Query)super.setQuotaUser(quotaUser);
            }

            public Query setUserIp(String userIp) {
                return (Query)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Query setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Query set(String parameterName, Object value) {
                return (Query)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<JobList> {
            private static final String REST_PATH = "projects/{projectId}/jobs";
            @Key
            private String projectId;
            @Key
            private Boolean allUsers;
            @Key
            private BigInteger maxCreationTime;
            @Key
            private Long maxResults;
            @Key
            private BigInteger minCreationTime;
            @Key
            private String pageToken;
            @Key
            private String parentJobId;
            @Key
            private String projection;
            @Key
            private java.util.List<String> stateFilter;

            protected List(String projectId) {
                super(Bigquery.this, "GET", REST_PATH, null, JobList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public Boolean getAllUsers() {
                return this.allUsers;
            }

            public List setAllUsers(Boolean allUsers) {
                this.allUsers = allUsers;
                return this;
            }

            public BigInteger getMaxCreationTime() {
                return this.maxCreationTime;
            }

            public List setMaxCreationTime(BigInteger maxCreationTime) {
                this.maxCreationTime = maxCreationTime;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public BigInteger getMinCreationTime() {
                return this.minCreationTime;
            }

            public List setMinCreationTime(BigInteger minCreationTime) {
                this.minCreationTime = minCreationTime;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getParentJobId() {
                return this.parentJobId;
            }

            public List setParentJobId(String parentJobId) {
                this.parentJobId = parentJobId;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public java.util.List<String> getStateFilter() {
                return this.stateFilter;
            }

            public List setStateFilter(java.util.List<String> stateFilter) {
                this.stateFilter = stateFilter;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<Job> {
            private static final String REST_PATH = "projects/{projectId}/jobs";
            @Key
            private String projectId;

            protected Insert(String projectId, Job content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            protected Insert(String projectId, Job content, AbstractInputStreamContent mediaContent) {
                super(Bigquery.this, "POST", "/upload/" + Bigquery.this.getServicePath() + REST_PATH, (Object)content, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetQueryResults
        extends BigqueryRequest<GetQueryResultsResponse> {
            private static final String REST_PATH = "projects/{projectId}/queries/{jobId}";
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private String location;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private BigInteger startIndex;
            @Key
            private Long timeoutMs;

            protected GetQueryResults(String projectId, String jobId) {
                super(Bigquery.this, "GET", REST_PATH, null, GetQueryResultsResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetQueryResults setAlt(String alt) {
                return (GetQueryResults)super.setAlt(alt);
            }

            public GetQueryResults setFields(String fields) {
                return (GetQueryResults)super.setFields(fields);
            }

            public GetQueryResults setKey(String key) {
                return (GetQueryResults)super.setKey(key);
            }

            public GetQueryResults setOauthToken(String oauthToken) {
                return (GetQueryResults)super.setOauthToken(oauthToken);
            }

            public GetQueryResults setPrettyPrint(Boolean prettyPrint) {
                return (GetQueryResults)super.setPrettyPrint(prettyPrint);
            }

            public GetQueryResults setQuotaUser(String quotaUser) {
                return (GetQueryResults)super.setQuotaUser(quotaUser);
            }

            public GetQueryResults setUserIp(String userIp) {
                return (GetQueryResults)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetQueryResults setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public GetQueryResults setJobId(String jobId) {
                this.jobId = jobId;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public GetQueryResults setLocation(String location) {
                this.location = location;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public GetQueryResults setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public GetQueryResults setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public BigInteger getStartIndex() {
                return this.startIndex;
            }

            public GetQueryResults setStartIndex(BigInteger startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            public Long getTimeoutMs() {
                return this.timeoutMs;
            }

            public GetQueryResults setTimeoutMs(Long timeoutMs) {
                this.timeoutMs = timeoutMs;
                return this;
            }

            @Override
            public GetQueryResults set(String parameterName, Object value) {
                return (GetQueryResults)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Job> {
            private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}";
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private String location;

            protected Get(String projectId, String jobId) {
                super(Bigquery.this, "GET", REST_PATH, null, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Get setJobId(String jobId) {
                this.jobId = jobId;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public Get setLocation(String location) {
                this.location = location;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends BigqueryRequest<JobCancelResponse> {
            private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}/cancel";
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private String location;

            protected Cancel(String projectId, String jobId) {
                super(Bigquery.this, "POST", REST_PATH, null, JobCancelResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"Required parameter jobId must be specified.");
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUserIp(String userIp) {
                return (Cancel)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Cancel setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Cancel setJobId(String jobId) {
                this.jobId = jobId;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public Cancel setLocation(String location) {
                this.location = location;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }

    public class Datasets {
        public Delete delete(String projectId, String datasetId) throws IOException {
            Delete result = new Delete(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId, String datasetId) throws IOException {
            Get result = new Get(projectId, datasetId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String projectId, Dataset content) throws IOException {
            Insert result = new Insert(projectId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String projectId) throws IOException {
            List result = new List(projectId);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String projectId, String datasetId, Dataset content) throws IOException {
            Patch result = new Patch(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, String datasetId, Dataset content) throws IOException {
            Update result = new Update(projectId, datasetId, content);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Update(String projectId, String datasetId, Dataset content) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)content, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Patch(String projectId, String datasetId, Dataset content) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)content, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends BigqueryRequest<DatasetList> {
            private static final String REST_PATH = "projects/{projectId}/datasets";
            @Key
            private String projectId;
            @Key
            private Boolean all;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String projectId) {
                super(Bigquery.this, "GET", REST_PATH, null, DatasetList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public Boolean getAll() {
                return this.all;
            }

            public List setAll(Boolean all) {
                this.all = all;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets";
            @Key
            private String projectId;

            protected Insert(String projectId, Dataset content) {
                super(Bigquery.this, "POST", REST_PATH, (Object)content, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Get(String projectId, String datasetId) {
                super(Bigquery.this, "GET", REST_PATH, null, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Boolean deleteContents;

            protected Delete(String projectId, String datasetId) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public Boolean getDeleteContents() {
                return this.deleteContents;
            }

            public Delete setDeleteContents(Boolean deleteContents) {
                this.deleteContents = deleteContents;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

